<?php 
require_once('vendor/autoload.php');
$apiKey = 'reelly-682aec0a-lZrRJKuUhhm5XSENG3zeptXTRwhW5ZtJ';
$cacheFile = __DIR__ . '/cached_projects.json';
$cacheDuration = 3600; // 1 hour

if (file_exists($cacheFile) && (time() - filemtime($cacheFile)) < $cacheDuration) {
    // Load from cache
    $collectedData = json_decode(file_get_contents($cacheFile), true);
} else {
    // Make fresh API calls
    $client = new \GuzzleHttp\Client([
        'headers' => [
            'X-API-Key' =>  $apiKey,
            'Accept'    => 'application/json',
        ],
    ]);

    $keysToFetch = [
        'architecture',
        'amenities',
        'facilities',
        'area',
        'overview',
        'min_price_aed',
        'coordinates',
        'developer',
        'developer_data',
        'payment_plans',
        'unit_blocks',
        'master_plan',
        'name',
        'cover_image_url',
        'completion_datetime',
        'payment_plans',
    ];

    $response = $client->request('GET', 'https://search-listings-production.up.railway.app/v1/properties');
    $projects = json_decode($response->getBody(), true);

    $collectedData = [];

    if (!empty($projects['items']) && is_array($projects['items'])) {
        foreach ($projects['items'] as $item) {
            $projectId = $item['id'];
            $detailResp = $client->request('GET', "https://search-listings-production.up.railway.app/v1/properties/{$projectId}");
            $subDetails = json_decode($detailResp->getBody(), true);

            $dataForProject = [];
            foreach ($keysToFetch as $key) {
                $dataForProject[$key] = $subDetails[$key] ?? null;
            }

            $collectedData[$projectId] = $dataForProject;
        }
    }

    // Save to cache
    file_put_contents($cacheFile, json_encode($collectedData));
}
// Step 5: Send to external API
try {
    $postClient = new \GuzzleHttp\Client();
    $res = $postClient->request('POST', 'http://dsq.rsworkspace.com/api/insert_offplan/api_insert', [
        'form_params' => [
            'data' => json_encode($collectedData),
        ]
    ]);

    echo "<p>Data sent successfully. Status: " . $res->getStatusCode() . "</p>";
    echo "<pre>" . $res->getBody() . "</pre>";
} catch (\GuzzleHttp\Exception\RequestException $e) {
    echo "<p>Error sending data:</p>";
    echo "<pre>" . $e->getMessage() . "</pre>";
} 