<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * ArticlesController
 * 
 * Handles the actions for artciles related tasks
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class ProjectController extends Controller
{
    /**
     * List available published articles 
     */
    public $headerImage;
    public $activeUrl;
    public $showContact = true ;
    function get_web_page( $url )
{
    $options = array(
        CURLOPT_RETURNTRANSFER => true,     // return web page
        CURLOPT_HEADER         => false,    // don't return headers
        CURLOPT_FOLLOWLOCATION => true,     // follow redirects
        CURLOPT_ENCODING       => "",       // handle all encodings
        CURLOPT_USERAGENT      => "spider", // who am i
        CURLOPT_AUTOREFERER    => true,     // set referer on redirect
        CURLOPT_CONNECTTIMEOUT => 120,      // timeout on connect
        CURLOPT_TIMEOUT        => 120,      // timeout on response
        CURLOPT_MAXREDIRS      => 10,       // stop after 10 redirects
        CURLOPT_SSL_VERIFYPEER => false     // Disabled SSL Cert checks
    );

    $ch      = curl_init( $url );
    curl_setopt_array( $ch, $options );
    $content = curl_exec( $ch );
    $err     = curl_errno( $ch );
    $errmsg  = curl_error( $ch );
    $header  = curl_getinfo( $ch );
    curl_close( $ch );

    $header['errno']   = $err;
    $header['errmsg']  = $errmsg;
    $header['content'] = $content;
    return $header;
}
public function actionGetMap(){
    $url =  $this->get_web_page('https://geocode.xyz/25.13188600,55.18447100?geoit=xml');
   
    print_r($url);exit; 

}
    public function actionIndex()
    {
  
		$this->activeUrl ="project";
		$this->layout =   Yii::app()->LayoutClass->layoutpath("sub");
		$this->headerImage  =  Yii::app()->theme->baseUrl.'/images/sale.jpg';
        $criteria = new CDbCriteria();
        $criteria->order = 't.name ASC';
        //$criteria->with = array('categories') ;
        $criteria->condition = 't.status="A" and  isTrash="0"';
        
        $count = Property::model()->count($criteria);
        $pages = new CPagination($count);
        $pages->pageSize = 5;
        $pages->applyLimit($criteria);
        $articles = Property::model()->findAll($criteria);
        
       
        $this->setData(array(
            'pageMetaTitle'     =>  'New Developments', 
            'pageBreadcrumbs'   => array()
        ));

        $this->render(Yii::app()->LayoutClass->viewpath("index"), compact('articles', 'pages','count'));
    }
    
    public function actionDetail($slug="")
    {
		 
		$this->layout =  Yii::app()->LayoutClass->layoutpath("detail"); 
	 
        $article = $this->loadArticleModel($slug);
        if(empty($article))
		{
		  
			throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
		 }
	 
	  
         $list = Property::model()->getDelvelopmentList($article->id);
         $relatedProject = Project::model()->ListDataWithProperty($article->id);
        
        
        $this->setData(array(
            'pageMetaTitle'         => $this->data->pageMetaTitle . ' | ' . $article->name,
            'pageMetaDescription'   => StringHelper::truncateLength($article->description, 150),
        ));
    
        $this->render(Yii::app()->LayoutClass->viewpath("view"), compact('article','list','relatedProject'));
	}
    public function actionFloor_detail($slug="")
    {
 
		 
	     $model = 	Project::model()->findByAttributes(array(
				    'slug'		=> $slug,
				    'isTrash'   => '0',
				    'status'    => 'A',
			    	) );
	 
	 	 $this->layout =  Yii::app()->LayoutClass->layoutpath("detail"); 
         if(empty($model))
		 {
			 
		    $plan = FloorPlan::model()->findByAttributes(array('slug'=>$slug,'isTrash'=>'0','status'=>'A') );
            if(empty($plan))
		    {
			throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
			}
		 }
		 else
		 {
			 
		 
		 $plan = FloorPlan::model()->findByAttributes(array('project_id'=>$model->project_id,'isTrash'=>'0','status'=>'A'),array('order'=>'floor_plan_id asc'));
	     if(empty($plan))
		 {
		 throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
		 }
        
	     }
	      $list = FloorPlan::model()->findAllByAttributes(array('project_id'=>$plan->project_id,'isTrash'=>'0','status'=>'A'),array('order'=>'floor_plan_id asc'));
        
        
        
        $this->setData(array(
            'pageMetaTitle'         => $this->data->pageMetaTitle . ' | ' . $plan->project1->project_name.' - '.$plan->floor_plan_name,
            'pageMetaDescription'   => StringHelper::truncateLength($plan->description, 150),
        ));
    
        $this->render(Yii::app()->LayoutClass->viewpath("floorDetail"), compact('plan','list' ));
	}
    /**
     * List available published articles belonging to a category
     */
    public function actionCategory($slug)
    {
        $category = $this->loadCategoryModel($slug);
        
        $criteria = new CDbCriteria();
        $criteria->compare('t.status', Article::STATUS_PUBLISHED);
        $criteria->with = array(
            'activeCategories' => array(
                'select'    => 'activeCategories.category_id',
                'together'  => true,
                'joinType'  => 'INNER JOIN',
                'condition' => 'activeCategories.category_id = :cid',
                'params'    => array(':cid' => $category->category_id),
            )
        );
        $criteria->order = 't.article_id DESC';
        
        $count = Article::model()->count($criteria);
        
        $pages = new CPagination($count);
        $pages->pageSize = 2;
        $pages->applyLimit($criteria);
        
        $articles = Article::model()->findAll($criteria);

        $this->setData(array(
            'pageMetaTitle'         => $this->data->pageMetaTitle . ' | ' . $category->name,
            'pageMetaDescription'   => StringHelper::truncateLength($category->description, 150),
        ));
        
        Yii::app()->clientScript->registerLinkTag('canonical', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
        Yii::app()->clientScript->registerLinkTag('shortlink', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
        
        $this->render('category', compact('category', 'articles', 'pages'));
    }
    
    /**
     * View a single article details
     */
    public function actionView($slug)
    {
		
		$this->layout =  Yii::app()->LayoutClass->layoutpath("fullwidth"); 
		$this->getData('pageStyles')->add(array('src' => AssetsUrl::css('style.css')));
        $article = $this->loadArticleModel($slug);
        
        $this->setData(array(
            'pageMetaTitle'         => $this->data->pageMetaTitle . ' | ' . $article->title,
            'pageMetaDescription'   => StringHelper::truncateLength($article->content, 150),
        ));
        
        Yii::app()->clientScript->registerLinkTag('canonical', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
        Yii::app()->clientScript->registerLinkTag('shortlink', null, $this->createAbsoluteUrl($this->route, array('slug' => $slug)));
        $this->setData(array(
            'pageTitle'     =>$article->page_title, 
            'metaDescription'   => 	$article->meta_description,
            'metaKeywords'   => 	$article->	meta_keywords,
        ));
        $this->render(Yii::app()->LayoutClass->viewpath("view"), compact('article'));
    }
    
    public function actionFloor_plan()
    {
     
		$this->activeUrl ="floor-plan";
		$this->layout =   Yii::app()->LayoutClass->layoutpath("sub");
		$this->headerImage  =  Yii::app()->theme->baseUrl.'/images/sale.jpg'; 
        $article = Property::model()->findAll(array("condition"=>"t.isTrash='0' and t.status='A'","order"=>"name asc"));
        if(empty($article))
		{
		  
			throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
		 }
		 
		 
        
        $this->setData(array(
            'pageMetaTitle'         => $this->data->pageMetaTitle . ' |  '.FloorPlan::AlternateFloorPlanText  ,
            'pageMetaDescription'   => 'Floor Plan',
        ));
    
        $this->render(Yii::app()->LayoutClass->viewpath("floor"), compact('article','list'));
		
	}
	
    public function actionSite_map()
    {
		 
	 
		$this->activeUrl ="floor-plan";
		$this->layout =   Yii::app()->LayoutClass->layoutpath("detail");
		$this->headerImage  =  Yii::app()->theme->baseUrl.'/images/sale.jpg'; 
        $article = Article::model()->findByPk(Article::SITE_MAP);
        if(empty($article))
		{
		 
			throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
		 }
		 
		 
        $list = Article::model()->getDelvelopmentList($article->article_id);
        
        
        $this->setData(array(
            'pageMetaTitle'         => $this->data->pageMetaTitle . ' | ' . $article->title,
            'pageMetaDescription'   => StringHelper::truncateLength($article->content, 150),
        ));
    
        $this->render(Yii::app()->LayoutClass->viewpath("siteMap"), compact('article','list'));
		
	}
    
    /**
     * Helper method to load the category AR model
     */
    public function loadCategoryModel($slug)
    {
        $model = ArticleCategory::model()->findByAttributes(array(
            'slug'      => $slug,
            'status'    => Article::STATUS_ACTIVE
        ));
        
        if ($model === null) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
        
        return $model;
    }
    
    /**
     * Helper method to load the article AR model
     */ 
    public function loadArticleModel($slug)
    {
        $model = Property::model()->findByAttributes(array(
            'slug'      => $slug,
            'status'    => 'A',
            'isTrash'    => '0',
        ));
        
        if ($model === null) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
        
        return $model;
    }
    
}
