<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * ArticlesController
 * 
 * Handles the actions for artciles related tasks
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class CareerweController extends Controller
{
    /**
     * List available published articles 
     */
  public $headerImage;
  public function init(){
	 
        // register class paths for extension captcha extended
   
    }
    public function currentDate(){
        $date = date('m-d-Y-h-i-s', time());
        return $date;
    }
    public function actionIndex( )
    {
		$article = $this->loadArticleModel('career');
        if(empty($article))
		{
			 
		  
			throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
		 }
		 
		$this->headerImage  =  Yii::app()->theme->baseUrl.'/images/contact_.jpg';
	//	$this->layout =   Yii::app()->LayoutClass->layoutpath("detail"); 
		$model = new CareerNew('insert');;
		if (isset($_POST['ajax'])) {
		echo CActiveForm::validate($model);
		Yii::app()->end();
		}
		if(isset($_POST['Career']))
		{
					$model->attributes=$_POST['Career'];
					
					 
				     
				     if($model->validate())
				     {
								$uploadedFile=CUploadedFile::getInstance($model,'image');
								$url = "" ; 
								if($uploadedFile)
								{
								$fileName = "{$this->currentDate()}-{$uploadedFile}";
								$uploadedFile->saveAs("uploads/resume/".$fileName);
								$url = Yii::app()->createAbsoluteUrl('resume/index',array('file'=>$fileName));
								}
								 
								 
								$emailTemplate =  CustomerEmailTemplate::model()->findByName("career");
								if($emailTemplate)
								{
									 $emailTemplate = $emailTemplate->content;
								}
								else
								{
										$emailTemplate = $options->get('system.email_templates.common');
								}
								 
								
						 
								$logo =  '<a href=""><img src="'.Yii::app()->apps->getBaseUrlNew('frontend/themes/styles-almaha/images/headertop.png',true).'" style="width:70px"  alt=""></a>';
								$emailTemplate = str_replace('{logo}',$logo, $emailTemplate);
								$emailTemplate = str_replace('{from}',Yii::app()->options->get('system.common.site_name'), $emailTemplate);
								$emailTemplate = str_replace('{name}',$model->name, $emailTemplate);
								$emailTemplate = str_replace('{phone}', $model->phone, $emailTemplate);
								$emailTemplate = str_replace('{email}', $model->email, $emailTemplate);
								$emailTemplate = str_replace('{position}', $model->position, $emailTemplate);
								if($url!="")
								{
								$emailTemplate = str_replace('{view}', "<a href='$url' target='_blank'>View</a>" , $emailTemplate);
								}
								$emailTemplate = str_replace('{message}', nl2br($model->message), $emailTemplate);
								 
				 
								$params = array(
								 'to'            =>   Yii::app()->options->get('system.common.admin_email'),
								//'to'            =>  'vineethnjalil@gmail.com',
								'fromName'      =>   Yii::app()->options->get('system.common.site_name'),
								'subject'       =>	'Successfully submittted contact form  '.Yii::app()->options->get('system.common.site_name') . '  ',
								'body'          =>   $emailTemplate,
								 'mailerPlugins' => array(
								'logger'    => true,
							),
									   
								 );
								 $server = DeliveryServer::pickServer();  
								 if( $server){
								 $server->sendEmail($params) ;
								 Yii::app()->user->setFlash('success',"Your message was successfully sent to the ". Yii::app()->options->get('system.common.site_name')." Support Team. One of our representative will contact you soon. ");
								}
								 $this->refresh() ;
						 }
						 else
						 {
							 Yii::app()->user->setFlash('error',"Your  form has following errors");
								 
						 }
					  
				    // $fileName = "{$this->currentDate()}-{$uploadedFile}";
				    
					//if($model->save())
					//$this->redirect(array('view','id'=>$model->id));
		}

		 
     
        $this->setData(array(
            'pageMetaTitle'     =>Yii::app()->options->get('system.common.site_name').' | '.Yii::t('articles', 'Career'), 
            'pageBreadcrumbs'   => array()
        ));
           $this->setData(array(
            'pageTitle'     =>'Careers', 
            'pageMetaDescription'   => 'Careers', 
            'metaKeywords'   => 'Careers', 
        ));

        $this->render("index", compact('model','article'));
    }
    public function uploadMultifile ($model,$attr,$path)
            {
                if($sfile=CUploadedFile::getInstances($model, $attr)){
                  foreach ($sfile as $i=>$file){  
                     $formatName=time().$i.'.'.$file->getExtensionName();
                     $file->saveAs(Yii::app()->basePath .DIRECTORY_SEPARATOR.'..'. $path.$formatName);
                     $ffile[$i]=$formatName;
                     }
                    return ($ffile);
                 }
             }
 public function loadArticleModel($slug)
    {
        $model = Article::model()->findByAttributes(array(
            'slug'      => $slug,
            'status'    => Article::STATUS_PUBLISHED
        ));
        
        if ($model === null) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
        
        return $model;
    }
   
}
