<?php



/**

 * This is the model class for table "{{area_guides}}".

 *

 * The followings are the available columns in table '{{area_guides}}':

 * @property integer $id

 * @property integer $location_id

 * @property string $highlight

 * @property string $neighbor

 * @property string $life_style

 * @property string $location

 * @property string $date_added

 * @property string $banner

 *

 * The followings are the available model relations:

 * @property City $location0

 */

class TopAreas extends  ActiveRecord

{

    /**

     * @return string the associated database table name

     */

    public function tableName()

    {

        return '{{top_links}}';

    }

    public $image; 

    public $faq; 
    public $faq_question;
    public $faq_answer;


    /**

     * @return array validation rules for model attributes.

     */

    public function rules()

    {

        // NOTE: you should only define rules for those attributes that

        // will receive user inputs.

        return array(

         array('title,community_id,slug', 'required'),

            array('l_type, category_id, sub_category_id, community_id,subcomunity_id,title,f_type,banner,date_added,overview,property,faqs,faq_answer,faq_question,cover_image,short_description', 'safe'),
            array('video', 'url','defaultScheme'=>'https'),
            array('map', 'url','defaultScheme'=>'https'),

             

            array('l_type, category_id, sub_category_id, community_id,subcomunity_id,title,f_type,banner', 'safe', 'on'=>'search'),

        );

    }

    

   public function getadTitle(){

       return $this->title;

   }   
   protected function beforeValidate()
    { 
        $this->slug = $this->generateSlug();

        return parent::beforeValidate();
    }
    public function generateSlug()
    {
        Yii::import('common.vendors.Urlify.*');
        $string = !empty($this->slug) ? $this->slug : $this->title;
        $slug = URLify::filter($string);
        $article_id = (int)$this->id ;

        $criteria = new CDbCriteria();
        $criteria->addCondition('id  != :id AND slug = :slug');
        $criteria->params = array(':id' => $article_id, ':slug' => $slug);
        $exists = $this->find($criteria);
        
        $i = 0;
        while (!empty($exists)) {
            ++$i;
            $slug = preg_replace('/^(.*)(\d+)$/six', '$1', $slug);
            $slug = URLify::filter($slug . ' '. $i);
            $criteria = new CDbCriteria();
            $criteria->addCondition('id  != :id AND slug = :slug');
            $criteria->params = array(':id' => $article_id, ':slug' => $slug);
            $exists = $this->find($criteria);
        }

        return $slug;
    }
    public function beforeSave(){

      parent::beforeSave();
        Yii::app()->options->set('system.common.banner_c_cahe','ddd'.date('YmdHis'));
        $this->f_type= 'HT';

        return true;

    }



    /**

     * @return array customized attribute labels (name=>label)

     */

    public function attributeLabels()

    {

        return array( 

            'id' => 'ID',

            'l_type' => 'Listing Type',

            'category_id' =>   'Category',

            'sub_category_id' =>   'Subcategory',

            'community_id' => 'Community',

            'subcomunity_id' =>'subcommunity', 

            'banner' => 'Image',
            'video' => 'Youtube URL',
            'map' => 'Google Map (IFRAME SRC)',

        );

    }



    /**

     * Retrieves a list of models based on the current search/filter conditions.

     *

     * Typical usecase:

     * - Initialize the model fields with values from filter form.

     * - Execute this method to get CActiveDataProvider instance which will filter

     * models according to data in model fields.

     * - Pass data provider to CGridView, CListView or any similar widget.

     *

     * @return CActiveDataProvider the data provider that can return the models

     * based on the search/filter conditions.

     */

     public $city_name;

     public $state_name;

    public function search($return=false)

    {

        // @todo Please modify the following code to remove attributes that should not be searched.



        $criteria=new CDbCriteria;

		$criteria->condition ='1';

  

        $criteria->compare('f_type','HT');

         

        if(!empty($return)){

            return $criteria;

        }

$criteria->order ='t.id desc';

        return new CActiveDataProvider(get_class($this), array(

            'criteria'      => $criteria,

            'pagination'    => array(

                'pageSize'  => $this->paginationOptions->getPageSize(),

                'pageVar'   => 'page',

            ),

            'sort'  => array(

                'defaultOrder'  => array(

                    'id'   => CSort::SORT_ASC,

                ),

            ),

        ));

    } 

      public function afterSave(){

		        	

		     parent::afterSave();

		     

			   return true; 

						 

	 } 

	  

    /**

     * Returns the static model of the specified AR class.

     * Please note that you should have this exact method in all your CActiveRecord descendants!

     * @param string $className active record class name.

     * @return AreaGuides the static model class

     */

    public static function model($className=__CLASS__)

    {

        return parent::model($className);

    }

    public $category_name;public $category_slug;public $community_slug;

        public function listpageBanners($f_type){

		$criteria=new CDbCriteria;

		$criteria->select = 't.banner,t.slug , category0.category_name,category0.slug as category_slug,t.community_id,subcomunity_id,t.title,t.l_type,community0.slug as community_slug';

		$criteria->join = ' left join {{category}} category0  on t.category_id = category0.category_id ';

		$criteria->join .= ' left join {{community}} community0  on t.community_id = community0.community_id ';

		$criteria->join .= ' left join {{sub_community}} sub_community0  on t.subcomunity_id = sub_community0.sub_community_id ';

		 $criteria->limit = '12';

        $criteria->order="-t.priority desc,t.id asc";

        $ar =  $this->findAll($criteria);

        $items = array();

        if(!empty($ar)){

          foreach($ar as $k=>$v){

               $tit = ''; 

               if(!empty($v->l_type)){

                   switch($v->l_type){

                        case 'R':

                             $tit = 'Residential '; 

                        break;

                          case 'C':

                              $tit = 'Commercial ';

                        break;

                   } 

               }

               $items[]  = array('url_offplan'=>Yii::app()->createUrl('listings/index',array('community'=>$v->community_slug)),'url'=>Yii::app()->createUrl('searchlist/index',array('sect'=>'for-sale','category'=>$v->category_slug)).'?community='.$v->community_slug,'category_name'=>$tit.$v->category_name,'category_slug'=>$v->category_slug,'title'=>$v->title,'detail_url'=>Yii::app()->createUrl('articles/area_guide_detail',['slug'=>$v->slug]),'banner'=>$v->banner);  

              

          }

        }

        return $items;

	}

    public function toparea($f_type=null){

	    $cacheKey = 'top_areqas1q'. Yii::app()->options->get('system.common.banner_c_cahe','12e43234').$f_type; 

		if ($items = Yii::app()->cache->get($cacheKey) and !isset($_GET['refresh'])) {

		     

			  return $items;

		}

		 

		$items = $this->listpageBanners($f_type);

 

		Yii::app()->cache->set($cacheKey, $items,60 * 60 * 24 * 2);

		return $items;

	}
    public function getTop_communities(){ 
            $criteria=new CDbCriteria; 
            $criteria->select = 't.banner,t.community_id,title';  
            $criteria->limit = '24';
            $criteria->condition  = '   t.community_id is not null ';
            $criteria->order="-t.priority desc,t.id asc"; 
            return  $this->findAll($criteria); 
    }

    protected function afterConstruct()
    {
        $this->fieldDecorator->onHtmlOptionsSetup = array($this, '_setDefaultEditorForContent');
        parent::afterConstruct();
    }
    
    protected function afterFind()
    {
        $this->fieldDecorator->onHtmlOptionsSetup = array($this, '_setDefaultEditorForContent');
        parent::afterFind();
    }
        public function _setDefaultEditorForContent(CEvent $event)
    {
        if (in_array($event->params['attribute'],['property','overview' ])) {
            $options = array();
            if ($event->params['htmlOptions']->contains('wysiwyg_editor_options')) {
                $options = (array)$event->params['htmlOptions']->itemAt('wysiwyg_editor_options');
            }
            $options['id'] = CHtml::activeId($this, $event->params['attribute']);
            $options['height'] = 100;
            $options['toolbar']= 'Simple';
            $event->params['htmlOptions']->add('wysiwyg_editor_options', $options);
        }
    }
    public function getExcerpt($length = 200)
    {
        return StringHelper::truncateLength($this->overview, $length);
    }
}

