<?php

/**
 * This is the model class for table "mw_amenities".
 *
 * The followings are the available columns in table 'mw_amenities':
 * @property integer $amenities_id
 * @property string $amenities_name
 * @property string $isTrash
 * @property string $status
 * @property integer $priority
 */
class Projectlist extends ActiveRecord
{
	public $amenities_available_for;
	public $short_desc;
	public $f_imgb;
	
	public $sprice;
	public $list_title1;
    public $list_desc1;
    public $list_icon1;
    public $prop_title1;
    public $prop_subtitle1;
    public $prop_desc1;
    public $prop_img1;
    public $prop_img1b;
    
    public $list_title2;
    public $list_desc2;
    public $list_icon2;
    public $prop_title2;
    public $prop_subtitle2;
    public $prop_desc2;
    public $prop_img2;
    public $prop_img2b;
    
    public $list_title3;
    public $list_desc3;
    public $list_icon3;
    public $prop_title3;
    public $prop_subtitle3;
    public $prop_desc3;
    public $prop_img3;
    public $prop_img3b;
    
    public $list_title4;
    public $list_desc4;
    public $list_icon4;
    public $prop_title4;
    public $prop_subtitle4;
    public $prop_desc4;
    public $prop_img4;
    public $prop_img4b;
    
    public $list_title5;
    public $list_desc5;
    public $list_icon5;
    public $prop_title5;
    public $prop_subtitle5;
    public $prop_desc5;
    public $prop_img5;
    public $prop_img5b;
    
    public $list_title6;
    public $list_desc6;
    public $list_icon6;
    public $prop_title6;
    public $prop_subtitle6;
    public $prop_desc6;
    public $prop_img6;
    public $prop_img6b;
    
    public $list_title7;
    public $list_desc7;
    public $list_icon7;
    public $prop_title7;
    public $prop_subtitle7;
    public $prop_desc7;
    public $prop_img7;
    public $prop_img7b;
    
    public $list_title8;
    public $list_desc8;
    public $list_icon8;
    public $prop_title8;
    public $prop_subtitle8;
    public $prop_desc8;
    public $prop_img8;
    public $prop_img8b;
    
    
    public $dev;
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        // return 'mw_amenities';
        return 'mw_projectlist';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('name, dev', 'required'),
            array('name', 'length', 'max'=>250),
            array('trash, status', 'length', 'max'=>1),
            array('f_img', 'file', 'types'=>'pdf,png,jpg', 'allowEmpty'=>true),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, name, trash, short_desc, status', 'safe', 'on'=>'search'),
            
        );
    }
    
    public function dev_arr(){
// 		return array(''=>'--select--', 'emaar'=>'Emaar', 'alef'=>'Alef', 'azizi'=>'Azizi');
		
		$developers = Developers::model()->ListDataForArr();
		return $developers;
		
	}
	public function f_type_array(){
		return array(''=>'Select','1'=>'Private amenities','2'=>'commercial_amenities');
	}
    public function getf_typeTitle(){
		$Ar = $this->f_type_array();
		return  isset($Ar[$this->f_type]) ? $Ar[$this->f_type] : '' ;
	}

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
           'relatedCategory' => array(self::HAS_MANY, 'AmenitiesCategoryList', 'amenities_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'name' => 'Name',
            'trash' => 'Is Trash',
            'status' => 'Status',
            'f_img' => 'Feature image',
            'short_desc' => 'Short Description',
            
            'sprice' => 'Starting Price',
            'list_title1' => 'Listing Title 1',
            'list_desc1' => 'Listing Description 1',
            'list_icon1' => 'Listing Icon 1',
            'prop_title1' => 'Property Title 1',
            'prop_subtitle1' => 'Property Subtitle 1',
            'prop_desc1' => 'Property Description 1',
            'prop_img1' => 'Property Image 1',
            
            'list_title2' => 'Listing Title 2',
            'list_desc2' => 'Listing Description 2',
            'list_icon2' => 'Listing Icon 2',
            'prop_title2' => 'Property Title 2',
            'prop_subtitle2' => 'Property Subtitle 2',
            'prop_desc2' => 'Property Description 2',
            'prop_img2' => 'Property Image 2',
            
            'list_title3' => 'Listing Title 3',
            'list_desc3' => 'Listing Description 3',
            'list_icon3' => 'Listing Icon 3',
            'prop_title3' => 'Property Title 3',
            'prop_subtitle3' => 'Property Subtitle 3',
            'prop_desc3' => 'Property Description 3',
            'prop_img3' => 'Property Image 3',
            
            'list_title4' => 'Listing Title 4',
            'list_desc4' => 'Listing Description 4',
            'list_icon4' => 'Listing Icon 4',
            'prop_title4' => 'Property Title 4',
            'prop_subtitle4' => 'Property Subtitle 4',
            'prop_desc4' => 'Property Description 4',
            'prop_img4' => 'Property Image 4',
            
            'list_title5' => 'Listing Title 5',
            'list_desc5' => 'Listing Description 5',
            'list_icon5' => 'Listing Icon 5',
            'prop_title5' => 'Property Title 5',
            'prop_subtitle5' => 'Property Subtitle 5',
            'prop_desc5' => 'Property Description 5',
            'prop_img5' => 'Property Image 5',
            
            'list_title6' => 'Listing Title 6',
            'list_desc6' => 'Listing Description 6',
            'list_icon6' => 'Listing Icon 6',
            'prop_title6' => 'Property Title 6',
            'prop_subtitle6' => 'Property Subtitle 6',
            'prop_desc6' => 'Property Description 6',
            'prop_img6' => 'Property Image 6',
            
            'list_title7' => 'Listing Title 7',
            'list_desc7' => 'Listing Description 7',
            'list_icon7' => 'Listing Icon 7',
            'prop_title7' => 'Property Title 7',
            'prop_subtitle7' => 'Property Subtitle 7',
            'prop_desc7' => 'Property Description 7',
            'prop_img7' => 'Property Image 7',
            
            'list_title8' => 'Listing Title 8',
            'list_desc8' => 'Listing Description 8',
            'list_icon8' => 'Listing Icon 8',
            'prop_title8' => 'Property Title 8',
            'prop_subtitle8' => 'Property Subtitle 8',
            'prop_desc8' => 'Property Description 8',
            'prop_img8' => 'Property Image 8',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function amenities_data()
    {
        $criteria=new CDbCriteria;
        // $criteria->compare('isTrash','0');
        // $criteria->compare('status','A');
        $criteria->order = 'id desc ,name asc ';
        return Projectlist::model()->findAll( $criteria);
	}
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;
        $criteria->compare('name',$this->name,true);
        $criteria->compare('trash', 0);
        $criteria->compare('status','A');
        $criteria->compare('short_desc',$this->short_desc,true);
        $criteria->order = 't.id,name' ;
        $pageSize = (Yii::app()->request->getQuery("page_size")) ?  (int) Yii::app()->request->getQuery("page_size") : $pageSize = 100;
        
        return new CActiveDataProvider($this, array(
             'criteria'=>$criteria,
             'pagination'=>array(
             'pageSize'=>$pageSize,
    ),
        ));
        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }
     public function  ListDataWithAmenities($id=null)
    {
		 $criteria=new CDbCriteria;
		 $criteria->select = "name,id";
		 $criteria->condition = "t.trash='N' and t.status='A'";
		 $criteria->params[":req"] = 'Y' ; 
		 $criteria->order="name";
		 return $this->with(array("relatedCategory"=>array("select"=>false,"on"=>"relatedCategory.category_id=$id",'joinType'=>'INNER JOIN',)))->findAll($criteria);
	}
	
	public static function getCommonCondition()
   { 
	    return " t.trash='0' and t.status='A'";
   }
   function getPropertyDatilUrl()
	{
			return   Yii::app()->createUrl($this->id.'/projectDetail'); 
			 
	}
	function getPropertyAbsoluteDatilUrl()
	{
			return   Yii::app()->createAbsoluteUrl($this->id.'/projectDetail'); 
			 
	}
    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return Amenities the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}
