<?php

/**
 * This is the model class for table "mw_booking_users".
 *
 * The followings are the available columns in table 'mw_booking_users':
 * @property integer $user_id
 * @property string $first_name
 * @property string $last_name
 * @property string $address
 * @property string $city
 * @property string $state
 * @property integer $country
 * @property string $zip
 * @property string $phone
 * @property string $fax
 * @property string $email
 * @property string $password
 * @property integer $isTrash
 * @property string $status
 */
class ListingUsers extends ActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public $con_password;
    public $old_password;
    public $checkin;
    public $user_name;
    public  $login_email;
    public  $login_password;

    public function tableName()
    {
        return '{{listing_users}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('login_email,login_password', 'required', "on" => array("login")),
            array('first_name,email', 'required', "on" => array("insert", "update")),
            // array('first_name','match', 'not' => true, 'pattern' => '/[^a-zA-Z_-]/','message' => 'Invalid characters in name.',),
            array('country_id, isTrash', 'numerical', 'integerOnly' => true),
            array('password,con_password', 'required', 'on' => "insert,updatepassword"),
            array('first_name, last_name, city, state, email', 'length', 'max' => 150),
            array('email', 'email'),
            array('langauges_known', 'safe'),
            array('email', 'unique', 'on' => "insert"),
            array('address', 'length', 'max' => 500),
            array('designation,brn_number', 'length', 'max' => 500),
            array('zip', 'length', 'max' => 7),
            array('phone', 'length', 'max' => 15),
            array('fax', 'length', 'max' => 10),
            array('password', 'length', 'max' => 250, "on" => "insert"),
            array('password', 'length', 'min' => 5, "on" => "insert"),
            array('password,con_password', 'compare', 'compareAttribute' => 'password', "on" => "insert,updatepassword"),
            array('status', 'length', 'max' => 1),
            array('send_me', 'length', 'max' => 1),
            array('cover_letter,dob,calls_me,country,position_level,education_level,updates,advertisement,username,con_password,image,xml_inserted,xml_image,mobile', 'safe'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('user_id, first_name, last_name, address, city, state, country, zip, phone, fax, email, password, isTrash, status,date_added', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'countries' => array(self::BELONGS_TO, 'Countries', 'country_id'),

            'adsCount' => array(self::STAT, 'PlaceAnAd', 'user_id', 'condition' => "t.isTrash='0'"),
            'searchCount' => array(self::STAT, 'Searchlist', 'user_id'),
            'watchCount' => array(self::STAT, 'Watchlist', 'user_id'),

        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'user_id' => 'User',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'address' => 'Address',
            'city' => 'City',
            'state' => 'State',
            'country_id' => 'Country',
            'zip' => 'Zip',
            'phone' => 'Phone',
            'fax' => 'Fax',
            'email' => 'Email',
            'password' => 'Password',
            'isTrash' => 'Is Trash',
            'con_password' => 'Confirm Password',
            'send_me' => 'Send me newsletters with Secret Deals',
            'login_email' => 'Email',
            'login_password' => 'Password',
            'designation'   => 'Designation',
            'brn_number'   => 'Agent BRN',
        );
    }
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            array(
                'SlugBehavior' => array(
                    'class' => 'common.models.SlugBehavior.SlugBehavior',
                    'slug_col' => 'slug',
                    'title_col' => 'first_name',
                    'overwrite' => true
                )
            )
        );
    }
    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function getFullName()
    {
        return $this->first_name . ' ' . $this->last_name;
    }

    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('user_id', $this->user_id);
        $criteria->compare('first_name', $this->first_name, true);
        $criteria->compare('last_name', $this->last_name, true);
        $criteria->compare('address', $this->address, true);
        $criteria->compare('city', $this->city, true);
        $criteria->compare('state', $this->state, true);
        $criteria->compare('country_id', $this->country_id);
        $criteria->compare('zip', $this->zip, true);
        $criteria->compare('phone', $this->phone, true);
        $criteria->compare('fax', $this->fax, true);
        $criteria->compare('email', $this->email, true);
        $criteria->compare('password', $this->password, true);
        if (empty($this->isTrash)) {
            $criteria->compare('isTrash', '0');
        }
        $criteria->compare('isTrash', $this->isTrash);
        $criteria->compare('status', $this->status, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'pagination'    => array(
                'pageSize'  => $this->paginationOptions->getPageSize(),
                'pageVar'   => 'page',
            ),
        ));
    }
    protected function beforeSave()
    {
        if (!parent::beforeSave()) {
            return false;
        }



        if (!empty($this->con_password)) {
            $this->password = Yii::app()->passwordHasher->hash($this->con_password);
        }
        return true;
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return BookingUsers the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }
    public function listData()
    {
        $criteria = new CDbCriteria;
        $criteria->condition = "t.status='A'";
        //  $criteria->select= "t.*,concat(t.first_name,t.last_name) as name";
        return $this->findAll($criteria);
    }
    public function getStatusWithStats($sta = null)
    {
        $ar = $this->activeArray();
        return (isset($ar[$sta])) ? $ar[$sta] : "Inactive";
    }
    public function activeArray()
    {
        $arr = array("A" => "Active", "I" => "Inactive");
        return $arr;
    }
    public function dayOfMonth()
    {
        for ($i = 1; $i <= 31; $i++) {
            $day[$i] = str_pad($i, 2, 0, STR_PAD_LEFT);
        }
        return $day;
    }
    public function findByEmail($email)
    {
        $criteria = new CDbCriteria;
        $criteria->condition = "t.email=:email";
        $criteria->params[':email'] = $email;
        return $this->find($criteria);
    }
    function is_image($path)
    {
        @$a = getimagesize($path);
        $image_type = $a[2];

        if (in_array($image_type, array(IMAGETYPE_GIF, IMAGETYPE_JPEG, IMAGETYPE_PNG, IMAGETYPE_BMP))) {
            return true;
        }
        return false;
    }
    public function getUserImage()
    {
        if (!empty($this->image)) {
            return Yii::app()->apps->getBaseUrl('uploads/files/' . $this->image);
        }  
    }
}
