<?php



/**

 * This is the model class for table "{{list_property}}".

 *

 * The followings are the available columns in table '{{list_property}}':

 * @property integer $id

 * @property string $name

 * @property string $email

 * @property string $mobile

 * @property integer $section

 * @property integer $category_id

 * @property string $address

 * @property string $date_added

 * @property string $last_updated

 *

 * The followings are the available model relations:

 * @property Category $category

 * @property Section $section0

 */

class ListProperty extends  ActiveRecord

{

    /**

     * @return string the associated database table name

     */

     public $_recaptcha; 

     public $phone_false;

    public function tableName()

    {

        return '{{list_property}}';

    }



    /**

     * @return array validation rules for model attributes.

     */

    public function rules()

    {

        // NOTE: you should only define rules for those attributes that

        // will receive user inputs.

        return array(

            array('name, email, phone_false, address,section, category_id   ', 'required'),

            array('section, category_id', 'numerical', 'integerOnly'=>true),

            array('name, mobile', 'length', 'max'=>200),

            array('manage', 'safe'),

            array('email', 'length', 'max'=>150),

            array('address', 'length', 'max'=>250),

             array('_recaptcha', 'validateRecaptcha' ,"on"=>'insert' ),

                 array('phone_false', 'validatePhone'),

            // The following rule is used by search().

            // @todo Please remove those attributes that should not be searched.

            array('id, name, email, mobile, section, category_id, address, date_added, last_updated', 'safe', 'on'=>'search'),

        );

    }

    public function validatePhone($attribute,$params)

	{

		if(!empty($this->$attribute)){

			$string = $this->$attribute;

			$strlen = strlen(Yii::t('app',$string,array(' '=>'')));

			if (strpos($this->$attribute, '+') !== false) {

				$string = substr($this->$attribute,1,strlen($this->$attribute));

			}

			if($strlen<9){

					 $this->addError($attribute,  Yii::t('app','Please enter a valid  Mobile No.'.$this->$attribute));	

			}

			if($strlen>14){

					 $this->addError($attribute,  Yii::t('app','Please enter a valid  Mobile No.'.$this->$attribute));	

			}

			if (substr_count($string, ' ') > 3 ) {

				 $this->addError($attribute,  Yii::t('app','Please enter a valid  Mobile No.'.$this->$attribute));				 

			}

			 

			$rtl_chars_pattern = '/^[\s\d]+$/';

			 

			if(preg_match($rtl_chars_pattern, $string)  ) {

			  

			}

			else {

			   $this->addError($attribute,  Yii::t('app','Please enter a valid  Mobile No.'.$this->$attribute));

			}

			 

		}

	}

public function validateRecaptcha($attribute,$params){

		

		  if(!Yii::app()->request->isAjaxRequest and !defined('IS_API')){

 

	 

			$captcha= '';

			if(isset($_POST['g-recaptcha-response'])){

			$captcha=$_POST['g-recaptcha-response'];

			}



			if(!$captcha){

				$this->addError($attribute,  'Please check the   captcha form.' );

			}

		 

				 

			$data = array(

			'secret' =>  Yii::app()->options->get('system.common.google_recaptcha_secret','') ,

			'response' => $captcha,

			'remoteip' => $_SERVER['REMOTE_ADDR']

			);



			$verify = curl_init();

			curl_setopt($verify, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify");

			curl_setopt($verify, CURLOPT_POST, true);

			curl_setopt($verify, CURLOPT_POSTFIELDS, http_build_query($data));

			curl_setopt($verify, CURLOPT_SSL_VERIFYPEER, false);

			curl_setopt($verify, CURLOPT_RETURNTRANSFER, true);

			$res = curl_exec($verify);



			$captcha = json_decode($res);

			

		 

				if ($captcha->success) {

						 

				 }

				 else{

					 $this->addError($attribute,  'Please refresh and try again.' );

				 }

				

 

		 

		  }

		   

	}

	    public function beforeValidate(){

		

	   if(parent::beforeValidate()) 

	   {

            

             //$this->mobile = (!empty($this->phone)) ? $this->phone : $this->phone_false;

			  

		 

			 return true;

	   }

	return false;

	 

	} 

	public function getptypeDetail(){

	    $title = '';

	    switch($this->section){

            case '1' : 

            $title = 'For Sale';

            break; 

             case '2' : 

            $title = 'For Rent';

            break; 

	    }

	    

	    $catebory = Category::model()->findByPk($this->category_id);

	    if($catebory){

	        $title .= ','. $catebory->category_name;

	    }

	    return $title; 

	}

	

    /**

     * @return array relational rules.

     */

    public function relations()

    {

        // NOTE: you may need to adjust the relation name and the related

        // class name for the relations automatically generated below.

        return array(

            'category' => array(self::BELONGS_TO, 'Category', 'category_id'),

            'section0' => array(self::BELONGS_TO, 'Section', 'section'),

        );

    }



    /**

     * @return array customized attribute labels (name=>label)

     */

    public function attributeLabels()

    {

        return array(

            'id' => 'ID',

            'name' => 'Full Name',

            'email' => 'Email',

            'mobile' => 'Mobile',

            'phone_false' => 'Mobile',

            'section' => 'Section',

            'category_id' => 'Category',

            'address' => 'Property Address',

            'date_added' => 'Date Added',

            'last_updated' => 'Last Updated',

            'manage' => 'Manage Your Property',

        );

    }



    /**

     * Retrieves a list of models based on the current search/filter conditions.

     *

     * Typical usecase:

     * - Initialize the model fields with values from filter form.

     * - Execute this method to get CActiveDataProvider instance which will filter

     * models according to data in model fields.

     * - Pass data provider to CGridView, CListView or any similar widget.

     *

     * @return CActiveDataProvider the data provider that can return the models

     * based on the search/filter conditions.

     */

    public function search($return=false)

    {

        // @todo Please modify the following code to remove attributes that should not be searched.



        $criteria=new CDbCriteria;



        $criteria->compare('id',$this->id);

        $criteria->compare('name',$this->name,true);

        $criteria->compare('manage',$this->manage);

        $criteria->compare('email',$this->email,true);

        $criteria->compare('mobile',$this->mobile,true);

        $criteria->compare('section',$this->section);

        $criteria->compare('category_id',$this->category_id);

        $criteria->compare('address',$this->address,true);

        $criteria->compare('date_added',$this->date_added,true);

        $criteria->compare('last_updated',$this->last_updated,true);

        if($return){

            return $criteria;

        }



             return new CActiveDataProvider(get_class($this), array(

            'criteria'      => $criteria,

            'pagination'    => array(

                'pageSize'  => $this->paginationOptions->getPageSize(),

                'pageVar'   => 'page',

            ),

            'sort'  => array(

                'defaultOrder'  => array(

                    'id'   => CSort::SORT_DESC,

                ),

            ),

        ));

    }



    /**

     * Returns the static model of the specified AR class.

     * Please note that you should have this exact method in all your CActiveRecord descendants!

     * @param string $className active record class name.

     * @return ListProperty the static model class

     */

    public static function model($className=__CLASS__)

    {

        return parent::model($className);

    }
    public function afterSave(){
		parent::afterSave();     
        $liamamodel = new ContactUs(); 
        $catebory = Category::model()->findByPk($this->category_id); 
	    if($catebory){

	        $catebory  =  $catebory->category_name;

	    }  
        $sectitle = '';

	    switch($this->section){

            case '1' : 

            $sectitle = 'For Sale';

            break; 

             case '2' : 

            $sectitle = 'For Rent';

            break; 

	    }
        $mTitle = '';
        $mURL = '';
        
   
    return true; 
    }
}

