<?php

/**
 * This is the model class for table "mw_city".
 *
 * The followings are the available columns in table 'mw_city':
 * @property integer $city_id
 * @property string $city_name
 * @property integer $country_id
 * @property integer $state_id
 * @property integer $priority
 * @property string $isTrash
 * @property string $status
 */
class Community extends ActiveRecord
{
 
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'mw_community';
    }

   
public function primaryKey() 
{
        return  'community_id'  ;
}
    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('community_name,district_id ', 'required' , 'on'=>'insert,update'),
            array('community_name,city_id ', 'required', 'on'=>'city_insert'),
            array(' , district_id ', 'numerical', 'integerOnly'=>true),
            array('community_name', 'length', 'max'=>250),
            array('  community_name, district_id ,HaveSubComm,meta_description,meta_title,meta_title_rent,meta_description_rent,meta_title_offplan,meta_description_offplan', 'safe'),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('community_id, community_name, district_id ,HaveSubComm ', 'safe', 'on'=>'search'),
        );
    }
    public function behaviors(){
		 
    return array_merge(parent::behaviors(),array(
        'SlugBehavior' => array(
            'class' => 'common.models.SlugBehavior.SlugBehavior',
            'slug_col' => 'slug',
            'title_col' => 'community_name',
            
            'overwrite' => true
        ))
    );
  }
    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
         //  'city' => array(self::BELONGS_TO, 'City', 'city_id'),
          // 'country' => array(self::BELONGS_TO, 'Countries', 'country_id'),
           'district' => array(self::BELONGS_TO, 'District', 'district_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'district_id' => 'District',
            'city_id' => 'City',
            'city_name' => 'City Name',
            'country_id' => 'Country',
            'state_id' => 'Region',
            'priority' => 'Priority',
            'isTrash' => 'Is Trash',
            'status' => 'Status',
            'meta_title' => 'Meta Title - Sale',
            'meta_description' => 'Meta Description - Sale',

            'meta_title_rent' => 'Meta Title - Rent',
            'meta_description_rent' => 'Meta Description - Rent',

            'meta_title_offplan' => 'Meta Title - Off-Plan',
            'meta_description_offplan' => 'Meta Description - Off-Plan',

        );
    }
    public function berforeSave(){
        parent::beforeSave();
        if(empty($this->meta_description)){
            $this->meta_description = null;  
        }
        if(empty($this->meta_title)){
            $this->meta_title = null;  
        }
        if(empty($this->meta_title_rent)){
            $this->meta_title_rent = null;  
        }
        if(empty($this->meta_description_rent)){
            $this->meta_description_rent = null;  
        }
        if(empty($this->meta_title_offplan)){
            $this->meta_title_offplan = null;  
        }
        if(empty($this->meta_description_offplan)){
            $this->meta_description_offplan = null;  
        }
        return true; 
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
     public $city_name;
    public function search($return=false)
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;
        $criteria->condition = '1 ';
        $criteria->join = ' inner join {{district}} district0 on district0.district_id = t.district_id  ';
         $criteria->join .= ' inner join {{city}} city0 on city0.city_id = district0.city_id  ';
          $criteria->join .= ' inner join {{states}} states0 on states0.state_id = city0.state_id and states0.country_id ="65946"  ';
         if(!empty($this->district_id)){
			 $criteria->with = array('district');
			 $criteria->compare('district.district_name',$this->district_id,true);
		 }
        $criteria->condition .= ' and t.district_id is not null ';
        $criteria->compare('community_id',$this->community_id);
        $criteria->compare('community_name',$this->community_name,true);
       if($return){ return $criteria;}
 $criteria->order = 'community_id desc';
 
         return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
              'pagination'    => array(
                'pageSize'  => $this->paginationOptions->getPageSize(),
                'pageVar'   => 'page',
            ),
        ));
    }
    
    public function communities($id=null)
	{
		$criteria=new CDbCriteria;
		 $criteria->condition = "t.district_id=:district_id";
		 $criteria->params[":district_id"] = $id ; 
		 $criteria->order  = "community_name" ; 
		 return $this->findAll($criteria);
	}
    public function listData($id=null)
	{
		 $criteria=new CDbCriteria;
		 $criteria->select = "community_id,community_name";
		 $criteria->order  = "community_name" ; 
		 return $this->findAll($criteria);
	}
 

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return City the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
    function getCommunity()
	{
		 static $_options = array();
		 
		 $r= $this->findAll(array( "order"=>"community_name"));
	 
		 if($r)
		 {
			 foreach($r as $k=>$v)
			 {
				  $_options[$v->community_id] =  $v->community_name; 
			 }
	     }
	     return $_options;
		 
	}
	public $country_id;
	
	  public function  findAllUAE(){
        $criteria=new CDbCriteria;
        $criteria->select ='t.community_name,t.community_id';
        $criteria->join .= ' inner join {{district}} district0 on t.district_id = district0.district_id ';
        $criteria->join .= ' inner join {{city}} city0 on district0.city_id = city0.city_id ';
        $criteria->join .= ' inner join {{states}} states0 on city0.state_id = states0.state_id and states0.country_id ="65946"  ';
        $criteria->order ='t.community_name asc';
         return $this->findAll($criteria);
    }
    
}
