<?php

/**
 * This is the model class for table "mw_city".
 *
 * The followings are the available columns in table 'mw_city':
 * @property integer $city_id
 * @property string $city_name
 * @property integer $country_id
 * @property integer $state_id
 * @property integer $priority
 * @property string $isTrash
 * @property string $status
 */
class City extends ActiveRecord
{
	public $location;
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return 'mw_city';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('city_name,  state_id', 'required'),
            array('country_id, state_id, priority', 'numerical', 'integerOnly'=>true),
            array('city_name', 'length', 'max'=>250),
            array('isTrash, status', 'length', 'max'=>1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('city_id, city_name, country_id, state_id, priority, isTrash, status', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
           'state' => array(self::BELONGS_TO, 'States', 'state_id'),
           'country' => array(self::BELONGS_TO, 'Countries', 'country_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'city_id' => 'City',
            'city_name' => 'City Name',
            'country_id' => 'Country',
            'state_id' => 'Region',
            'priority' => 'Priority',
            'isTrash' => 'Is Trash',
            'status' => 'Status',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('city_id',$this->city_id);
        $criteria->compare('city_name',$this->city_name,true);
       // $criteria->compare('country_id',$this->country_id);
        $criteria->compare('state_id',$this->state_id);
        //$criteria->compare('isTrash','0',true);
       // $criteria->compare('status','A',true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }
     public function FindCities($id=null)
	{
		$criteria=new CDbCriteria;
		 $criteria->condition = "t.state_id=:state_id";
		 $criteria->params[":state_id"] = $id ; 
		 $criteria->order  = "city_name" ; 
		 return $this->findAll($criteria);
	}

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return City the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
    public function  ListDataForJSON($state)
    {
		 
		 $criteria=new CDbCriteria;
		 $criteria->condition = "t.isTrash='0' and t.state_id=:con";
		 $criteria->params[':con']=$state;
		 $criteria->select ="city_id,city_name";
		 $criteria->order="city_name";
		 $arra =  $this->findAll($criteria);
		 $ar =array();
		 if($arra)
		 {
			 foreach($arra as $k=>$v)
			 {
				 $ar[]= array("id"=>$v->city_id , "name" => $v->city_name );
			 }
		 }
		 
	 	 return CJSON::encode(array_merge(array("0"=>"Select City"),$ar));
	}
	public function  ListDataForJSONParent($state=null,$json=true,$parent=null)
    {
		 
		 $criteria=new CDbCriteria;
		 $criteria->condition = "t.isTrash='0'  ";
		 if(!empty($parent)){
		      $criteria->condition .= " and t.parent_id = :parent";
		      $criteria->params[':parent'] = (int) $parent;
		 } 
		  $criteria->join .= " left join {{city}} prnt on  prnt.city_id = t.parent_id ";
		 if(!empty($state)){
		     $criteria->condition .= " and   t.state_id=:con ";
		 $criteria->params[':con']=$state;
		     $criteria->condition .= " and t.parent_id is null"; 
		 }
		 $criteria->select ="t.city_id,t.city_name,prnt.city_name as parent_name";
		  
		 $criteria->order="t.priority='0' asc,t.priority  asc,t.city_name asc";
		 $arra =  $this->findAll($criteria);
		  if(!$json){ return $arra; }
		 $ar =array();
		 if($arra)
		 {
			
			 foreach($arra as $k=>$v)
			 {
				 $ar[]= array("id"=>$v->city_id , "name" => !empty($v->city_other) ? $v->city_other  :$v->city_name  , 'parent_name' => !empty($v->parent_name) ?  $v->parent_name : '', 'parent_slug' => !empty($v->parent_slug) ?  $v->parent_slug : ''  );
			 }
		 }
		 
	 	 return CJSON::encode(array_merge(array("0"=>Yii::app()->tags->getTag('select-city','Select City')),$ar));
	}	
}
