<?php



/**

 * This is the model class for table "mw_amenities".

 *

 * The followings are the available columns in table 'mw_amenities':

 * @property integer $amenities_id

 * @property string $amenities_name

 * @property string $isTrash

 * @property string $status

 * @property integer $priority

 */

class Amenities extends ActiveRecord

{

	public $amenities_available_for;

    /**

     * @return string the associated database table name

     */

    public function tableName()

    {

        return 'mw_amenities';

        // return 'mw_projectlist';

    }



    /**

     * @return array validation rules for model attributes.

     */

    public function rules()

    {

        // NOTE: you should only define rules for those attributes that

        // will receive user inputs.

        return array(

            array('amenities_name', 'required'),

            array('priority', 'numerical', 'integerOnly'=>true),

            array('amenities_name', 'length', 'max'=>250),

            array('isTrash, status', 'length', 'max'=>1),

            array('f_type', 'length', 'max'=>1),

            array('code', 'unique','on'=>'insert'),

            array('Title,icon_list,featured', 'safe'),

            // The following rule is used by search().

            // @todo Please remove those attributes that should not be searched.

            array('amenities_id, amenities_name, isTrash, status, priority', 'safe', 'on'=>'search'),

        );

    }

    
    public function geticon_listTitl(){
       // return $this->icon_list;
    if(!empty($this->icon_list)){
            return '<i class="fa '.$this->icon_list.'"></i>';
         }
    }
    public function f_type_array(){

		return array(''=>'Select','1'=>'Private amenities','2'=>'commercial_amenities');

	}

    public function getf_typeTitle(){

		$Ar = $this->f_type_array();

		return  isset($Ar[$this->f_type]) ? $Ar[$this->f_type] : '' ;

	}



    /**

     * @return array relational rules.

     */

    public function relations()

    {

        // NOTE: you may need to adjust the relation name and the related

        // class name for the relations automatically generated below.

        return array(

           'relatedCategory' => array(self::HAS_MANY, 'AmenitiesCategoryList', 'amenities_id'),

        );

    }



    /**

     * @return array customized attribute labels (name=>label)

     */

    public function attributeLabels()

    {

        return array(

            'amenities_id' => 'Amenities',

            'amenities_name' => 'Amenities Name',

            'isTrash' => 'Is Trash',

            'status' => 'Status',

            'priority' => 'Priority',

        );

    }



    /**

     * Retrieves a list of models based on the current search/filter conditions.

     *

     * Typical usecase:

     * - Initialize the model fields with values from filter form.

     * - Execute this method to get CActiveDataProvider instance which will filter

     * models according to data in model fields.

     * - Pass data provider to CGridView, CListView or any similar widget.

     *

     * @return CActiveDataProvider the data provider that can return the models

     * based on the search/filter conditions.

     */

    public function amenities_data()

    {

        $criteria=new CDbCriteria;

        $criteria->compare('isTrash','0');

        $criteria->compare('status','A');

        $criteria->order = 'f_type asc ,amenities_name asc ';

        return Amenities::model()->findAll( $criteria);

	}

    public function search($return = false)

    {



        // @todo Please modify the following code to remove attributes that should not be searched.



        $criteria=new CDbCriteria;

        $criteria->compare('amenities_name',$this->amenities_name);

        $criteria->compare('isTrash','0');

        $criteria->compare('status','A');

        $criteria->compare('featured', $this->featured);
        $criteria->compare('code',$this->code,true);

        $criteria->compare('f_type',$this->f_type);

        $criteria->order = 't.priority,amenities_name' ;

        $pageSize = (Yii::app()->request->getQuery("page_size")) ?  (int) Yii::app()->request->getQuery("page_size") : $pageSize = 100;
        if ($return) {
            return $criteria;
        }



        return new CActiveDataProvider($this, array(

             'criteria'=>$criteria,

             'pagination'=>array(

             'pageSize'=>$pageSize,

    ),

        ));

        return new CActiveDataProvider($this, array(

            'criteria'=>$criteria,

        ));

    }

     public function  ListDataWithAmenities($id=null)

    {

		 $criteria=new CDbCriteria;

		 $criteria->select = "amenities_name,amenities_id";

		 $criteria->condition = "t.isTrash='0' and t.status='A'";

		 $criteria->params[":req"] = 'Y' ; 

		 $criteria->order="amenities_name";

		 return $this->with(array("relatedCategory"=>array("select"=>false,"on"=>"relatedCategory.category_id=$id",'joinType'=>'INNER JOIN',)))->findAll($criteria);

	}

    /**

     * Returns the static model of the specified AR class.

     * Please note that you should have this exact method in all your CActiveRecord descendants!

     * @param string $className active record class name.

     * @return Amenities the static model class

     */

    public static function model($className=__CLASS__)

    {

        return parent::model($className);

    }

         public function  ListData2()

    {

		 $criteria=new CDbCriteria;

		 $criteria->select = "t.amenities_name,t.amenities_id";

		 $criteria->condition = "t.isTrash='0' and t.status='A'"; 

	 

		 return self::model()->findAll($criteria); 

	}
    public function getAllAmentiesCache()
    {
        $cacheKey =  'amenitiesfetch_cache3.12321';
        if ($items = Yii::app()->cache->get($cacheKey)) {
            return $items;
        }
        $criteria = self::model()->search(1);
        $criteria->group = 't.amenities_name';
        $criteria->select = 't.amenities_id, t.amenities_name';
        $results = CHtml::listData(self::model()->findAll($criteria), 'amenities_id', 'amenities_name');
        Yii::app()->cache->set($cacheKey, $results, 60 * 60 * 1);
        return $results;
    }
    public function cacheclistAmenities()
    {
        $cacheKey =  'amenities_cache111' . date('Y-m-d');

        if ($items = Yii::app()->cache->get($cacheKey) and !isset($_GET['refresh'])) {

            return $items;
        }
        $criteria = self::model()->search(1);
        $criteria->group = 't.amenities_name';
        $criteria->select = 't.amenities_id, t.amenities_name';
        $criteria->condition = 't.status="A" and COALESCE(t.featured,0) = "1" ';
        $criteria->order = '-t.priority desc,t.amenities_name';
        $items = CHtml::listData(self::model()->findAll($criteria), 'amenities_id', 'amenities_name');
       
        Yii::app()->cache->set($cacheKey, $items, 60 * 60 * 24 * 1);
        return $items;
    }

}

