<?php

/**
 * This is the model class for table "{{ad_property_types}}".
 *
 * The followings are the available columns in table '{{ad_property_types}}':
 * @property string $id
 * @property integer $ad_id
 * @property integer $type_id
 * @property integer $bed
 * @property integer $bath
 * @property string $title
 * @property string $from_price
 * @property string $to_price
 * @property string $size
 * @property string $size_to
 * @property string $last_updated
 *
 * The followings are the available model relations:
 * @property PlaceAnAd $ad
 * @property Category $type
 */
class AdPropertyTypes extends  ActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{ad_property_types}}';
    }
public $category_name;public $type_id_c;public $bed_c;
    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('ad_id, type_id', 'required'),
            array('ad_id, type_id, bed, bath', 'numerical', 'integerOnly'=>true),
            array('title', 'length', 'max'=>250),
            array('description,image', 'safe'),
            array('from_price, to_price, size, size_to', 'length', 'max'=>14),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, ad_id, type_id, bed, bath, title, from_price, to_price, size, size_to, last_updated', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'ad' => array(self::BELONGS_TO, 'PlaceAnAd', 'ad_id'),
            'type' => array(self::BELONGS_TO, 'Category', 'type_id'),
            'area_unit1' => array(self::BELONGS_TO, 'AreaUnit', 'area_unit'),
            'price_unit1' => array(self::BELONGS_TO, 'PriceUnit', 'price_unit'),
        );
    }
 
	public function getBathroomTitle(){
	    if($this->bath=='14'){ $this->bath = '13+ Bathrooms'; }
		return  $this->bath.' Bathrooms';
	}
	public function getBedroomTitle(){
		if(empty($this->bed)){ return false; }
		if($this->bed=='14'){ return '13+'.' Bedrooms'; }
		if($this->bed=='15'){ return 'Studio'; }
		return  $this->bed.' Bedrooms' ;
	}
	public function getSizeTitle(){
		//if(!empty($this->size_to) and $this->size_to != '0.00' ){ $htm =   'Size   <b>'.number_format($this->size,0,'.',',').'</b> To <b>'.number_format($this->size_to,0,'.',',') .'</b> Sq.Ft.' ; return  $htm; }
		 $unit = '';
		 if(!empty($this->area_unit)){ $unit = $this->area_unit1->master_name; }
		 if(empty($unit)){ $unit = ' Sq.Ft.';  }
		 return  '<span class="area_det">'. 'Area' .'</span>   <b>'.number_format($this->size,0,'.',',').'</b> ' . $unit;
		 
	}
	public function getPriceTitle(){
		 //if(!empty($this->to_price) and  $this->to_price!= '0.00'){ return  'Price <b>'.number_format($this->from_price,0,'.',',').'</b> To <b>'.number_format($this->to_price,0,'.',',').'</b>'   ; }
		 $unit = '';
		 if(!empty($this->price_unit)){ $unit = ' '.$this->price_unit1->master_name; }
		 
		 return  '<span class="area_det">'. 'Price' .'</span>  <b>'.number_format($this->from_price,2,'.',',').$unit.'</b>'  ;
		 
	}
    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'ad_id' => 'Ad',
            'type_id' => 'Type',
            'bed' => 'Bed',
            'bath' => 'Bath',
            'title' => 'Title',
            'from_price' => 'From Price',
            'to_price' => 'To Price',
            'size' => 'Size',
            'size_to' => 'Size To',
            'last_updated' => 'Last Updated',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id,true);
        $criteria->compare('ad_id',$this->ad_id);
        $criteria->compare('type_id',$this->type_id);
        $criteria->compare('bed',$this->bed);
        $criteria->compare('bath',$this->bath);
        $criteria->compare('title',$this->title,true);
        $criteria->compare('from_price',$this->from_price,true);
        $criteria->compare('to_price',$this->to_price,true);
        $criteria->compare('size',$this->size,true);
        $criteria->compare('size_to',$this->size_to,true);
        $criteria->compare('last_updated',$this->last_updated,true);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AdPropertyTypes the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}
