<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * PaypalPaymentHandler
 * 
 * @package MailWizz EMA
 * @subpackage Payment Gateway Paypal
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class PaypalPaymentHandler extends PaymentHandlerAbstract
{
    // render the payment form
    public function renderPaymentView()
    {
        $controller = Yii::app()->getController();
        $extension  = $controller->getData('extension');
        $pricePlan  = $controller->getData('pricePlan');
        $currency   = $controller->getData('currency');
        
        $model = new PaymentGatewayPaypalExtModel();
        $model->populate($extension);
        
        $cancelUrl = Yii::app()->createAbsoluteUrl('price_plans/index');
        $returnUrl = Yii::app()->createAbsoluteUrl('price_plans/index');
        $notifyUrl = Yii::app()->createAbsoluteUrl('payment_gateway_ext_paypal/ipn');
        
        $extension->registerCustomerAssets();
        
        $customVars = sha1(StringHelper::uniqid());
        $view       = $extension->getPathAlias().'.customer.views.payment-form';
        
        $controller->renderPartial($view, compact('model', 'pricePlan', 'cancelUrl', 'returnUrl', 'notifyUrl', 'customVars'));
    }
    
    // mark the order as pending retry
    public function completeOrder(PricePlanOrder $order, PricePlanOrderTransaction $transaction)
    {
        $request = Yii::app()->request;
        
        if (strlen($request->getPost('custom')) != 40) {
            return false;
        }
        
        $transaction->payment_gateway_name = 'Paypal - www.paypal.com';
        $transaction->payment_gateway_transaction_id = $request->getPost('custom');
        $transaction->status = PricePlanOrderTransaction::STATUS_PENDING_RETRY;
        $transaction->save(false);
        
        $order->status = PricePlanOrder::STATUS_PENDING;
        $order->save(false);
        
        $message = Yii::t('payment_gateway_ext_paypal', 'Your order is in "{status}" status, it usually takes a few minutes to be processed and if everything is fine, your pricing plan will become active!', array(
            '{status}' => Yii::t('orders', $order->status),
        ));
        Yii::app()->notify->addInfo($message);
        
        // the order is not complete, so return false
        return false;
    }
    
    // refund order
    public function refundOrder(PricePlanOrder $order)
    {
        
    }
}
