<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * Common application main configuration file
 * 
 * This file should not be altered in any way!
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
$cat_slug = 'apartment|villa|residential-land|mixed-use-plot|retail|commercial-building-1|residential-building|warehouse|commercial-plot|commercial-floor|office|villa|compound-villa|penthouse|shop|townhouse|labor-camp|show-room|bungalow|half-floor|restaurant|bulk-units|factory|storage|duplex|whole-building|hotel-apartment|of|staff-accommodation|business-centre|farm';     
    
return array(
    'basePath'          => Yii::getPathOfAlias('common'),
    'runtimePath'       => Yii::getPathOfAlias('common.runtime'),
    'name'              => 'Classifieds', // never change this
    'id'                => 'Classifieds', // never change this
    'sourceLanguage'    => 'en',
    'language'          => 'en',
    'defaultController' => '', 
    'charset'           => 'utf-8',
    'timeZone'          => 'UTC', // make sure we stay UTC
    
    // preloading components
    'preload' => array(
        'log', 'systemInit'
    ),
    
    // autoloading model and component classes
    'import' => array(      
        'common.components.*',
        'common.components.db.*',
        'common.components.db.ar.*',
        'common.components.db.behaviors.*',
        'common.components.helpers.*',
        'common.components.init.*', 
        'common.components.managers.*',
        'common.components.mutex.*',
        'common.components.mailer.*',
        'common.components.utils.*',
        'common.components.web.*',
        'common.components.web.auth.*',
        'common.components.web.response.*',
        'common.components.web.widgets.*',
        'common.models.*',  
        'common.models.option.*',

        'common.vendors.Urlify.*',
         'common.extensions.webp.lib.imageResize',
    ),
    
    // application components
    'components' => array(
        
        // will be merged with the custom one to get connection string/username/password and table prefix
        'db' => array(
            'connectionString'      => 'mysql:host={DB_HOST};dbname={DB_NAME}',
            'username'              => '{DB_USER}',
            'password'              => '{DB_PASS}',
            'tablePrefix'           => '{DB_PREFIX}',
            'emulatePrepare'        => true,
            'charset'               => 'utf8',
            'schemaCachingDuration' => MW_CACHE_TTL,
            'enableParamLogging'    => MW_DEBUG,
            'enableProfiling'       => MW_DEBUG,
            'queryCacheID'          => 'cache',
            'initSQLs'              => array(
                'SET time_zone="+00:00"', 
                'SET NAMES utf8',
                'SET SQL_MODE=""',
            ), // make sure we stay UTC and utf-8,
            'autoConnect'           => true,
        ),
        
        'request'=>array( 
            'class'             => 'common.components.web.BaseHttpRequest',
            'csrfCookie'        => array(
                'httpOnly'      => true,
            ),
            'csrfTokenName'           => 'csrf_token',
            'enableCsrfValidation'    => true,
            'enableCookieValidation'  => true,
        ),
        
        'cache' => array(
            'class'     => 'system.caching.' . (!MW_DEBUG ? 'CFileCache' : 'CDummyCache'),
            'keyPrefix' => md5('v.' . MW_VERSION . Yii::getPathOfAlias('common')),
        ),
        
        'urlManager' => array(
            'class'          => 'CUrlManager',
            'urlFormat'      => 'path',
               'showScriptName'=>'false',
            'caseSensitive'  => false,
            'urlSuffix'      => null, 
            'rules'          => array(
                array('listings/index', 'pattern' =>'<p_type:('.$cat_slug.')>s-for-sale/*','urlSuffix'      => '.html'), 
                array('listings/index', 'pattern' =>'offplan-properties-for-sale/*','urlSuffix'      => '.html'),
                
                array('searchlist/index', 'pattern' =>'<listing_type:(residential|commercial)>/<category:('.$cat_slug.')>/<sect:(for-sale|for-rent)>/*'),
                array('searchlist/index', 'pattern' =>'<listing_type:(residential|commercial)>/<sect:(for-sale|for-rent)>/*'),
                array('searchlist/index', 'pattern' =>'<listing_type:(residential|commercial)>/<category:('.$cat_slug.')>/*'),
                array('searchlist/index', 'pattern' =>'<category:('.$cat_slug.')>/<sect:(for-sale|for-rent)>/*'),
                array('searchlist/index', 'pattern' =>'<listing_type:(residential|commercial)>/*'),
                array('searchlist/index', 'pattern' =>'<sect:(for-sale|for-rent)>/*'),
                array('searchlist/index', 'pattern' =>'<category:('.$cat_slug.')>/*'),
                array('searchlist/index', 'pattern' => 'properties'),
                
                array('listings/project', 'pattern' =>'offplan-project/<state_slug:(.*)>/<community_slug:(.*)>/<slug:(.*)>/*','urlSuffix'      => '.html'),  
                array('listings/project', 'pattern' =>'offplan-project/<slug:(.*)>/*','urlSuffix'      => '.html'),
                
                array('articles/reviews', 'pattern' => 'reviews','urlSuffix'     => '.html'),
                
                array('gomasterkey_xml/new', 'pattern' => 'gomasterkey_xml/new'),
                array('adlist/index', 'pattern' => 'adlist/<slug:(.*)>'),
                array('details/index', 'pattern' => 'details/<slug:(.*)>'),
                array('articles/index', 'pattern' => 'articles/page/<page:(\d+)>'),
                array('articles/index', 'pattern' => 'articles'),
                //array('articles/category', 'pattern' => 'articles/<slug:(.*)>'),
                //array('articles/view', 'pattern' => 'article/<slug:(.*)>'),
                array('list_your_property/index', 'pattern' =>'list-your-property','urlSuffix'      => '.html'),   
                array('articles/our_teams', 'pattern' =>'our-teams','urlSuffix'      => '.html'),  
                array('articles/team', 'pattern' =>'team/<name:(.*)>','urlSuffix'      => '.html'), 
                array('articles/career', 'pattern' =>'career','urlSuffix'      => '.html'), 
                array('articles/career/success/1', 'pattern' =>'send-cv','urlSuffix'      => '.html'), 
                array('articles/validatefrm', 'pattern' =>'validatefrm','urlSuffix'      => '.html'), 
                array('articles/view/slug/about-us', 'pattern' => 'about-us'),
                array('articles/property_management_services', 'pattern' => 'property-management-services'),
                
                
                
                array('searchlist/index', 'pattern' => 'properties'),
                array('searchlist/index', 'pattern' => 'properties/*'),
                // array('details/index/offplan/1/section/1', 'pattern' => 'offplan-property-for-sale/<slug:(.*)>' ,'urlSuffix'      => '.html', ),
                // array('details/index/offplan/1/section/2', 'pattern' => 'offplan-property-for-rent/<slug:(.*)>' ,'urlSuffix'      => '.html',),
                
                array('details/index/section/1', 'pattern' => 'sale/<slug:(.*)>' ,'urlSuffix'      => '.html', ),
                array('details/index/section/2', 'pattern' => 'rent/<slug:(.*)>' ,'urlSuffix'      => '.html',),
                array('searchlist/index/section/1', 'pattern' => 'properties-for-sale'),
                array('searchlist/index/section/2', 'pattern' => 'properties-for-rent'),
                
                
                array('searchlist/index/section/1/listing_type/C', 'pattern' => 'commercial-properties-for-sale'),
                array('searchlist/index/section/1/listing_type/R', 'pattern' => 'residential-properties-for-sale'),
                array('searchlist/index/section/2/listing_type/C', 'pattern' => 'commercial-properties-for-rent'),
                array('searchlist/index/section/2/listing_type/R', 'pattern' => 'residential-properties-for-rent'),
                array('searchlist/index/off_plan/1', 'pattern' => 'off-plan-properties'),
                array('searchlist/index/listing_type/C', 'pattern' => 'commercial-properties'),
                array('searchlist/index/listing_type/R', 'pattern' => 'residential-properties'),
                array('contact/index', 'pattern' => 'contact-us'),
                array('place_an_ad/index', 'pattern' => 'list-property'), 
                array('searchlist/encode', 'pattern' => 'searchlist/encode?/*'),
                array('hybridauth/endpoint', 'pattern' => 'hybridauth/endpoint?hauth.done'),
                array('details/index', 'pattern' => '<slug:(.*)>/detailView'), 
                array('project/detail', 'pattern' => '<slug:(.*)>/projectView'), 
                array('project/floor_detail', 'pattern' => '<slug:(.*)>/floorPlan'), 
                array('project/floor_plan', 'pattern' => 'floor-plan'), 
                array('project/site_map', 'pattern' => 'site-map'), 
                array('blog/details', 'pattern' => 'blog/<slug:(.*)>/<action:(details)>'), 
                array('blog/index', 'pattern' => 'blog/<slug:(.*)>'), 
                array('articles/area_guide_detail', 'pattern' => 'area-guides/<slug:(.*)>','urlSuffix'     => '.html'),
                array('articles/top_developers', 'pattern' => 'developers','urlSuffix'     => '.html'),
                array('articles/view_developer', 'pattern' => 'developers/<slug:(.*)>','urlSuffix'     => '.html'),
                 array('articles/testimonials', 'pattern' =>'testimonials','urlSuffix'      => '.html'), 
                
                ),
        ),
        
        'messages' => array(
            'class'     => 'CPhpMessageSource',
            'basePath'  => Yii::getPathOfAlias('common.messages'),
        ),
        
        'log' => array(
            'class' => 'CLogRouter',
            'routes' => array(
                array(
                    'class'   => 'CFileLogRoute',
                    'levels'  => 'error',
                    'enabled' => true,
                ),
                array(
                    'class'   => 'CWebLogRoute',
                    'filter'  => 'CLogFilter',
                    'enabled' => MW_DEBUG,
                ),
                array(
                    'class'   => 'CProfileLogRoute',
                    'report'  => 'summary', 
                    'enabled' => MW_DEBUG,
                ),
            ),
        ),
        
        'errorHandler' => array(
            'errorAction' => 'site/error',
        ),
        
        'format' => array(
            'class' => 'system.utils.CLocalizedFormatter',
        ),
        
        'passwordHasher' => array(
            'class' =>  'common.components.utils.PasswordHasher',
        ),
        
        'ioFilter' => array(
            'class' => 'common.components.utils.IOFilter',
        ),
        
        'hooks' => array(
            'class' => 'common.components.managers.HooksManager',
        ),
        
        'options' => array(
            'class' => 'common.components.managers.OptionsManager',
            'cacheTtl' => MW_CACHE_TTL,
        ),
        
        'notify' => array(
            'class' => 'common.components.managers.NotifyManager',
        ),
        
        'mailer' => array(
            'class' => 'common.components.mailer.Mailer',
        ),
        
        'mutex' => array(
            'class'     => 'common.components.mutex.FileMutex',
            'fileMode'  => 0666,
            'dirMode'   => 0777,
        ),
        
        'extensionMimes' => array(
            'class' => 'common.components.utils.FileExtensionMimes',
        ),
        
        'extensionsManager' => array(
            'class'    => 'common.components.managers.ExtensionsManager',
            'paths'    => array(
                array(
                    'alias'    => 'common.extensions', 
                    'priority' => -1000
                ),
                array(
                    'alias'    => 'extensions', 
                    'priority' => -999
                ),
            ),
            'coreExtensionsList' => array(),
        ),
        
        'systemInit' => array(
            'class' => 'common.components.init.SystemInit',
        ),
    ),
    
    'modules' => array(
           'gii' => array(
            'class' => 'system.gii.GiiModule',
            'password' => '1',
            'generatorPaths' => array(
                //    'bootstrap.gii', // since 0.9.1
            ),
            // If removed, Gii defaults to localhost only. Edit carefully to taste.
            'ipFilters' => array('127.0.0.1', '::1'),
        ),
    ),
    
    // application-level parameters that can be accessed
    // using Yii::app()->params['paramName']
    'params' => array(
      'isTrash' =>'0',
      'onTrash' =>'1',
    ),
);
