<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * GridViewBulkAction
 * 
 * @package RedSpider EMA
 * @author Rauf Ahmad <ahmad@redspider.ae> 
 * @link https://www.redspider.ae/
 * @copyright 2013-2017 RedSpider EMA (https://www.redspider.ae)
 * @license https://www.redspider.ae/license/
 * @since 1.3.5.4
 */

class GridViewBulkPublishAction extends CWidget
{
    public $model;

    public $formAction;

    public function init()
    {
        parent::init();
        Yii::app()->clientScript->registerScriptFile(Yii::app()->apps->getBaseUrl('assets/js/grid-view-bulk-action.js'));
    }

    public function run()
    {
        $this->render('grid-view-bulk-publish-action', array(
            'model'       => $this->model,
            'bulkActions' => $this->model->getPublishList(),
            'formAction'  => $this->formAction,
        ));
    }
}
