<?php defined('MW_PATH') || exit('No direct script access allowed');


/**
 * This hook gives a chance to prepend content or to replace the default view content with a custom content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->renderContent} to false 
 * in order to stop rendering the default content.
 * @since 1.3.3.1
 */
$hooks->doAction('before_view_file_content', $viewCollection = new CAttributeCollection(array(
    'controller'    => $this,
    'renderContent' => true,
)));

// and render if allowed
if ($viewCollection->renderContent) { ?>
    <div class="box box-primary">
        <div class="box-header">
            <div class="pull-left">
                <h3 class="box-title">
                    <span class="glyphicon glyphicon-star"></span> <?php echo $title; ?>
                </h3>
            </div>
            <div class="pull-right">
                <?php echo CHtml::link(Yii::t('app', 'Create new'), Yii::app()->createUrl(Yii::app()->controller->id . '/create', array('pot' => rand(10, 1000))), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Create new'))); ?>
                <?php echo CHtml::link(Yii::t('app', 'Refresh'), array(Yii::app()->controller->id . '/index'), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Refresh'))); ?>
            </div>

            <div class="clearfix"><!-- --></div>
        </div>
        <div class="box-body">
            <div class="table-responsive">
                <div class="col-sm-4" style="padding-left:0px;">
                    <label>Country</label>
                    <?php

                    echo CHtml::dropDownList('country', $model->country, $model->countryListId(), array('class' => 'form-control',   'onchange' => 'setTagThis(this,"country")', 'empty' => 'Select', 'style' => 'width:auto;display:inline;vertical-align: middle;')) . '';

                    ?>

                </div>
                <script>
                    function setTagThis(k, id) {
                         
                            $('#<?php echo $model->modelName; ?>_' + id).val($(k).val()).change();
                        
                    }
                </script>
                <?php
                /**
                 * This hook gives a chance to prepend content or to replace the default grid view content with a custom content.
                 * Please note that from inside the action callback you can access all the controller view
                 * variables via {@CAttributeCollection $collection->controller->data}
                 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->renderGrid} to false 
                 * in order to stop rendering the default content.
                 * @since 1.3.3.1
                 */
                $hooks->doAction('before_grid_view', $collection = new CAttributeCollection(array(
                    'controller'    => $this,
                    'renderGrid'    => true,
                )));

                $this->widget('common.components.web.widgets.GridViewBulkPublishAction', array(
                    'model'      => $model,
                    'formAction' => $this->createUrl($this->id . '/bulk_action'),
                ));
                // and render if allowed
                if ($collection->renderGrid) {
                    $this->widget('zii.widgets.grid.CGridView', $hooks->applyFilters('grid_view_properties', array(
                        'ajaxUrl'           => $this->createUrl($this->route),
                        'ajaxUpdate'        => false,
                        'id'                => $model->modelName . '-grid',
                        'dataProvider'      => $model->search(),
                        'filter'            => $model,
                        'filterPosition'    => 'body',
                        'filterCssClass'    => 'grid-filter-cell',
                        'itemsCssClass'     => 'table table-bordered table-hover table-striped',
                        'selectableRows'    => 0,
                        'enableSorting'     => false,
                        'cssFile'           => false,

                        'emptyText' => $this->tag->getTag('no-result-found', 'No results found.'),

                        'pagerCssClass'     => 'pagination pull-right',
                        'pager'             => array(
                            'class'         => 'CLinkPager',
                            'cssFile'       => false,
                            'header'        => false,
                            'htmlOptions'   => array('class' => 'pagination')
                        ),
                        'columns' => $hooks->applyFilters('grid_view_columns', array(
                            array(
                                'class'               => 'CCheckBoxColumn',
                                'name'                => 'id',
                                'selectableRows'      => 100,
                                'checkBoxHtmlOptions' => array('name' => 'bulk_item[]'),
                            ),
                            array(
                                'name'  => 'id',
                                'value' => '@$data->id',
                                'htmlOptions' => array("width" => "120px", "style" => "text-align:center;"),

                                'filter' =>  CHtml::activehiddenField($model, 'country')

                            ),
                            array(
                                'name'  => 'ad_title',
                                'value' => '$data->litleWithTag2',
                                'type' => 'raw',
                            ),
                            array(
                                'name'  => 'image',
                                'value' => '@$data->ProjectImage',
                                'type'  => 'raw',
                                'filter' => false,
                            ),
                            array(
                                'name'  => 'date_added',
                                'value' => '@$data->SmallDate',
                                'htmlOptions' => array("width" => "80px", "style" => "text-align:right;"),
                                'filter' => false,
                                'visible' =>  $model->showDateAddedField
                            ),
                            array(
                                'name'  => 'l_updated',
                                'value' => '@$data->LastUpdateSmall',
                                'htmlOptions' => array("width" => "80px", "style" => "text-align:right;"),
                                'filter' => false,
                                'visible' => $model->showUpdatedField
                            ),
                            array(
                                'name'  => 'api_id',
                                'value' => '$data->api_id',

                            ),
                            array(
                                'name'  => 'community_id',
                                'value' => '@$data->community->community_name',
                                'type' => 'raw',
                            ),



                            array(
                                'name'  => 'status',
                                'value' => '$data->StatusLinkFront',
                                'filter' => array("A" => "Published", "I" => "Unpublished"),
                                'htmlOptions' => array("width" => "50px", "style" => "text-align:center;"),
                                'type'  => 'raw',
                            ),
                            array(
                                'name'  => 'project_status',
                                'value' => '$data->project_status',
                                'filter' => $model->project_statusList(),
                                'htmlOptions' => array("width" => "50px", "style" => "text-align:center;"),
                                'type'  => 'raw',
                            ),
                            array(
                                'name'  => 'sale_status',
                                'value' => '$data->sale_status',
                                'filter' => $model->sale_statusList(),
                                'htmlOptions' => array("width" => "50px", "style" => "text-align:center;"),
                                'type'  => 'raw',
                            ),
                            array(
                                'name' => 'featured',
                                'type' => 'raw',
                                'filter' => false,
                                'value' => '$data->featuredT',


                                'filter' => array("Y" => "Featured", "N" => "Not Featured"),
                                'htmlOptions' => array("style" => "width:50px;text-align:center", "class" => "form-controll"),
                            ),

                            array(
                                'class'     => 'CButtonColumn',
                                'header'    => $this->tag->getTag('options', 'Options'),
                                'buttons'   => array(
                                    'update' => array(
                                        'label'     => ' &nbsp; <span class="fa fa-edit"></span> &nbsp;',
                                        'url'       => 'Yii::app()->createUrl("' . Yii::app()->controller->id . '/update", array("id" => $data->id))',
                                        'imageUrl'  => null,
                                        'options'   => array('title' => Yii::t('app', $this->tag->getTag('update-property', 'Update')), 'class' => ''),
                                    ),
                                    'view' => array(
                                        'label'     => ' &nbsp; <span class="fa  fa-eye"></span> &nbsp;',
                                        'url'       => '$data->PreviewUrlTrash',
                                        'imageUrl'  => null,
                                        'options'   => array('title' => Yii::t('app', $this->tag->getTag('view', 'View')), 'class' => '', 'target' => '_blank'),

                                    ),
                                    'delete' => array(
                                        'label'     => ' &nbsp; <span class="fa  fa-trash-o"></span> &nbsp; ',
                                        'url'       => 'Yii::app()->createUrl("' . Yii::app()->controller->id . '/delete", array("id"=>$data->id))',
                                        'imageUrl'  => null,
                                        'options'   => array('title' => Yii::t('app', $this->tag->getTag('delete', 'Delete')), 'class' => 'delete'),
                                        // 'visible'   => '$data->removable === User::TEXT_YES',
                                    ),

                                    'ban' => array(
                                        'label'     => ' &nbsp; <span class="fa  fa-ban"></span> &nbsp; ',
                                        'url'       => 'Yii::app()->createUrl("' . Yii::app()->controller->id . '/status",array("id"=>$data->id,"status"=>$data->status))',
                                        'imageUrl'  => null,
                                        'visible'   => '$data->inactiveVisibility',
                                        'options'   => array(
                                            'title' => Yii::t('app', $this->tag->getTag('make-in-active-this-ad', 'Make inactive this ad')),
                                            'class' => 'Block',

                                        ),

                                    ),

                                    'ban2' => array(
                                        'label'     => ' &nbsp; <span class="glyphicon glyphicon-play"></span> &nbsp; ',
                                        'url'       => 'Yii::app()->createUrl("' . Yii::app()->controller->id . '/status2",array("id"=>$data->id,"status"=>$data->status))',
                                        'imageUrl'  => null,
                                        'visible'   => '$data->activeVisibility',
                                        'options'   => array(
                                            'title' => Yii::t('app', $this->tag->getTag('make-active-this-ad', 'Make active this ad')),
                                            'class' => 'Block',

                                        ),

                                    ),


                                ),
                                'htmlOptions' => array(
                                    'style' => 'width:150px;',
                                ),
                                'template' => '{ban} {ban2} {update}{delete} {view}'
                            ),
                        ), $this),
                    ), $this));
                }
                /**
                 * This hook gives a chance to append content after the grid view content.
                 * Please note that from inside the action callback you can access all the controller view
                 * variables via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('after_grid_view', new CAttributeCollection(array(
                    'controller'    => $this,
                    'renderedGrid'  => $collection->renderGrid,
                )));
                ?>
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="clearfix"><!-- --></div>
        </div>
    </div>
    </div>
<?php
}
/**
 * This hook gives a chance to append content after the view file default content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * @since 1.3.3.1
 */
$hooks->doAction('after_view_file_content', new CAttributeCollection(array(
    'controller'        => $this,
    'renderedContent'   => $viewCollection->renderContent,
)));
?>
<style>
    span.label.dis {
        background: #fff !important;
        border: 1px solid #eee !important;
        color: #666 !important;
    }
</style>
<script>
    function updateTag(k) {
        var data_id = $(k).attr('data-id');
        var data_fun = $(k).attr('data-fun');
        if (data_id !== undefined && data_fun !== undefined) {
            var itmm = $(k);
            $.get('<?php echo Yii::App()->createUrl('offplan/update_tag'); ?>/id/' + data_id + '/fun/' + data_fun, function(data) {

                var data = JSON.parse(data);
                if (data.class == "0") {
                    itmm.removeClass('dis');
                } else {
                    itmm.addClass('dis');
                }

            })
        }

    }
</script>