<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * This file is part of the MailWizz EMA application.
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */

?>
<!DOCTYPE html>
<html dir="<?php echo Yii::app()->locale->orientation; ?>">

<head>
    <meta charset="<?php echo Yii::app()->charset; ?>">
    <title><?php echo CHtml::encode($pageMetaTitle); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="<?php echo CHtml::encode($pageMetaDescription); ?>">
    <link rel="shortcut icon" href="<?php echo Yii::app()->apps->getBaseurl('frontend/assets/kaye/images/favicon.png'); ?>" type="image/x-icon" />
    <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
      <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
    <![endif]-->
</head>

<body class="skin-blue">
    <div class="wrapper">
        <div class="row" style="    background: #212529;/* height: 50px; */display:flex;align-items:center;justify-content:center;min-height: 100vh;padding: 50px 0px;">

            <div class="col-lg-4">
                <div id="notify-container">
                    <?php echo Yii::app()->notify->show(); ?>
                </div>
                <img src="<?php echo Yii::App()->apps->getBaseUrl('assets/img/dsqlogo-white.png'); ?>" style="width: 300px;margin-bottom:40px;display: flex;align-items: center;justify-content: center;margin: 0px auto 50px;">
                <?php echo $content; ?>
            </div>
            <!-- -->
        </div>
        <div class="clearfix"><!-- --></div>
    </div>
</body>

</html>