<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * This file is part of the MailWizz EMA application.
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */

/**
 * This hook gives a chance to prepend content or to replace the default view content with a custom content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * In case the content is replaced, make sure to set {@CAttributeCollection $collection->renderContent} to false 
 * in order to stop rendering the default content.
 * @since 1.3.3.1
 */
$hooks->doAction('before_view_file_content', $viewCollection = new CAttributeCollection(array(
    'controller'    => $this,
    'renderContent' => true,
)));

// and render if allowed
if ($viewCollection->renderContent) {
    /**
     * This hook gives a chance to prepend content before the active form or to replace the default active form entirely.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * In case the form is replaced, make sure to set {@CAttributeCollection $collection->renderForm} to false 
     * in order to stop rendering the default content.
     * @since 1.3.3.1
     */
    $hooks->doAction('before_active_form', $collection = new CAttributeCollection(array(
        'controller'    => $this,
        'renderForm'    => true,
    )));
    
  
    if ($collection->renderForm) {
        $form = $this->beginWidget('CActiveForm',array('htmlOptions'=>array('class'=>'form-horizontal','enctype' => 'multipart/form-data'),'focus'=>array($user,'hotel_name'))); 
        ?>
        <div class="box box-primary">
            <div class="box-header">
                <div class="pull-left">
                    <h3 class="box-title"><span class="glyphicon glyphicon-star"></span> <?php echo $pageHeading;?></h3>
                </div>
                <div class="pull-right">
                    <?php if (!$user->isNewRecord) { ?>
                    <?php echo CHtml::link(Yii::t('app', 'Create new'), array('countries/create'), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Create new')));?>
                    <?php } ?>
                    <?php echo CHtml::link(Yii::t('app', 'Cancel'), array('countries/index'), array('class' => 'btn btn-primary btn-xs', 'title' => Yii::t('app', 'Cancel')));?>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-body">
                <?php 
                /**
                 * This hook gives a chance to prepend content before the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables 
                 * via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('before_active_form_fields', new CAttributeCollection(array(
                    'controller'    => $this,
                    'form'          => $form    
                )));
                ?>
                <div class="clearfix"><!-- --></div>
                
                   <div class="clearfix"><!-- --></div>
                <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($user, 'country_name');?>
                    <?php echo $form->textField($user, 'country_name', $user->getHtmlOptions('country_name')); ?>
                    <?php echo $form->error($user, 'country_name');?>
                </div>        
                   <div class="clearfix"><!-- --></div>
                <div class="form-group col-lg-6">
                    <?php echo $form->labelEx($user, 'country_code');?>
                    <?php echo $form->textField($user, 'country_code', $user->getHtmlOptions('country_code')); ?>
                    <?php echo $form->error($user, 'country_code');?>
                </div>        
                 <div class="clearfix"><!-- --></div>
                 		<div class="form-group col-lg-6">
			<?php
			if($logo = $user->getGravatarUrl(90, 90)){ ?>	
			<div class="col-lg-2">
			<img src="<?php echo $user->getGravatarUrl(90, 90);?>" class="img-thumbnail"/>
			</div>
			<?php } ?> 
			<div class="col-lg-10">
			<?php echo $form->labelEx($user, 'flag');?>
			<?php echo $form->fileField($user, 'flag', $user->getHtmlOptions('flag')); ?>
			<?php echo $form->error($user, 'flag');?>    
			</div>
			</div>  
		 
                 <div class="clearfix"><!-- --></div>
         
                 <div class="clearfix"><!-- --></div>
                 <div class="form-group col-lg-6">
					
                    <?php echo $form->labelEx($user, 'location');?>
                     <?php echo $form->error($user, 'location');?>
                    <div class="clearfix"><!-- --></div>
                    
                  <?php
                   echo $form->hiddenField($user, 'location_latitude');
                   echo $form->hiddenField($user, 'location_longitude');
					?>
					 
                    
                </div> 
                <div class="clearfix"><!-- --></div>
               <?php
               Yii::import('backend.extensions.EGMap.*');
				$gMap = new EGMap();
				$gMap->setWidth('100%');
				$gMap->setHeight(550);
				$gMap->zoom = 6;
				$mapTypeControlOptions = array(
				  'position' => EGMapControlPosition::RIGHT_TOP,
				  'style' => EGMap::MAPTYPECONTROL_STYLE_HORIZONTAL_BAR
				);
				 
				$gMap->mapTypeId = EGMap::TYPE_ROADMAP;
				$gMap->mapTypeControlOptions = $mapTypeControlOptions;
				 
				// Preparing InfoWindow with information about our marker.
				$info_window_a = new EGMapInfoWindow("<div class='gmaps-label' style='color: #000;'>Hi! I'm your marker!</div>");
				 
				// Setting up an icon for marker.
				$icon = new EGMapMarkerImage("http://google-maps-icons.googlecode.com/files/hotel.png");
				 
				$icon->setSize(32, 37);
				$icon->setAnchor(16, 16.5);
				$icon->setOrigin(0, 0);
				 
				// Saving coordinates after user dragged our marker.
				$dragevent = new EGMapEvent('dragend', "function (event) {sun(event.latLng.lat(),event.latLng.lng()); ; }", false, EGMapEvent::TYPE_EVENT_DEFAULT);
				 
			// If we have already created marker - show it
			if ($user->location_latitude!="" and $user->location_longitude!="") {
			 
				$marker = new EGMapMarker($user->location_latitude, $user->location_longitude, array('title' => Yii::t('hotel', $user->country_name),
						'icon'=>$icon, 'draggable'=>true), 'marker', array('dragevent'=>$dragevent));
				$marker->addHtmlInfoWindow($info_window_a);
				
				 $gMap->addMarker($marker);
			  
				$gMap->setCenter($user->location_latitude,$user->location_longitude);
				$gMap->zoom = 5;
			 
			// If we don't have marker in database - make sure user can create one
			} else {
			 
				 $lat = 25.18;
				 $long = 55.20;
			 
			     $gMap->setCenter($lat, $long);
			    // Setting up new event for user click on map, so marker will be created on place and respectful event added.
			    $gMap->addEvent(new EGMapEvent('click',
					'function (event) {var marker = new google.maps.Marker({position: event.latLng, map: '.$gMap->getJsName().
					', draggable: true, icon: '.$icon->toJs().'}); '.$gMap->getJsName().
					'.setCenter(event.latLng); var dragevent = '.$dragevent->toJs('marker').
					';sun(event.latLng.lat(),event.latLng.lng()); }', false, EGMapEvent::TYPE_EVENT_DEFAULT_ONCE));
		}
		$gMap->renderMap(array(), Yii::app()->language);
					   ?>
                <div class="clearfix"><!-- --></div>
            </div>
                  
                <div class="clearfix"><!-- --></div>
               
                
                <div class="clearfix"><!-- --></div>     
                <?php 
                /**
                 * This hook gives a chance to append content after the active form fields.
                 * Please note that from inside the action callback you can access all the controller view variables 
                 * via {@CAttributeCollection $collection->controller->data}
                 * @since 1.3.3.1
                 */
                $hooks->doAction('after_active_form_fields', new CAttributeCollection(array(
                    'controller'    => $this,
                    'form'          => $form    
                )));
                ?> 
                <div class="clearfix"><!-- --></div>
            </div>
            <div class="box-footer">
                <div class="pull-right">
                    <button type="submit" class="btn btn-primary btn-submit" data-loading-text="<?php echo Yii::t('app', 'Please wait, processing...');?>"><?php echo Yii::t('app', 'Save changes');?></button>
                </div>
                <div class="clearfix"><!-- --></div>
            </div>
        </div>
        <?php 
        $this->endWidget(); 
    }
    /**
     * This hook gives a chance to append content after the active form.
     * Please note that from inside the action callback you can access all the controller view variables 
     * via {@CAttributeCollection $collection->controller->data}
     * @since 1.3.3.1
     */
    $hooks->doAction('after_active_form', new CAttributeCollection(array(
        'controller'      => $this,
        'renderedForm'    => $collection->renderForm,
    )));
}
/**
 * This hook gives a chance to append content after the view file default content.
 * Please note that from inside the action callback you can access all the controller view
 * variables via {@CAttributeCollection $collection->controller->data}
 * @since 1.3.3.1
 */
$hooks->doAction('after_view_file_content', new CAttributeCollection(array(
    'controller'        => $this,
    'renderedContent'   => $viewCollection->renderContent,
)));
?>
<script type="text/javascript">

function sun(lat,lan)
{
	 
$("#Countries_location_latitude").val(lat);
$("#Countries_location_longitude").val(lan);
}
</script>
