<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * Article_categoriesController
 * 
 * Handles the actions for articles categories related tasks
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class Top_areasController extends Controller
{
    public function init()
    {
      
        parent::init();
    }
    
    /**
     * Define the filters for various controller actions
     * Merge the filters with the ones from parent implementation
     */
 
    /**
     * Listing all the available article categories
     */
    public function actionIndex()
    {
        $request    = Yii::app()->request;
        $category   = new TopAreas('search');
        $category->unsetAttributes();
        
        // for filters.
        $category->attributes = (array)$request->getQuery($category->modelName, array());

        $this->setData(array(
            'pageMetaTitle'     => $this->data->pageMetaTitle . ' | '. Yii::t('articles', 'View top areas  '), 
            'pageHeading'       => Yii::t('articles', 'View top areas   '),
            'pageBreadcrumbs'   => array(
                Yii::t('articles', 'Locations')      => $this->createUrl('city/index'),
               // Yii::t('articles', 'building guides')    => $this->createUrl($this->id.'/index'),
                Yii::t('app', 'View all'),
            )
        ));
        
        $this->render('list', compact('category'));
    }
    
    /**
     * Create a new article category
     */
    public function actionCreate()
    {
        $request    = Yii::app()->request;
        $notify     = Yii::app()->notify;
        $category   = new TopAreas();
        
        if ($request->isPostRequest && ($attributes = (array)$request->getPost($category->modelName, array()))) {
            $category->attributes = $attributes;
       
            $uploadedFile=CUploadedFile::getInstance($category,'banner');
            if($uploadedFile){
            $fileName = rand(100,1000).$uploadedFile;
            $category->banner = $fileName;
            } 
            if (!$category->save()) {
                $notify->addError(Yii::t('app', 'Your form has a few errors, please fix them and try again!'));
            } else {
				if($uploadedFile)
					{
					$path =  Yii::app()->basePath . '/../../uploads';
					$uploadedFile->saveAs($path.'/banner/'. $fileName);
					}
                $notify->addSuccess(Yii::t('app', 'Your form has been successfully saved!'));
            }
            
            Yii::app()->hooks->doAction('controller_action_save_data', $collection = new CAttributeCollection(array(
                'controller'=> $this,
                'success'   => $notify->hasSuccess,
                'category'  => $category,
            )));
            
            if ($collection->success) {
                $this->redirect(array($this->id.'/index'));
            }
        }
        
        $this->setData(array(
            'pageMetaTitle'     => $this->data->pageMetaTitle . ' | '. Yii::t('articles', 'Create new top area'), 
            'pageHeading'       => Yii::t('articles', 'Create new top area'),
            'pageBreadcrumbs'   => array(
                 Yii::t('articles', 'Top Areas')    => $this->createUrl($this->id.'/index'),
                Yii::t('app', 'Create new'),
            )
        ));
        $apps = Yii::app()->apps;
               $this->getData('pageScripts')->add(array('src' => $apps->getBaseUrl('backend/assets/js/dropzone.min.js')));
        $this->getData('pageStyles')->add(array('src' => $apps->getBaseUrl('backend/assets/css/dropzone.css')));
        
		$this->getData('pageStyles')->add(array('src' => $apps->getBaseUrl('assets/css/select2.min.css')));
		$this->getData('pageScripts')->add(array('src' => $apps->getBaseUrl('assets/js/select2.min.js')));
        $this->render('form', compact('category'));
    }
    
    /**
     * Update existing article category
     */
    public function actionUpdate($id)
    {
        $category = TopAreas::model()->findByPk((int)$id);

        if (empty($category)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
        
        $request    = Yii::app()->request;
        $notify     = Yii::app()->notify;

        if ($request->isPostRequest && ($attributes = (array)$request->getPost($category->modelName, array()))) {
              $oldfilename =$category->banner;
            $category->attributes = $attributes;
             
          
              
             $file = CUploadedFile::getInstance($category, 'banner');
			 
			if (is_object($file) && get_class($file)==='CUploadedFile') {	          
				
				$fileName = rand(100,1000).$file;
				$category->banner = $fileName;
			 } else {
				$category->banner = $oldfilename;
			 }
            if (!$category->save()) {
                $notify->addError(Yii::t('app', 'Your form has a few errors, please fix them and try again!'));
            } else {
		 
				if (is_object($file) && get_class($file)==='CUploadedFile') {
				 
				$path =  Yii::app()->basePath . '/../../uploads';
				$file->saveAs($path.'/banner/'. $fileName);
				if ($oldfilename != $fileName) {
				@unlink(Yii::app()->basePath . '/../../uploads/banner/'. $oldfilename);
				}
				}
                $notify->addSuccess(Yii::t('app', 'Your form has been successfully saved!'));
            }
            
            Yii::app()->hooks->doAction('controller_action_save_data', $collection = new CAttributeCollection(array(
                'controller'=> $this,
                'success'   => $notify->hasSuccess,
                'category'  => $category,
            )));
            
            if ($collection->success) {
                $this->redirect(array($this->id.'/index'));
            }
        }
        $image_array = array(); 
				  if(!empty($category->image)){
							$exp =  explode(",",$category->image);
							if($exp)
							{
							foreach($exp as $k=>$v)
							{
							if($v!="")
							{
							$image_array[] = $v;
							}
							}
						  }
					}
        
        $this->setData(array(
            'pageMetaTitle'         => $this->data->pageMetaTitle . ' | '. Yii::t('articles', 'Update top area'), 
            'pageHeading'           => Yii::t('articles', 'Update top area'),
            'pageBreadcrumbs'       => array(
                //Yii::t('articles', 'Locations')      => $this->createUrl('city/index'),
                Yii::t('articles', 'Top Areas')   => $this->createUrl($this->id.'/index'),
                Yii::t('app', 'Update'),
            )
        ));
        $apps = Yii::app()->apps;
        
        $this->getData('pageScripts')->add(array('src' => $apps->getBaseUrl('backend/assets/js/dropzone.min.js')));
        $this->getData('pageStyles')->add(array('src' => $apps->getBaseUrl('backend/assets/css/dropzone.css')));
        
		$this->getData('pageStyles')->add(array('src' => $apps->getBaseUrl('assets/css/select2.min.css')));
		$this->getData('pageScripts')->add(array('src' => $apps->getBaseUrl('assets/js/select2.min.js')));
        $this->render('form', compact('category','image_array'));
    }
    
    /**
     * Delete exiting article category, allowed only via POST method
     */
    public function actionDelete($id)
    {
        $category = TopAreas::model()->findByPk((int)$id);
        
        if (empty($category)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
        
        $category->delete();
        
        $request    = Yii::app()->request;
        $notify     = Yii::app()->notify;
        
        if (!$request->getQuery('ajax')) {
            $notify->addSuccess(Yii::t('app', 'The item has been successfully deleted!'));
            $this->redirect($request->getPost('returnUrl', array($this->id.'/index')));
        }
    }
    public $last_updated;
    public function actionCategories($id){
        $html ='<option value="">Please Select</option;>';
        $ar = CHtml::listData(Category::model()->category_by_type($id),'category_id','category_name');
        if(!empty($ar)){
            foreach($ar as $k=>$v){
            $html .= '<option value="'.$k.'">'.$v.'</option;>';
            }
        }
        echo  $html; 
    }
    public function actionsubcomunities($id){
        $html ='<option value="">Please Select</option;>';
        $ar = CHtml::listData(SubCommunity::model()->subCommunities($id),'sub_community_id','sub_community_name'); 
        if(!empty($ar)){
            foreach($ar as $k=>$v){
            $html .= '<option value="'.$k.'">'.$v.'</option;>';
            }
        }
        echo  $html; 
    }
     
}
