<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * UsersController
 * 
 * Handles the actions for users related tasks
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class CareersController extends Controller
{
 
    /**
     * Define the filters for various controller actions
     * Merge the filters with the ones from parent implementation
     */
     public $Controlloler_title= "Careers";
     public $focus = "";
     public function init()
    {
		   $this->getData('pageScripts')->add(array('src' => Yii::app()->apps->getBaseUrl('frontend/assets/js/jquery.fancybox.js')));
            $this->getData('pageStyles')->add(array('src' => Yii::app()->apps->getBaseUrl('frontend/assets/css/jquery.fancybox.css')));
     Yii::$classMap = array_merge( Yii::$classMap, array(
            'CaptchaExtendedAction' => Yii::getPathOfAlias('root.apps.extensions.captchaExtended').DIRECTORY_SEPARATOR.'CaptchaExtendedAction.php',
            'CaptchaExtendedValidator' => Yii::getPathOfAlias('root.apps.extensions.captchaExtended').DIRECTORY_SEPARATOR.'CaptchaExtendedValidator.php'
        ));
        parent::init();
       
        
    }
 
    /**
     * List all available users
     */
    public function actionIndex()
    {
         $request = Yii::app()->request;
         $notify = Yii::app()->notify;
         $model = new CareerNew('serach');
       
         $model->unsetAttributes();
         $model->attributes = (array)$request->getQuery($model->modelName, array());
         $this->setData(array(
            'pageMetaTitle'     => $this->data->pageMetaTitle . ' | '. Yii::t(Yii::app()->controller->id, "{$this->Controlloler_title} List"), 
            'pageHeading'       => Yii::t(Yii::app()->controller->id, "{$this->Controlloler_title} List"),
            'pageBreadcrumbs'   => array(
                Yii::t(Yii::app()->controller->id, "{$this->Controlloler_title}") => $this->createUrl(Yii::app()->controller->id.'/index'),
                Yii::t('app', 'View all')
            )
         ));
        $this->render('list', compact('model'));
    }
    
    
    /**
     * Delete existing user
     */
    public function actionDelete($id)
    {
        $model = CareerNew::model()->findByPk((int)$id);
        
        if (empty($model)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
        
        
            $model->deleteByPk($id);    
         

        $request = Yii::app()->request;
        $notify = Yii::app()->notify;
        
        if (!$request->getQuery('ajax')) {
            $notify->addSuccess(Yii::t('app', 'The item has been successfully deleted!'));
            $this->redirect($request->getPost('returnUrl', array(Yii::app()->controller->id.'/index')));
        }
    }
     public function actionUpdate($id)
    {
		 
        $model = CareerNew::model()->findByPk((int)$id);

        if (empty($model)) {
            throw new CHttpException(404, Yii::t('app', 'The requested page does not exist.'));
        }
        $this->getData('pageStyles')->add(array('src' => Yii::app()->apps->getBaseUrl('assets/css/bootstrap.min.css')));
        $request = Yii::app()->request;
        $notify = Yii::app()->notify;
        
  
        
       
        
        $this->renderPartial('form', compact('model'));
    }
    
   public function actionOffplan()
    {
            $formData['_sec_id'] = 3; 
            
            $limit = '100'; 
            $modelCritera = PlaceAnAd::model()->findAds($formData, $count_future = false, 1, $calculate = false);
            $offplan = PlaceAnAd::model()->findAll($modelCritera);
            $ads = array();
            ?>
            <table><tr><th>Sl</th><th>ID</th><th>Title</th><th>Commonity</th></tr>
            <?php
            $cmunity_id = array();
            foreach($offplan as $k=>$v){
                if(in_array($v->community_id,$cmunity_id)){ continue; }
                $cmunity_id[$v->community_id] = $v->community_id;
                $communityModel = Community::model()->findByPk($v->community_id);
               // echo $v->ad_title;echo '}}}}}}}}}}}}}}}}}'; echo ;  echo '<br />';
                echo '<tr> <td>'.$communityModel->community_name.'</td></tr>';
                /*
                $ads[$v->primaryKey]['data'] = $v->attributes;
                $flor_plan = $v->adFloorPlans;
                if(!empty($flor_plan)){
                    foreach($flor_plan as $f){
                         $ads[$v->primaryKey]['floorplan'][] = $f->attributes; 
                    }
                }
                
               
                
                   
                $flor_plan = $v->pTypes1;
                if(!empty($flor_plan)){
                    foreach($flor_plan as $f){
                         $ads[$v->primaryKey]['property_types'][] = $f->attributes; 
                    }
                }
                
                $flor_plan = $v->faqList;
                if(!empty($flor_plan)){
                    foreach($flor_plan as $f){
                         $ads[$v->primaryKey]['faq'][] = $f->attributes; 
                    }
                }
                
                 
                
                $flor_plan = $v->adAmenities;
                if(!empty($flor_plan)){
                    $am_features = '';
                    foreach($flor_plan as $f){
                        $mMmodel = Amenities::model()->findByPk($f->primaryKey);
                         $am_features .= $mMmodel->amenities_name."\n";
                         
                    }
                    $ads[$v->primaryKey]['amenites'] = $am_features; 
                }
                 $flor_plan = $v->adImagesAll;
                if(!empty($flor_plan)){
                    foreach($flor_plan as $f){
                         $ads[$v->primaryKey]['ad_images'][] = $f->attributes; 
                    }
                }
                 */
                
            }
            echo '</table>';
            //echo json_encode($ads);
            exit; 
           
            
    }
    
}
