<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * LeftSideNavigationWidget
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
 
class LeftSideNavigationWidget extends CWidget
{
    public function run()
    {
        $sections   = array();
        $hooks      = Yii::app()->hooks;
        $controller = $this->controller;
        $route      = $controller->route;
        $priority   = 0;
        $request    = Yii::app()->request;
        
        Yii::import('zii.widgets.CMenu');
        
        $menuItems = array(
         
            'dashboard' => array(
                'name'      => Yii::t('app', 'Dashboard'),
                'icon'      => 'fa fa-dashboard',
                'active'    => 'dashboard',
                'route'     => array('dashboard/index'),
            ),
          
               'place_an_ad' => array(
                'name'      => Yii::t('app', 'Sale/Rent Properties'),
                'icon'      => 'glyphicon-bullhorn',
                'active'    =>  array('place_an_ad'), 
                'route'     => null,
                 'items'     => array(
					array('url' => array('place_an_ad/index'), 'label' => Yii::t('app', 'List Properties'), 'active' => strpos($route, 'place_an_ad') === 0), 
					array('url' => array('place_an_ad/ad_image'), 'label' => Yii::t('app', 'Manage Property Image'), 'active' => strpos($route, 'place_an_ad') === 0), 
					array('url' => array('place_an_ad/create'), 'label' => Yii::t('app', 'Place New  Property'), 'active' => strpos($route, 'place_an_ad') === 0), 

                  ),
            ),
        'place_an_ad2' => array(
                'name'      => Yii::t('app', 'Off-Plan Properties'),
                'icon'      => 'glyphicon-fire',
                'active'    =>  array('offplan','developer_list'), 
                'route'     => null,
                 'items'     => array(
					array('url' => array('offplan/index'), 'label' => Yii::t('app', 'List Off-Plan'), 'active' => strpos($route, 'place_an_ad') === 0), 
					//array('url' => array('place_an_ad/ad_image'), 'label' => Yii::t('app', 'Manage Property Image'), 'active' => strpos($route, 'place_an_ad') === 0), 
					array('url' => Yii::App()->createUrl('offplan/create',array('pot'=>rand(10,1000))), 'label' => Yii::t('app', 'New Project'), 'active' => strpos($route, 'offplan') === 0), 
					array('url' => array('developer_list/index'), 'label' => Yii::t('app', 'Developers'), 'active' => strpos($route, 'developer_list') === 0), 
					array('url' =>  'https://api.dsqrealestate.ae/', 'label' => Yii::t('app', 'Insert Api'), 'target' =>   '_blank'), 
					array('url' =>  'https://api.dsqrealestate.ae/offplan_api.php', 'label' => Yii::t('app', 'Search Project Api'), 'target' =>   '_blank'), 

                  ),
            ), 
              
           'banner' => array(
                'name'      => Yii::t('app', 'Enquiries List'),
                'icon'      => 'glyphicon-envelope',
                'active'    => array('contact_us','spam_report','enquiry','quiz_contact'),
                'route'     => null,
                'items'     => array(
                    array('url' => array('contact_us/index'), 'label' => Yii::t('app', 'Contact Us'), 'active' => strpos($route, 'contact_us/index') === 0),
                    array('url' => array('enquiry/index'), 'label' => Yii::t('app', 'Property Enquiry'), 'active' => strpos($route, 'enquiry/index') === 0),
                    array('url' => array('enquiry/offplan'), 'label' => Yii::t('app', 'Off-Plan  Enquiry'), 'active' => strpos($route, 'enquiry/offplan') === 0),
                    //array('url' => array('quiz_contact/index'), 'label' => Yii::t('app', 'Quiz contact'), 'active' => strpos($route, 'quiz_contact/index') === 0),
             
                ),
            ),
                    'enq1' => array(
                'name'      => Yii::t('app', 'Brochure Request'),
                'icon'      => 'glyphicon-floppy-save',
                'active'    => 'brochure',
                'route'     => array('brochure/index'),
            ),
             'list_p' => array(
                'name'      => Yii::t('app', 'List Property Interest'),
                'icon'      => 'glyphicon-star-empty',
                 'active'    => 'list_your_property',
                'route'     => array('list_your_property/index'),
            ),
                'careers' => array(
                'name'      => Yii::t('app', 'CV Submitted  List'),
                'icon'      => 'glyphicon-briefcase',
                'active'    => 'careers',
                'route'     => array('careers/index'),
            ),
              'team_reviewa' => array(
                'name'      => Yii::t('app', 'Teams-Reviews-Partners'),
                'icon'      => 'glyphicon-th-list',
                'active'    =>  array('teams','reviews','team_reviews','our_partners','awards'), 
                'route'     => null,
                 'items'     => array(
					array('url' => array('teams/index'), 'label' => Yii::t('app', 'Teams'), 'active' => strpos($route, 'teams') === 0), 
				 array('url' => array('reviews/index'), 'label' => Yii::t('app', 'Client Reviews'), 'active' => strpos($route, 'reviews') === 0), 
				 	array('url' => array('team_reviews/index'), 'label' => Yii::t('app', 'Team Reviews'), 'active' => strpos($route, 'team_reviews') === 0), 
	               // array('url' => array('our_partners/index'), 'label' => Yii::t('app', 'Partners'), 'active' => strpos($route, 'our_partners') === 0), 
	                array('url' => array('awards/index'), 'label' => Yii::t('app', 'Awards'), 'active' => strpos($route, 'awards') === 0), 
                  ),
            ),
                'users' => array(
                'name'      => Yii::t('app', 'Admin Users'),
                'icon'      => 'glyphicon-user',
                'active'    => 'users',
                'route'     => array('users/index'),
            ),
             'listingusers' => array(
                'name'      => Yii::t('app', 'Customers | Agents'),
                'icon'      => 'fa fa-user',
                'active'    => 'listingusers',
                'route'     => array('listingusers/index'),
            ),
          
            /*
                     'top_areas' => array(
                'name'      => Yii::t('app', 'Top Area'),
                'icon'      => 'glyphicon-dashboard',
                'active'    => 'top_areas',
                'route'     => array('top_areas/index'),
            ), 
            */ 
            
             /*
               'booking_user' => array(
                'name'      => Yii::t('app', 'Customers'),
                'icon'      => 'glyphicon-record',
                'active'    =>  array('listingusers','avatar'),
                'route'     => null,
                  'items'     => array(
                    array('url' => array('listingusers/index'), 'label' => Yii::t('app', 'Customers'), 'active' => strpos($route, 'listingusers') === 0),
                    //array('url' => array('#'), 'label' => Yii::t('app', 'Commission'), 'active' => strpos($route, 'agent_commission') === 0),
                ),
            ),
            * */
                
       
            
            /*
               'extend' => array(
                'name'      => Yii::t('app', 'Extend'),
                'icon'      => 'glyphicon-plus-sign',
                'active'    => array('extensions', 'theme', 'languages', 'ext'),
                'route'     => null,
                'items'     => array(
                  //  array('url' => array('extensions/index'), 'label' => Yii::t('app', 'Extensions'), 'active' => strpos($route, 'ext') === 0),
                    array('url' => array('theme/index'), 'label' => Yii::t('app', 'Themes'), 'active' => strpos($route, 'theme') === 0),
                    array('url' => array('extensions/index'), 'label' => Yii::t('app', 'Extensions'), 'active' => strpos($route, 'extensions') === 0),
                 //   array('url' => array('languages/index'), 'label' => Yii::t('app', 'Languages'), 'active' => strpos($route, 'languages') === 0),
                ),
            ),
            * */
            /*
            'projectlist' => array(
                'name'      => Yii::t('app', 'Project List'),
                'icon'      => 'glyphicon-send',
                'active'    => array('projectlist','developers'),
                'route'     => null,
                'items'     => array(
                    array('url' => array('projectlist/index'), 'label' => Yii::t('app', 'Projectlist'), 'active' => strpos($route, 'projectlist') === 0),
                    array('url' => array('developers/index'), 'label' => Yii::t('app', 'developers'), 'active' => strpos($route, 'developers') === 0),
                ),
            ),
            * */
                 'bannerpos' => array(
                'name'      => Yii::t('app', 'Manage Banners'),
                'icon'      => 'glyphicon-picture',
                'active'    => 'banner',
                'route'     => array('banner/index'),
            ),
            'bannerpos' => array(
                'name'      => Yii::t('app', 'Manage DSQ - Locations'),
                'icon'      => 'glyphicon-picture',
                'active'    => 'location_landing',
                'route'     => array('location_landing/index'),
            ),
         
             'articles' => array(
                'name'      => Yii::t('app', 'Content Pages'),
                'icon'      => 'glyphicon-book',
                'active'    =>[ 'article' ,
                    'our_partners','our_services',
                    'about_us_service','faq'],
                'route'     => null,
                'items'     => array(
                    //array('url' => array('articles/index'), 'label' => Yii::t('app', 'View all articles'), 'active' => strpos($route, 'articles/index') === 0),
                    array('url' => array('article_categories/index'), 'label' => Yii::t('app', 'View all categories'), 'active' => strpos($route, 'article_categories') === 0),
                           array('url' => array('articles/index/id/4'), 'label' => Yii::t('app', 'View all News'), 'active' => strpos($route, 'articles/index') === 0),
                           array('url' => array('articles/index/id/24'), 'label' => Yii::t('app', 'View all Guide'), 'active' => strpos($route, 'articles/index') === 0),
                    array('url' => array('articles/index/id/5'), 'label' => Yii::t('app', 'View all Content Page'), 'active' => strpos($route, 'articles/index') === 0),
                    array('url' => array('articles/index/id/25'), 'label' => Yii::t('app', 'View all Partial Page'), 'active' => strpos($route, 'articles/index') === 0),
                    // array('url' => array('articles/index/id/17'), 'label' => Yii::t('app', 'View all Projects'), 'active' => strpos($route, 'articles/index') === 0),
                    // array('url' => array('articles/index/id/21'), 'label' => Yii::t('app', 'View all Selling your home'), 'active' => strpos($route, 'articles/index') === 0),
                    //   array('url' => array('articles/index/id/20'), 'label' => Yii::t('app', 'View all Teams'), 'active' => strpos($route, 'articles/index') === 0),
                    //   array('url' => array('articles/index/id/22'), 'label' => Yii::t('app', 'View all Testimonials'), 'active' => strpos($route, 'articles/index') === 0),
                    array('url' => array('about_us_service/index'), 'label' => Yii::t('app', 'About Us  Services'), 'active' => strpos($route, 'about_us_service') === 0),
                    array('url' => array('our_services/index'), 'label' => Yii::t('app', 'Our Services'), 'active' => strpos($route, 'our_services') === 0),
                    array('url' => array('faq/index'), 'label' => Yii::t('app', 'FAQ\'s'), 'active' => strpos($route, 'faq') === 0),
                    array('url' => array('our_partners/index'), 'label' => Yii::t('app', 'Partners'), 'active' => strpos($route, 'our_partners') === 0),

                ),
            ),
                 
                     'email' => array(
                'name'      => Yii::t('app', 'Emails'),
                'icon'      => 'glyphicon-envelope',
                'active'    => 'transactional_emails',
                'route'     => array('transactional_emails/index'),
            ), 
            
              'properties' => array(
                'name'      => Yii::t('app', 'Master Data'),
                'icon'      => 'glyphicon-credit-card',
                'active'    => array('employment_type','category','top_areas','subcategory','master_category','amenities','engine_size','community','sub_community','experience_level','countries','city','district','region','nearby_location','city','marital_status','religion','occupation','color','door','bodycondition','mechanicalcondition','fueltype','bodytype'),
                'route'     => null,
                'items'     => array(
             
					array('url' => array('category/index'), 'label' => Yii::t('app', 'Category'), 'active' => strpos($route, 'category') === 0),
					//array('url' => array('subcategory/index'), 'label' => Yii::t('app', 'SubCategory'), 'active' => strpos($route, 'subcategory') === 0),
					array('url' => array('amenities/index'), 'label' => Yii::t('app', 'Amenities'), 'active' => strpos($route, 'amenities') === 0),

					array('url' => array('countries/index'), 'label' => Yii::t('app', 'Country'), 'active' => strpos($route, 'countries') === 0),
					array('url' => array('region/index'), 'label' => Yii::t('app', 'State'), 'active' => strpos($route, 'region') === 0),
					//array('url' => array('city/index'), 'label' => Yii::t('app', 'City'), 'active' => strpos($route, 'city') === 0),
					array('url' => array('district/index'), 'label' => Yii::t('app', 'District'), 'active' => strpos($route, 'district') === 0),
                    array('url' => array('community/index'), 'label' => Yii::t('app', 'Community'), 'active' => strpos($route, 'community') === 0),array('/index'),
                    array('url' => array('sub_community/index'), 'label' => Yii::t('app', 'Sub Community'), 'active' => strpos($route, 'sub_community') === 0),
                    
                    array('url' => array('top_areas/index'), 'label' => Yii::t('app', 'Top Communtiies'), 'active' => strpos($route, 'top_areas') === 0),
                    	 array('url' => array('master_category/index'), 'label' => Yii::t('app', 'Master Category'), 'active' => strpos($route, 'master_category') === 0),
                        array('url' => array('master/index'), 'label' => Yii::t('app', 'Master'), 'active' => strpos($route, 'master') === 0),
                    
                   ),
            ),
           'settings' => array(
                'name'      => Yii::t('app', 'Settings'),
                'icon'      => 'glyphicon-cog',
                'active'    => array('settings','templates','delivery_servers'),
                'route'     => null,
                'items'     => array(
                    array('url' => array('settings/index'), 'label' => Yii::t('app', 'Common'), 'active' => strpos($route, 'settings/index') === 0),
                    array('url' => array('settings/email_templates'), 'label' => Yii::t('app', 'Common email template'), 'active' => strpos($route, 'settings/email_templates') === 0),
                    array('url' => array('templates/index'), 'label' => Yii::t('app', 'Other email templates'), 'active' => strpos($route, 'template/index') === 0),
                    array('url' => array('delivery_servers/index'), 'label' => Yii::t('app', 'Delivery Servers'), 'active' => strpos($route, 'delivery_servers/index') === 0),
                ),
            ),
        
           
            
        );
        
        $menuItems = (array)Yii::app()->hooks->applyFilters('backend_left_navigation_menu_items', $menuItems);
        
        $menu = new CMenu();
        $menu->htmlOptions          = array('class' => 'sidebar-menu');
        $menu->submenuHtmlOptions   = array('class' => 'treeview-menu');
        
        foreach ($menuItems as $key => $data) {
            $_route  = !empty($data['route']) ? $data['route'] : 'javascript:;';
            $active  = false;
            
            if (is_string($data['active']) && strpos($route, $data['active']) === 0) {
                $active = true;
            } elseif (is_array($data['active'])) {
                foreach ($data['active'] as $in) {
                    if (strpos($route, $in) === 0) {
                        $active = true;
                        break;
                    }
                }
            }
            
            $item = array(
                'url'       => $_route, 
                'label'     => '<i class="glyphicon '.$data['icon'].'"></i> <span>'.$data['name'].'</span>' . (!empty($data['items']) ? '<i class="fa fa-angle-left pull-right"></i>' : ''), 
                'active'    => $active
            );
            
            if (!empty($data['items'])) {
                foreach ($data['items'] as $index => $i) {
                    if (isset($i['label'])) {
                        $data['items'][$index]['label'] = '<i class="fa fa-angle-double-right"></i>' . $i['label'];
                    }
                }
                $item['items']       = $data['items'];
                $item['itemOptions'] = array('class' => 'treeview');
            }
            
            $menu->items[] = $item;
        }

        $menu->run();
    }
}
