<?php defined('MW_PATH') || exit('No direct script access allowed');

/**
 * SiteController
 * 
 * Default api application controller
 * 
 * @package MailWizz EMA
 * @author Serban George Cristian <cristian.serban@mailwizz.com> 
 * @link http://www.mailwizz.com/
 * @copyright 2013-2014 MailWizz EMA (http://www.mailwizz.com)
 * @license http://www.mailwizz.com/license/
 * @since 1.0
 */
define('PROJECT_NAME','Rs Dubai Real Estate LLC');
define('KAYE','1');define('IS_API','1');
//define('MY_EMAIL','vineethnjalil@gmail.com');
define('PROJECT_URL','https://www.dsqrealestate.ae');
define('API_URL', 'https://www.dsqrealestate.ae/');
define('API_URL2', 'https://www.dsqrealestate.ae/');
class SiteController extends Controller
{
    
    // access rules for this controller
    public function accessRules()
    {
        return array(
            // allow all users on all actions
            array('allow'),
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     * 
     * By default we don't return any information from this action.
     */
    public function actionIndex()
    {
        
        $this->renderJson();
    }
    public function actionFeatured_listings(){
		$model = new PlaceAnAd();
		$featuredListingCriteria       =   $model->findAds(array(), $count_future = false, $returnCriteria = 1, $calculate = false, $user_id = false);
		$featuredListingCriteria->compare('featured', 'Y');
		$featuredListingCriteria->limit = '8';
		$featuredListingCriteria->order = 't.id desc';
		$featuredListing =  $model->findAll($featuredListingCriteria);
		 
		if (empty($featuredListing)) {
			return $this->renderJson(array(
				'status'    => 'error',
				'error'     => Yii::t('api', 'The property does not exist.')
			), 404);
		}else{
			foreach ($featuredListing as $list) {
				$record = array(
					'ProfileImage'             =>
					API_URL . str_replace('images', 'ads', $list->ProfileImage) ,
				 	'TotalImage'    =>  $list->TotalImage,
					'v_link'    =>  $list->v_link,
					'SaveFave'    =>  $list->SaveFave,
					'BedroomsTitle'    =>  $list->BedroomsTitle1,
					'BathroomsTitle'    =>  $list->BathroomsTitle1,
					'parking'    =>  $list->parking,
					'DetailUrl'    =>  str_replace('api/index.php/','',$list->DetailUrl),
					'AdTitle'    =>  $list->AdTitle,
					'LocationTitleOffering'    =>  $list->CommunityTitle,
                    'currency'    =>  $list->CurrencyTitle,
                    'priceWithCurrncy'    =>  $list->PriceDetail,
					'agent_phone'    =>  $list->agent_phone,
					'agent_email'    =>  $list->agent_email,
                    
					'Whatsaplink'    =>  $list->Whatsaplink,
                    'categoryName'    =>  $list->category_name,

                    'sectionName'    =>  $list->section_name,
                    'builtArea'    =>  $list->builtupAreaString2,
                    'builtupAreaInNum' => (float) $list->builtup_area,
				);
				$data[] = $record;
			}

			return $this->renderJson(
				$data,
				200
			);
		}
	}
    public function actionresidential_listings(){
		$model = new PlaceAnAd();
		$featuredListingCriteria       =   $model->findAds(array(), $count_future = false, $returnCriteria = 1, $calculate = false, $user_id = false);
        //$featuredListingCriteria->compare('featured', 'Y');
        $featuredListingCriteria->compare('t.section_id', '1');
        $featuredListingCriteria->compare('t.listing_type', 'R');
		$featuredListingCriteria->limit = '8';
		$featuredListingCriteria->order = 't.id desc';
		$featuredListing =  $model->findAll($featuredListingCriteria);
		 
		if (empty($featuredListing)) {
			return $this->renderJson(array(
				'status'    => 'error',
				'error'     => Yii::t('api', 'The property does not exist.')
			), 404);
		}else{
			foreach ($featuredListing as $list) {
				$record = array(
					'ProfileImage'             =>
					API_URL . str_replace('images', 'ads', $list->ProfileImage) ,
				 	'TotalImage'    =>  $list->TotalImage,
				 	'categoryName'    =>  $list->category_name,
				 	'sectionName'    =>  $list->section_name,
				 	'builtArea'    =>  $list->builtupAreaString2,
				 	'builtupAreaInNum' => (float) $list->builtup_area,
					'v_link'    =>  $list->v_link,
					'SaveFave'    =>  $list->SaveFave,
					'BedroomsTitle'    =>  $list->BedroomsTitle1,
					'BathroomsTitle'    =>  $list->BathroomsTitle1,
					'parking'    =>  $list->parking,
					'DetailUrl'    =>  str_replace('api/index.php/','',$list->DetailUrl),
					'AdTitle'    =>  $list->AdTitle,
					'LocationTitleOffering'    =>  $list->CommunityTitle,
                    'currency'    =>  $list->CurrencyTitle,
					'priceWithCurrncy'    =>  $list->PriceDetail,
                    'RentalPeriod'    =>  $list->RentalPeriod,
					'agent_phone'    =>  $list->agent_phone,
					'agent_email'    =>  $list->agent_email,
					'Whatsaplink'    =>  $list->Whatsaplink, 
				);
				$data[] = $record;
			}
            $article = Article::model()->findByAttributes(['article_id' => '415', 'status' => 'published']);
            $article_detail = [];
            if ($article) {
                $article_detail = [
                    'heading'   =>  $article->title,
                    'content'   =>  $article->content,
                    'call_to_action'    =>  $article->sub_title,
                    'call_to_action_link'    => "/residential-for-sale",
                ];
            }
			return $this->renderJson(
				['data'=>$data,'content'=> $article_detail],
				200
			);
		}
	}
    public function actioncommercial_listings(){
		$model = new PlaceAnAd();
		$featuredListingCriteria       =   $model->findAds(array(), $count_future = false, $returnCriteria = 1, $calculate = false, $user_id = false);
        //$featuredListingCriteria->compare('featured', 'Y');
        $featuredListingCriteria->compare('t.section_id', '1');
        $featuredListingCriteria->compare('t.listing_type', 'C');
		$featuredListingCriteria->limit = '8';
		$featuredListingCriteria->order = 't.id desc';
		$featuredListing =  $model->findAll($featuredListingCriteria);
		 
		if (empty($featuredListing)) {
			return $this->renderJson(array(
				'status'    => 'error',
				'error'     => Yii::t('api', 'The property does not exist.')
			), 404);
		}else{
			foreach ($featuredListing as $list) {
				$record = array(
					'ProfileImage'             =>
                    API_URL . str_replace('images', 'ads', $list->ProfileImage) ,
				 	'TotalImage'    =>  $list->TotalImage,
				 	'categoryName'    =>  $list->category_name,
				 	'sectionName'    =>  $list->section_name,
				 	'builtArea'    =>  $list->builtupAreaString2,
				 	'builtupAreaInNum' => (float) $list->builtup_area,
					'v_link'    =>  $list->v_link,
					'SaveFave'    =>  $list->SaveFave,
					'BedroomsTitle'    =>  $list->BedroomsTitle1,
					'BathroomsTitle'    =>  $list->BathroomsTitle1,
					'parking'    =>  $list->parking,
					'DetailUrl'    =>  str_replace('api/index.php/','',$list->DetailUrl),
					'AdTitle'    =>  $list->AdTitle,
					'LocationTitleOffering'    =>  $list->CommunityTitle,
                    'currency'    =>  $list->CurrencyTitle,
					'priceWithCurrncy'    =>  $list->PriceDetail,
                    'RentalPeriod'    =>  $list->RentalPeriod,
					'agent_phone'    =>  $list->agent_phone,
					'agent_email'    =>  $list->agent_email,
					'Whatsaplink'    =>  $list->Whatsaplink, 
				);
				$data[] = $record;
			}
            $article = Article::model()->findByAttributes(['article_id' => '416', 'status' => 'published']);
            $article_detail = [];
            if ($article) {
                $article_detail = [
                    'heading'   =>  $article->title,
                    'content'   =>  $article->content,
                    'call_to_action'    =>  $article->sub_title,
                    'call_to_action_link'    =>  "/commercial-for-sale",
                ];
            }
			return $this->renderJson(
				['data'=>$data,'content'=> $article_detail],
				200
			);
		}
	}
	public function actionlistings()
	{
		$request    = Yii::app()->request;
		$perPage    = (int)$request->getQuery('per_page', 12);
		$page       = (int)$request->getQuery('page', 1);
		$keyword       = $request->getQuery('keyword', '');
		$bedrooms       = $request->getQuery('bedrooms', '');
		$maxPerPage = 50;
		$minPerPage = 10;

		if ($perPage < $minPerPage) {
			$perPage = $minPerPage;
		}

		if ($perPage > $maxPerPage) {
			$perPage = $maxPerPage;
		}

		if ($page < 1) {
			$page = 1;
		}

		$data = array(
			'count'         => null,
			'total_pages'   => null,
			'current_page'  => null,
			'next_page'     => null,
			'prev_page'     => null,
			'records'       => array(),
		);
		$formData = [];
		$adModel = new PlaceAnAd;
		$criteria =  $adModel->findAds($formData, false, 1);
		if(!empty($keyword)){
			$criteria->compare('t.ad_title', $keyword,true);
		}
		  
		if(!empty($bedrooms)){
			$criteria->compare('t.bedrooms', $bedrooms,true);
		}
		if(isset($_GET['sectorType']) and !empty(isset($_GET['sectorType']))){
		    switch($_GET['sectorType']){
		     case 'for-sale':
		    case 'sale':
		         $title = 'Properties for Sale';
                $criteria->compare('t.section_id',1);;
            break;
            case 'for-rent':
                 case 'rent':
                $title = 'Properties for Rent';
                $criteria->compare('t.section_id',2);;
            break;
		    }
		    
		}
		else if(isset($_GET['sect'])){
		    switch($_GET['sect']){
		     case '1':
		         $title = 'Properties for Sale';
                
            break;
            case '2':
                $title = 'Properties for Rent';
               
            break;
		    }
			$criteria->compare('t.section_id',$_GET['sect']);
		}
	 
	    if(isset($_GET['propertyType']) and !empty($_GET['propertyType'])){ 
		        $criteria->compare('category0.slug',$_GET['propertyType']); 
		}
		 if(isset($_GET['minPrice']) and !empty($_GET['minPrice'])){ 
		        $criteria->compare('t.price>', preg_replace('/[^\d]/', '', $_GET['minPrice'])); 
		}
		if(isset($_GET['maxPrice']) and !empty($_GET['maxPrice'])){ 
		        $criteria->compare('t.price<', preg_replace('/[^\d]/', '', $_GET['maxPrice'])); 
		} 
			  if(isset($_GET['community']) and !empty($_GET['community'])){ 
			      $searchComunityStr = explode('-and-', $_GET['community']);
			      $orCriteria = new CDbCriteria();
    		      foreach ($searchComunityStr as $term) {
    		        $orCriteria->addSearchCondition('cm.slug', $term, true, 'OR', 'LIKE');
        		    $orCriteria->addSearchCondition('sub.slug', $term, true, 'OR', 'LIKE');
        		    $orCriteria->addSearchCondition('t.property_name', $term, true, 'OR', 'LIKE');
    		        $orCriteria->addSearchCondition('t.ad_title', $term, true, 'OR', 'LIKE');
    		        $orCriteria->addSearchCondition('t.agent_name', $term, true, 'OR', 'LIKE');
    		        $orCriteria->addSearchCondition('t.d_name', $term, true, 'OR', 'LIKE');
    		        $orCriteria->addSearchCondition('t.d_description', $term, true, 'OR', 'LIKE');
    		        $orCriteria->addSearchCondition('t.contractor', $term, true, 'OR', 'LIKE');
    		        $orCriteria->addSearchCondition('t.architect', $term, true, 'OR', 'LIKE');
    		        $orCriteria->addSearchCondition('t.l_architect', $term, true, 'OR', 'LIKE');
    		        $orCriteria->addSearchCondition('t.developer', $term, true, 'OR', 'LIKE');
    		      }
		    $criteria->mergeWith($orCriteria);
		}
		
		
		if(isset($_GET['cityBuildingOrCommunity']) and !empty($_GET['cityBuildingOrCommunity'])){ 
		    $location = explode("-", $_GET['cityBuildingOrCommunity']);
		    if (!empty($location[0]) && !empty($location[1])) {
		        $criteria->compare('t.location_latitude>',$location[0]); 
		        $criteria->compare('t.location_longitude>',$location[1]); 
		    }
		}
	 //minPrice
		if(isset($_GET['listingType'])){
		    switch($_GET['listingType']){
		        case 'commercial':
		            	$criteria->compare('t.listing_type','C');
		        break;
		        case 'residential':
		            	$criteria->compare('t.listing_type','R');
		        break;
		    }
		
		}   
		$count = PlaceAnAd::model()->count($criteria);
	 
		if ($count == 0) {
			return $this->renderJson(array(
				'status'    => 'success',
				'data'      => $data
			), 200);
		}

		$totalPages = ceil($count / $perPage);
         
      
        if(isset($_GET['propertyType']) and !empty($_GET['propertyType'])){
            $category = Category::model()->findByAttributes(['slug' => $_GET['propertyType']]);
            if(!empty($category)){
                $title = str_replace('Properties',$category->CategoryPlural,$title);
            }
        }else if(isset($_GET['listingType'])){
             switch($_GET['listingType']){
            case 'residential':
                $title = 'Residential '.$title;
            break;
            case 'commercial':
                $title = 'Commercial '.$title;
            break;
        }
        }
		$data['title']          = $title;
		$data['count']          = $count;
		$data['current_page']   = $page;
		$data['next_page']      = $page < $totalPages ? $page + 1 : null;
		$data['prev_page']      = $page > 1 ? $page - 1 : null;
		$data['total_pages']    = $totalPages;

		//$criteria->order    = 't.list_id DESC';
		$criteria->limit    = $perPage;
		
		$criteria->offset   = ($page - 1) * $perPage;
 
		$lists = PlaceAnAd::model()->findAll($criteria);

		foreach ($lists as $list) { 

			$record = array(
                'title'             =>  $list->ad_title,
                'ProfileImage'             => API_URL.str_replace('images','ads',$list->ProfileImage),
                'TotalImage'    =>  $list->TotalImage,
                'v_link'           =>  $list->v_link,
                'DetailUrl'           =>  str_replace('api/index.php/','',$list->DetailUrl),
                'BedroomsTitle'           =>  $list->BedroomsTitle,
                'bedrooms'           =>  $list->bedrooms,
                'BathroomsTitle'           =>  $list->BathroomsTitle,
                'bathrooms'           =>  $list->bathrooms,
                'parking'           =>  $list->parking,
                'AdTitle'           =>  $list->AdTitle,
                'LocationTitleOffering'           =>  $list->CommunityTitle,
                'currency'    =>  $list->CurrencyTitle,
                'priceWithCurrncy'    =>  $list->PriceDetail,
                'agent_phone'           =>  $list->agent_phone,
                'url'           	=>  '/property/'.$list->slug,
                'agent_email'           =>  $list->agent_email,
                'Whatsaplink'           =>  $list->Whatsaplink,
                'categoryName'    =>  $list->category_name,
                'sectionName'    =>  $list->section_name,
                'builtArea'    =>  $list->builtupAreaString2,
                'builtupAreaInNum' => (float) $list->builtup_area,
                
			);
			$data['records'][] = $record;
		}

		return $this->renderJson(array(
			'status'    => 'success',
			'data'      => $data
		), 200);
	}
	
	public function actionDetail($slug)
	{
		$criteria =  PlaceAnAd::model()->findAds(array(), false, 1);
		$criteria->condition .= ' and t.slug =:slg ';
        $criteria->join        .=     ' left join {{listing_users}} agnt0 ON agnt0.user_id = t.user_id   ';
        $criteria->select      .=    ',agnt0.email as agent_email, case when agnt0.first_name  is not null then concat(agnt0.first_name," ",agnt0.last_name) else t.agent_name  end as  agent_name,case when agnt0.phone is not null then agnt0.phone else t.agent_phone  end as  agent_phone';
 		$criteria->params[':slg'] = $slug;
		$list = PlaceAnAd::model()->find($criteria);
    
		if (empty($list)) {
			return $this->renderJson(array(
				'status'    => 'error',
				'error'     => Yii::t('api', 'The property does not exist.')
			), 404);
		}
		$team = ListingUsers::model()->findByPk((int)$list->user_id);
		$agent_name =   $team->fullName; 
        $agent_image  =     API_URL .$team->UserImage;
        $brn         = !empty($team->brn_number) ? $team->brn_number : '-';;
        $RERA        =    '-';;
        $designation = !empty($team->designation) ? $team->designation : '-';;
        
		$imagesArray = explode(',', $list->ad_images_g);
		$images	=	[];
		foreach($imagesArray as $image){
			$images[]	=    API_URL.'uploads/ads/' . str_replace('images', 'ads', $image);
		}
		$detail_features =  array_filter($list->detailArray());
		$feature = [] ;
		foreach($detail_features as $k=>$v){
		    $feature[] = ['name' => $list->getAttributeLabel($k), 'value' => $v ];
		}
		$amenities = [] ;
		$all_amenities = $list->all_amentitie(); 
		if(!empty($all_amenities)){
    		foreach($all_amenities as $k=>$v){
    		    $amenities[] = ['name'=>$v->amenities_name,'icon'=> $v->icon_list];
    		}
		}
		
		$record = array(
		 'ad_id'            => $list->primaryKey,
		 'section_id'            => $list->section_id,
    'adTitle'             =>  $list->adTitle,
    'ad_description'      =>  $list->ad_description,
    'ProfileImage'        =>  API_URL . str_replace('images', 'ads', $list->ProfileImage),
    'developer_name'      =>  $list->community_name,  // Assuming developer_name comes from community_name
    'priceWithCurrncy'    =>  $list->priceWithCurrncy,  // Assuming PriceTitleDetail is related to priceWithCurrncy
    'DetailUrl'           =>  '/property/' . $list->DetailUrl,
    'detailUrlAbsolute'   =>   PROJECT_URL.str_replace('api/index.php/', '',$list->DetailUrl),
    'image_list'          =>  $images,  // Assuming $images contains an array of image URLs
    'bedrooms'            =>  $list->bedrooms,
    'bathrooms'           =>  $list->bathrooms,
    'parking'             =>  $list->parking,
    'LocationTitleOffering' =>  $list->LocationTitleOffering,
    'SystemRefNo'         =>  $list->SystemRefNo,
    'agent_phone'         =>  $list->agent_phone,
    'agent_email'         =>  $list->agent_email,
    'agent_language'    =>  $team->langauges_known,
    'Whatsaplink'         =>  $list->Whatsaplink,
    'category'            =>  $list->category_name,
    'builtup_area'        =>  $list->builtup_area,
    'builtupAreaInNum'    => (float) $list->builtup_area,
    'sub_community_name'  =>  $list->sub_community_name,
    'community_name'      =>  $list->community_name,
    'community_slug'      =>  $list->community_slug,
    'sub_community_slug'  =>  $list->sub_community_slug,
    'category_slug'       =>  $list->category_slug,
    'SaveFave'            =>  $list->SaveFave,
    'BedroomsTitle'       =>  $list->BedroomsTitle,
    'BathroomsTitle'      =>  $list->BathroomsTitle,
    'TotalImage'          =>  $list->TotalImage,
    'v_link'              =>  $list->v_link ?? null,  // Optional field
    'tour3dLink'            => $list->Tour_3dlink,
    'communityTitle'        => $list->communityTitle,
    'location_latitude'        => $list->location_latitude,
    'location_longitude'        => $list->location_longitude,
    'features_list'          =>  $feature,
    'amenities'         =>    $amenities,
     'agent_name'      =>  $agent_name,
    'agent_image'      =>  $agent_image,
    'brn'              =>  $brn,
    'RERA'             =>  $RERA, 
    'designation'      =>  $designation,
    'price'          => $list->price,
);

	 

		$data = array('record' => $record);

		return $this->renderJson(array(
			'status'    => 'success',
			'data'      => $data,
		), 200);
	}
	public function actionAwards(){
		$awards =  Awards::model()->awards_list();
		 
		if (empty($awards)) {
			return $this->renderJson(array(
				'status'    => 'error',
				'error'     => Yii::t('api', 'The property does not exist.')
			), 404);
		}else{
			foreach ($awards as $list) {
			    $image = $list['img']; 
			    $title = $list['title'];
				$record = array(
					'img'             =>
                     API_URL2 . str_replace('images', 'ads', $image) ,
				 	'title'    =>  $title, 
				);
				$data[] = $record;
			}

			return $this->renderJson(
				$data,
				200
			);
		}
	}
	public function actionpartners(){
		$our_partners = Our_partners::model()->partners_slider() ;;
		 
		if (empty($our_partners)) {
			return $this->renderJson(array(
				'status'    => 'error',
				'error'     => Yii::t('api', 'The property does not exist.')
			), 404);
		}else{
			foreach ($our_partners as $list) {
			    $image = $list['img']; 
			    $title = $list['title'];
				$record = array(
					'img'             =>
					API_URL . str_replace('images', 'ads', $image) ,
				 	'title'    =>  $title, 
				);
				$data[] = $record;
			}

			return $this->renderJson(
				$data,
				200
			);
		}
	}
	public function actionteams_fetch_info()
    {
        // Distinct sub_title
        $criteriaSub = new CDbCriteria();
        $criteriaSub->select = 'DISTINCT t.sub_title';
        $criteriaSub->compare('t.status', Article::STATUS_PUBLISHED);
        $criteriaSub->compare('t.f_type', 'Te');
        $criteriaSub->order = 't.sub_title ASC';
        $itemsSub = Teams::model()->findAll($criteriaSub);
        $subTitles = [];
        foreach ($itemsSub as $item) {
            if (!empty($item->sub_title)) {
                $subTitles[] = $item->sub_title;
            }
        }

        echo CJSON::encode([
            'sub_titles' => $subTitles
        ]);
        Yii::app()->end();
    }
    
	public function actioncurrency_preference_fetch_info()
    {
        // Distinct sub_title
        $criteriaSub = new CDbCriteria();
        $criteriaSub->select = 't.currency_preference_id, t.value, t.label, t.country, t.date_added';
        $criteriaSub->order = 't.currency_preference_id ASC';
        $itemsList = CurrencyPreference::model()->findAll($criteriaSub);
        $list = [];
        foreach ($itemsList as $item) {
            $list[] = [
                "value" => $item->value,
                "label" => $item->label,
                "dlabel" => ($item->label=="AED")?$item->label:$item->label." ( AED ".$item->value.")",
                "country" => $item->country,
            ];
        }

        echo CJSON::encode([
            'list' => $list
        ]);
        Yii::app()->end();
    }
	public function actionteams_list()
    {
        $request = Yii::app()->request;
    
        $criteria = Teams::model()->search(1);
        $criteria->compare('t.status', Article::STATUS_PUBLISHED);
    
        // Filters
        $name = $request->getQuery('name', '');
        $sub_title = $request->getQuery('sub_title', '');
        $language = $request->getQuery('language', '');
    
        if (!empty($name)) {
            $criteria->compare('t.title', $name, true);
        }
        if (!empty($sub_title)) {
            $criteria->compare('t.sub_title', $sub_title, true);
        }
        if (!empty($language)) {
            $criteria->compare('t.roles', $language, true);
        }
    
        $criteria->order = '-t.priority desc,t.article_id asc';
    
        $teams = Teams::model()->findAll($criteria);
    
        $data = [
            'count' => count($teams),
            'records' => [],
        ];
    
        if (empty($teams)) {
            return $this->renderJson([
                'status' => 'success',
                'data' => $data
            ], 200);
        }
    
        foreach ($teams as $list) {
            $image = $list->ArticleMainImage;
            $title = $list->title;
            $subTitle = $list->sub_title;
            $slug = $list->slug;
            $phone = $list->phone;
            $record = [
                'img' => API_URL2 . str_replace('images', 'ads', $image),
                'title' => $title,
                'subTitle' => $subTitle,
                'slug' => $slug,
                'phone' => $phone,
                'languages' => $list->all_languages(),
            ];
            $data['records'][] = $record;
        }
    
        return $this->renderJson([
            'status' => 'success',
            'data' => $data
        ], 200);
    }
    public function actionteams(){
        $criteria = Teams::model()->search(1);
        $criteria->compare('t.status', Article::STATUS_PUBLISHED);
        $criteria->order = '-t.priority desc,t.article_id asc'; 
        $criteria->limit = Yii::app()->options->get('system.common.team_limit_home',10); 
        $teams = Teams::model()->findAll($criteria);
		 
		if (empty($teams)) {
			return $this->renderJson(array(
				'status'    => 'error',
				'error'     => Yii::t('api', 'The property does not exist.')
			), 404);
		}else{
			foreach ($teams as $list) {
			    $image = $list->ArticleMainImage;; 
			    $title = $list->title;
			    $subTitle = $list->sub_title;
			    $slug = $list->slug;
			    $phone = $list->phone;
				$record = array(
					'img'             =>
                    API_URL2 . str_replace('images', 'ads', $image) ,
				 	'title'    =>  $title,
				 	'subTitle' =>  $subTitle,
				 	'slug' =>  $slug,
				 	'phone' =>  $phone, 
				);
				$data[] = $record;
			}

			return $this->renderJson(
				$data,
				200
			);
		}
	}
	public function actionreviews(){
        $reviews = Reviews::model()->reviews_list(); 
		 
		if (empty($reviews)) {
			return $this->renderJson(array(
				'status'    => 'error',
				'error'     => Yii::t('api', 'The property does not exist.')
			), 404);
		}else{
			foreach ($reviews as $list) {
			    $banner = '/uploads/files/'.$list['banner']; 
			    $title = $list['title']; 
			    $content = $list['content'];  
				$record = array(
					'banner'             =>
                    API_URL2 . str_replace('images', 'ads', $banner) ,
				 	'title'    =>  $title,
				 	'content' =>  $content, 
				);
				$data[] = $record;
			}

			return $this->renderJson(
				$data,
				200
			);
		}
	}	
	
	
    public function actionblogs(){
        $art = new Article();
        $art->category_id =  4;
        $criteria = $art->search(1);
        $criteria->compare('t.status', Article::STATUS_PUBLISHED);
        $criteria->order = 't.article_id DESC';
        $criteria->limit = '9';
        $blog = $art->findAll($criteria);
		 
		if (empty($blog)) {
			return $this->renderJson(array(
				'status'    => 'error',
				'error'     => Yii::t('api', 'The property does not exist.')
			), 404);
		}else{
			foreach ($blog as $list) {
			    $banner = $list->ArticleMainImage; 
			    $title = $list->title; 
			    $content = $list->content; 
			    $slug = $list->slug; 
				$record = array(
					'banner'             =>
					!empty($list->banner) ? API_URL2 . str_replace('images', 'ads', $banner) :$banner ,
				 	'title'    =>  $title,
				 	'content' =>  $content, 
				 	'slug'  => $slug
				);
				$data[] = $record;
			}

			return $this->renderJson(
				$data,
				200
			);
		}
	}	
	public function actionform_offplan_values(){
            $category       =  CHtml::listData(Category::model()->developmentCatogoriescache(),'slug','category_name');
            $developer_list = Developers::model()->cacheclistDeveloper();
            $years = $this->filterAndSortYears(Chtml::listData(Master::model()->listData(5),'master_id','master_name'),date('Y'));
           
            $data['propertyTypes'] = $category; 
            $data['developers']    = $developer_list; 
            $data['years']   =   $years;
            return $this->renderJson(
				$data,
				200
			);
		 
	}
	function filterAndSortYears($array, $current_year) {
      asort($array);

    // Filter out years before the current year but keep the original keys
    $filtered_array = array_filter($array, function($year) use ($current_year) {
        return $year >= $current_year;
    });

    return $filtered_array;
}

	public function actionform_values(){
            $residential = CHtml::listData(Category::model()->category_by_type('R'),'slug','category_name');
            $commercial  = CHtml::listData(Category::model()->category_by_type('C'),'slug','category_name');
            
            $data['propertyTypes']['residential'] = $residential;
            $data['propertyTypes']['commercial']  =  $commercial;
            $data['minPrice']['forsale']    =   $this->salePrice();
            $data['minPrice']['rentprice']  =   $this->rentPrice();
            $data['maxPrice']['forsale']    =   $this->salePrice(); 
            $data['maxPrice']['rentprice']  =   $this->rentPrice();
            $data['minBeds']   =   $this->bedArray();
            return $this->renderJson(
				$data,
				200
			);
		 
	}	
	public function bedArray(){
	   
return  [

    "15" => "Studio",
    "1" => "1",
    "2" => "2",
    "3" => "3",
    "4" => "4",
    "5" => "5",
    "6" => "6",
    "7" => "7+", 
]; 
	}
	public function bathArray(){
	   
return  [
   
    "1" => "1",
    "2" => "2",
    "3" => "3",
    "4" => "4",
    "5" => "5",
    "6" => "6",
    "7" => "7+", 
]; 
	}
    /**
     * This is the action to handle external exceptions.
     */
    public function actionError()
    {
        if ($error = Yii::app()->errorHandler->error) {
            if ($error['code'] === 404) {
                $error['message'] = Yii::t('app', 'Page not found.');
            }
            return $this->renderJson(array(
                'status'    => 'error',
                'error'        => CHtml::encode($error['message']),
            ), $error['code']);
        }
    }
    public function rentPrice(){
        return [
 
  "20000" => "20,000",
  "30000" => "30,000",
  "40000" => "40,000",
  "50000" => "50,000",
  "60000" => "60,000",
  "85000" => "85,000",
  "110000" => "110,000",
  "135000" => "135,000",
  "160000" => "160,000",
  "185000" => "185,000",
  "210000" => "210,000",
  "235000" => "235,000",
  "260000" => "260,000",
  "285000" => "285,000",
  "310000" => "310,000",
  "335000" => "335,000",
  "360000" => "360,000",
  "410000" => "410,000",
  "460000" => "460,000",
  "510000" => "510,000",
  "560000" => "560,000",
  "610000" => "610,000",
  "660000" => "660,000",
  "710000" => "710,000",
  "760000" => "760,000",
  "810000" => "810,000",
  "910000" => "910,000"
 ];

    }
    public function rentPriceNew(){
        return [
            //['id' => 0, 'name' => 'Min Price'],
            ['id' => 20000, 'name' => '20,000 AED/Year'],
            ['id' => 30000, 'name' => '30,000 AED/Year'],
            ['id' => 40000, 'name' => '40,000 AED/Year'],
            ['id' => 50000, 'name' => '50,000 AED/Year'],
            ['id' => 60000, 'name' => '60,000 AED/Year'],
            ['id' => 70000, 'name' => '70,000 AED/Year'],
            ['id' => 80000, 'name' => '80,000 AED/Year'],
            ['id' => 90000, 'name' => '90,000 AED/Year'],
            ['id' => 100000, 'name' => '100,000 AED/Year'],
            ['id' => 110000, 'name' => '110,000 AED/Year'],
            ['id' => 120000, 'name' => '120,000 AED/Year'],
            ['id' => 130000, 'name' => '130,000 AED/Year'],
            ['id' => 140000, 'name' => '140,000 AED/Year'],
            ['id' => 150000, 'name' => '150,000 AED/Year'],
            ['id' => 160000, 'name' => '160,000 AED/Year'],
            ['id' => 170000, 'name' => '170,000 AED/Year'],
            ['id' => 180000, 'name' => '180,000 AED/Year'],
            ['id' => 190000, 'name' => '190,000 AED/Year'],
            ['id' => 200000, 'name' => '200,000 AED/Year'],
            ['id' => 225000, 'name' => '225,000 AED/Year'],
            ['id' => 250000, 'name' => '250,000 AED/Year'],
            ['id' => 275000, 'name' => '275,000 AED/Year'],
            ['id' => 300000, 'name' => '300,000 AED/Year'],
            ['id' => 350000, 'name' => '350,000 AED/Year'],
            ['id' => 400000, 'name' => '400,000 AED/Year'],
            ['id' => 500000, 'name' => '500,000 AED/Year'],
            ['id' => 750000, 'name' => '750,000 AED/Year'],
            ['id' => 1000000, 'name' => '1,000,000+ AED/Year'],
        ];
    }
    public function salePriceNew(){
       return  [
            //['id' => 0, 'name' => 'All Price'],
            //['id' => 300000, 'name' => 'AED 300,000'],
            //['id' => 400000, 'name' => 'AED 400,000'],
            ['id' => 500000, 'name' => 'AED 500,000'],
            ['id' => 600000, 'name' => 'AED 600,000'],
            ['id' => 700000, 'name' => 'AED 700,000'], 
            ['id' => 800000, 'name' => 'AED 800,000'],
            ['id' => 900000, 'name' => 'AED 900,000'],
            ['id' => 1000000, 'name' => 'AED 1,000,000'],
            ['id' => 1100000, 'name' => 'AED 1,100,000'],
            ['id' => 1200000, 'name' => 'AED 1,200,000'],
            ['id' => 1300000, 'name' => 'AED 1,300,000'],
            ['id' => 1400000, 'name' => 'AED 1,400,000'],
            ['id' => 1500000, 'name' => 'AED 1,500,000'],
            ['id' => 1600000, 'name' => 'AED 1,600,000'],
            ['id' => 1700000, 'name' => 'AED 1,700,000'],
            ['id' => 1800000, 'name' => 'AED 1,800,000'],
            ['id' => 1900000, 'name' => 'AED 1,900,000'],
            ['id' => 2000000, 'name' => 'AED 2,000,000'],
            ['id' => 2100000, 'name' => 'AED 2,100,000'],
            ['id' => 2200000, 'name' => 'AED 2,200,000'],
            ['id' => 2300000, 'name' => 'AED 2,300,000'],
            ['id' => 2400000, 'name' => 'AED 2,400,000'],
            ['id' => 2500000, 'name' => 'AED 2,500,000'],
            ['id' => 2600000, 'name' => 'AED 2,600,000'],
            ['id' => 2700000, 'name' => 'AED 2,700,000'],
            ['id' => 2800000, 'name' => 'AED 2,800,000'],
            ['id' => 2900000, 'name' => 'AED 2,900,000'],
            ['id' => 3000000, 'name' => 'AED 3,000,000'],
            ['id' => 3250000, 'name' => 'AED 3,250,000'],
            ['id' => 3500000, 'name' => 'AED 3,500,000'],
            ['id' => 3750000, 'name' => 'AED 3,750,000'],
            ['id' => 4000000, 'name' => 'AED 4,000,000'],
            ['id' => 4250000, 'name' => 'AED 4,250,000'],
            ['id' => 4500000, 'name' => 'AED 4,500,000'],
            ['id' => 5000000, 'name' => 'AED 5,000,000'],
            ['id' => 6000000, 'name' => 'AED 6,000,000'],
            ['id' => 7000000, 'name' => 'AED 7,000,000'],
            ['id' => 8000000, 'name' => 'AED 8,000,000'],
            ['id' => 9000000, 'name' => 'AED 9,000,000'],
            ['id' => 10000000, 'name' => 'AED 10,000,000'],
            ['id' => 12500000, 'name' => 'AED 12,500,000'],
            ['id' => 15000000, 'name' => 'AED 15,000,000'],
            ['id' => 17500000, 'name' => 'AED 17,500,000'],
            ['id' => 20000000, 'name' => 'AED 20,000,000'],
            ['id' => 22500000, 'name' => 'AED 22,500,000'],
            ['id' => 25000000, 'name' => 'AED 25,000,000'],
            ['id' => 27500000, 'name' => 'AED 27,500,000'],
            ['id' => 30000000, 'name' => 'AED 30,000,000'],
            ['id' => 35000000, 'name' => 'AED 35,000,000'],
            ['id' => 40000000, 'name' => 'AED 40,000,000'],
            ['id' => 45000000, 'name' => 'AED 45,000,000'],
            ['id' => 50000000, 'name' => 'AED 50,000,000+'],
        ];
    }
    public function salePrice(){
        return[
        
        "200000" => "200,000",
        "225000" => "225,000",
        "250000" => "250,000",
        "275000" => "275,000",
        "300000" => "300,000",
        "325000" => "325,000",
        "350000" => "350,000",
        "400000" => "400,000",
        "450000" => "450,000",
        "500000" => "500,000",
        "550000" => "550,000",
        "600000" => "600,000",
        "650000" => "650,000",
        "700000" => "700,000",
        "750000" => "750,000",
        "800000" => "800,000",
        "900000" => "900,000",
        "1000000" => "1,000,000",
        "2000000" => "2,000,000",
        "3000000" => "3,000,000",
        "4000000" => "4,000,000",
        "5000000" => "5,000,000",
        "6000000" => "6,000,000",
        "7000000" => "7,000,000",
        "8000000" => "8,000,000",
        "9000000" => "9,000,000"
 ];

    }
    public function actionSend_enquiry()
	{
	       
		// Create an instance of the contact form model
		$model = new SendEnquiry();
       
		// Collect data from the request body
		if (isset($_REQUEST)) {
			$model->attributes = $_REQUEST;
            $model->phone = $_REQUEST['ph'];
            $model->meassage = $_REQUEST['message']; 
			// Validate the model
			if ($model->save()) {
				// Perform the action (e.g., send an email or save data)
				// Here we can assume that the form is valid and we want to send a response
				Yii::app()->user->setFlash('contact', 'Thank you for your message.');
				// Send response to the React frontend
				echo CJSON::encode(array(
					'status' => 'success',
					'message' => Yii::t('app','Your message was successfully sent to the {p} Support Team. One of our representative will contact you soon.'  ,array('{p}'=>Yii::app()->options->get('system.common.site_name'))),
				));
			} else {
				// If validation fails
				$ar = 	$model->errors;
				if(isset($ar['phone'])){
				    $ar['ph'] = $ar['phone'];
				}
				if(isset($ar['meassage'])){
				    $ar['message'] = $ar['meassage'];
				}
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'There was an error with your form submission.',
					'errors' => $ar,
				));
			}
		}
	}
	public function actionOffplanlistings()
    {
        
        $request = Yii::app()->request;
        $perPage = (int)$request->getQuery('per_page', 24);
        $page = (int)$request->getQuery('page', 1);
        $keyword = $request->getQuery('keyword', '');
        $bedrooms = $request->getQuery('bedrooms', '');
        $maxPerPage = 50;
        $minPerPage = 10;

        if ($perPage < $minPerPage) {
            $perPage = $minPerPage;
        }

        if ($perPage > $maxPerPage) {
            $perPage = $maxPerPage;
        }

        if ($page < 1) {
            $page = 1;
        }

        $data = array(
            'count' => null,
            'total_pages' => null,
            'current_page' => null,
            'next_page' => null,
            'prev_page' => null,
            'records' => array(),
        );
        $formData = [];
        $formData['_sec_id'] = 3;
        $adModel = new PlaceAnAd;
      
        $criteria = $adModel->findAds($formData, false, 1);
        if($criteria->order== 't.featured="Y" desc ,t.id desc'){
        $criteria->order = 't.id desc';
        }
        $criteria->order = 't.id desc';
        if (!empty($keyword)) {
            $criteria->compare('t.ad_title', $keyword, true);
        }

        $title = 'Off-Plan Properties for Sale';
      
        if (isset($_GET['propertyType']) and !empty($_GET['propertyType'])) {
            $pp_type =  Category::model()->findByAttributes(array('slug'=>$_GET['propertyType']));
             
			   if($pp_type){
				$criteria->join  .= ' left join {{ad_property_types}} apt ON apt.ad_id = t.id and apt.type_id  =    :p_type    ';
				$criteria->params[':p_type'] = $pp_type->category_id;
				$criteria->condition  .=  ' and apt.ad_id is NOT NULL ';
			}
        }
         
         
        // if (isset($_GET['community']) and !empty($_GET['community'])) {
        //     $criteria->compare('cm.slug', $_GET['community'],true);
        // }
//         if(isset($_GET['propertyType']) and !empty($_GET['propertyType'])){ 
// 		        $criteria->compare('category0.slug',$_GET['propertyType']); 
// 		}
        if (isset($_GET['year']) and !empty($_GET['year'])) {
            $criteria->compare('t.c1', $_GET['year']);
        }
        if(isset($_GET['developer']) and !empty($_GET['developer'])){
            $developer = Developers::model()->findByAttributes(['slug' => $_GET['developer']]);
            if( $developer){ 
                $criteria->compare('t.developer_id', $developer->developer_id); 
            }
        }
        if (isset($_GET['minPrice']) and !empty($_GET['minPrice'])) {
            $criteria->compare('t.price>', preg_replace('/[^\d]/', '', $_GET['minPrice']));
        }
        if (isset($_GET['maxPrice']) and !empty($_GET['maxPrice'])) {
            $criteria->compare('t.price<', preg_replace('/[^\d]/', '', $_GET['maxPrice']));
        } 
       
		if(isset($_GET['community']) and !empty($_GET['community'])){ 
           
            $criteria->join  .= ' left join {{developers}} developers ON developers.developer_id = t.developer_id    ';

            $searchComunityStr = explode('-and-', $_GET['community']);
	      $orCriteria = new CDbCriteria();
	      foreach ($searchComunityStr as $term) {
	        $orCriteria->addSearchCondition('cm.slug', $term, true, 'OR', 'LIKE');
		    $orCriteria->addSearchCondition('sub.slug', $term, true, 'OR', 'LIKE');
		    $orCriteria->addSearchCondition('t.property_name', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.ad_title', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.agent_name', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.d_name', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.d_description', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.contractor', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.architect', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.l_architect', $term, true, 'OR', 'LIKE');
            $orCriteria->addCondition("developers.slug LIKE :slug_term", 'OR');
              
	      }
            $orCriteria->params[':slug_term'] = $term . '%';
            $criteria->mergeWith($orCriteria);
		}
          

        $count = PlaceAnAd::model()->count($criteria);

        if ($count == 0) {
            return $this->renderJson(array(
                'status' => 'success',
                'data' => $data,
                'criteria' => $criteria
            ), 200);
        }

        $totalPages = ceil($count / $perPage);



        $data['title'] = $title;
        $data['count'] = $count;
        $data['current_page'] = $page;
        $data['next_page'] = $page < $totalPages ? $page + 1 : null;
        $data['prev_page'] = $page > 1 ? $page - 1 : null;
        $data['total_pages'] = $totalPages;

        //$criteria->order = 't.list_id DESC';
        $criteria->limit = $perPage;

        $criteria->offset = ($page - 1) * $perPage;

        $lists = PlaceAnAd::model()->findAll($criteria);

        foreach ($lists as $list) {
            $record = array( 
                'id' => $list->primaryKey,
                'adTitle' => $list->adTitle,
                'CommunityTitle' => $list->CommunityTitle,
                'developer_name' => $list->developer_name,
                'bgImage' => API_URL .$list->bgImage,
                'p_o_r' => $list->p_o_r,
                'PriceTitleDetail' => $list->price == '0.00' ? 'Ask for Price' :$list->PriceTitleDetail,
                'image' => API_URL .   $list->OffplanImage ,
                'AtttributePropertyDetails' => $list->AtttributePropertyDetails, 
                'DetailUrl' => str_replace('api/index.php/', '', $list->DetailUrl), 
                'price' => $list->price=='0.00' ? 0 :   $list->price,
            );
            $data['records'][] = $record;
        }

        return $this->renderJson(array(
            'status' => 'success',
            'data' => $data,
            'criteria' => $criteria
        ), 200);
    }
	public function actionProperties()
    {
        define('ALL_PROPERTIES', 1);
        $request = Yii::app()->request;
        $perPage = (int)$request->getQuery('per_page', 24);
        $page = (int)$request->getQuery('page', 1);
        $keyword = $request->getQuery('keyword', '');
        $bedrooms = $request->getQuery('bedrooms', '');
        $maxPerPage = 50;
        $minPerPage = 10;

        if ($perPage < $minPerPage) {
            $perPage = $minPerPage;
        }

        if ($perPage > $maxPerPage) {
            $perPage = $maxPerPage;
        }

        if ($page < 1) {
            $page = 1;
        }

        $data = array(
            'count' => null,
            'total_pages' => null,
            'current_page' => null,
            'next_page' => null,
            'prev_page' => null,
            'records' => array(),
        );
        $formData = [];
        $formData['_sec_id'] = '';
        $adModel = new PlaceAnAd;
      
        $criteria = $adModel->findAds($formData, false, 1);
        if($criteria->order== 't.featured="Y" desc ,t.id desc'){
        $criteria->order = 't.id desc';
        }
        $criteria->order = 't.id desc';
        if (!empty($keyword)) {
            $criteria->compare('t.ad_title', $keyword, true);
        }

        $title = 'Off-Plan Properties for Sale';
      
        if (isset($_GET['purpose']) and !empty($_GET['purpose'])) {
                switch($_GET['purpose']){
                    case 'Residential':
                        $criteria->compare('t.section_id',1);
                        $criteria->compare('t.listing_type', 'R');
                        $title = 'Properties for sale';
                        break;
                    case 'Commercial':
                        $criteria->compare('t.section_id',1);
                        $criteria->compare('t.listing_type', 'C');
                        $title = 'Commercial properties for sale';
                        break;
                    case 'RentResidential':
                        $criteria->compare('t.section_id',2);
                        $criteria->compare('t.listing_type', 'R');
                        $title = 'Properties to rent';
                        break;
                    case 'RentCommercial':
                        $criteria->compare('t.section_id',2);
                        $criteria->compare('t.listing_type', 'C');
                        $title = 'Commercial properties to rent';
                        break;
                    case 'Offplan':
                        $criteria->compare('t.section_id',3); 
                        $title = 'Off Plan properties';
                        break;
                    case 'Buy':
                        $title = 'Properties for sale';
                        $criteria->compare('t.section_id',1);
                        break;
                    case 'Rent':
                        $criteria->compare('t.section_id', 2);
                        $title = 'Properties to rent';
                        break;
                    }
				 
			 
        }
         
        if (isset($_GET['propertyType']) and !empty($_GET['propertyType'])) {
            
            $pp_type =  Category::model()->findByAttributes(array('slug'=>$_GET['propertyType'], 'isTrash' => '0', 'status' => 'A'));
  
			   if($pp_type){
				$criteria->join  .= ' left join {{ad_property_types}} apt ON apt.ad_id = t.id and apt.type_id  =    :p_type    ';
				$criteria->params[':p_type'] = $pp_type->category_id;
				$criteria->condition  .=  ' and (t.category_id = :p_type or   apt.ad_id is NOT NULL) ';
			}
        }
        $criteria->distinct = 't.id';
        if(isset($_GET['beds']) and !empty($_GET['beds'])){
            if(isset($_GET['purpose']) and $_GET['purpose'] != 'Offplan'){
                $criteria = $this->bedMultipleCondition($criteria);
            } else{
                $criteria = $this->bedMultipleCondition($criteria,$o_plan =1);
            } 
        }
        if(isset($_GET['extras']) and !empty($_GET['extras'])){            
            $criteria = $this->amenitiesSearch($criteria);  
                   
        }
        if (isset($_GET['baths']) and !empty($_GET['baths'])) {
            $criteria = $this->bathMultipleCondition($criteria); 
        }
        // if (isset($_GET['community']) and !empty($_GET['community'])) {
        //     $criteria->compare('cm.slug', $_GET['community'],true);
        // }
        //         if(isset($_GET['propertyType']) and !empty($_GET['propertyType'])){ 
        // 		        $criteria->compare('category0.slug',$_GET['propertyType']); 
        // 		}
        if (isset($_GET['year']) and !empty($_GET['year'])) {
            $criteria->compare('t.c1', $_GET['year']);
        }
        if(isset($_GET['developer']) and !empty($_GET['developer'])){
            $search = $_GET['developer'];  
            $cleanSearch = strtolower(trim(preg_replace('/[\d-]/', '', $search)));
            $criteriaSearch  = new CDbCriteria();
            $criteriaSearch->addCondition("REPLACE(REGEXP_REPLACE(slug, '[0-9]', ''), '-', '') LIKE :search");
            $criteriaSearch->params[':search'] = '%' . $cleanSearch . '%';
            $criteriaSearch->select = 't.developer_id';
            $developers = CHtml::listData(Developers::model()->findAll($criteriaSearch),'developer_id','developer_id');
            if(!empty($developers)){ 
                $criteria->addInCondition('t.developer_id',  $developers);
            }; 

             
        }
        if (isset($_GET['minPrice']) and !empty($_GET['minPrice'])) {
            $criteria->compare('t.price>', preg_replace('/[^\d]/', '', $_GET['minPrice']));
        }
        if (isset($_GET['maxPrice']) and !empty($_GET['maxPrice'])) {
            $criteria->compare('t.price<', preg_replace('/[^\d]/', '', $_GET['maxPrice']));
        } 
       
		if(isset($_GET['area']) and !empty($_GET['area'])){ 
           
            $criteria->join  .= ' left join {{developers}} developers ON developers.developer_id = t.developer_id    ';

            $searchComunityStr = explode('-and-', $_GET['area']);
	      $orCriteria = new CDbCriteria();
	      foreach ($searchComunityStr as $term) {
	        $orCriteria->addSearchCondition('cm.slug', $term, true, 'OR', 'LIKE');
		    $orCriteria->addSearchCondition('sub.slug', $term, true, 'OR', 'LIKE');
		    $orCriteria->addSearchCondition('t.property_name', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.ad_title', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.agent_name', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.d_name', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.d_description', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.contractor', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.architect', $term, true, 'OR', 'LIKE');
	        $orCriteria->addSearchCondition('t.l_architect', $term, true, 'OR', 'LIKE');
            $orCriteria->addCondition("developers.slug LIKE :slug_term", 'OR');
              
	      }
            $orCriteria->params[':slug_term'] = $term . '%';
            $criteria->mergeWith($orCriteria);
		}
          
        if(isset($_GET['sort'])   ){
            switch($_GET['sort']){
                case 'highest_price':
                    $criteria->order = 'COALESCE(t.price,0) desc';
                break;
                case 'lowest_price':
                    $criteria->order = 'IF(t.price = 0, 1, 0), t.price ASC';
                break;
                case 'most_bedrooms':
                    $criteria->order = "IF(t.bedrooms = 0, -1, IF(t.bedrooms = 14, 13.5, t.bedrooms)) DESC";
                break;
                case 'least_bedrooms':
                    $criteria->order = "IF(t.bedrooms = 0, -1, IF(t.bedrooms = 14, 13.5, t.bedrooms)) ASC";
                break;
            }
        }
              
        $count = PlaceAnAd::model()->count($criteria);

        if ($count == 0) {
            return $this->renderJson(array(
                'status' => 'success',
                'data' => $data,
                'criteria' => $criteria
            ), 200);
        }

        $totalPages = ceil($count / $perPage);

       

        $data['title'] = $title;
        $data['count'] = $count;
        $data['current_page'] = $page;
        $data['next_page'] = $page < $totalPages ? $page + 1 : null;
        $data['prev_page'] = $page > 1 ? $page - 1 : null;
        $data['total_pages'] = $totalPages;

        //$criteria->order = 't.list_id DESC';
        $criteria->limit = $perPage;

        $criteria->offset = ($page - 1) * $perPage;
       
        $lists = PlaceAnAd::model()->findAll($criteria);


        foreach ($lists as $list) {
            $dName =  $list->developer_name;
            if(!empty($list->developer_id)){
                $dName = $list->developerName; 
            }
            $year = '';
            $status =  (in_array($list->section_id ,['1','2']) || $list->construction_status == 'R') ? 'ready' : 'offplan';
            if ($list->section_id == '3') {
                $typesDatails = AdPropertyTypes::model()->findByAttributes(['ad_id' => (int) $list->primaryKey]);
                if (!empty($typesDatails)) {
                    $cat =  Category::model()->findByPk($typesDatails->type_id);
                    if (!empty($cat)) {
                        $list->category_name = $cat->category_name;
                    }
                    $list->builtup_area  = $typesDatails->size;
                    if (!empty($typesDatails->bed)) {
                        $list->bedrooms  = $typesDatails->bed;
                    }
                }
                if (!empty($list->c1)) {
                    $year = Master::model()->findByPk($list->c1)->master_name;
                }
            }
            $developer_logo = $list->bgImage;
            $record = array(
                'title'             =>  $list->ad_title,
                'ProfileImage'             => $list->section_id == '3' ?   API_URL . $list->OffplanImage : API_URL . str_replace('images', 'ads', $list->ProfileImage),
                'TotalImage'    =>  $list->TotalImage,
                'v_link'           =>  $list->v_link,
                'DetailUrl'           =>  str_replace('api/index.php/', '', $list->DetailUrl),
                'BedroomsTitle'           =>  $list->BedroomsTitle,
                'bedrooms'           =>  $list->bedrooms,
                'BathroomsTitle'           =>  $list->BathroomsTitle,
                'bathrooms'           =>  $list->bathrooms,
                'parking'           =>  $list->parking,
                'AdTitle'           =>  $list->AdTitle,
                'LocationTitleOffering'           =>  $list->CommunityTitle,
                'currency'    =>  $list->CurrencyTitle,
                'priceWithCurrncy'    =>  $list->price == '0.00' ? 'Ask for Price' : $list->PriceDetail,
                'agent_phone'           =>  $list->agent_phone,
                'url'               =>  '/property/' . $list->slug,
                'agent_email'           =>  $list->agent_email,
                'Whatsaplink'           =>  $list->Whatsaplink,
                'categoryName'    =>  $list->category_name,
                'sectionName'    =>  $list->section_name,
                'builtArea'    =>  $list->builtupAreaString2,
                'builtupAreaInNum' => (float) $list->builtup_area,
                'developerName' =>   $dName,
                'status'        => $status,
                'completionYear'  => $year,
                'developerLogo' => !empty($developer_logo) ?  API_URL . $developer_logo : ''

            );
            $data['records'][] = $record;
        }
        //print_r($data['title']);exit; 
        //exit;
        return $this->renderJson(array(
            'status' => 'success',
            'data' => $data,
             
        ), 200);
    }
    public function actionoffplan_detail($slug)
	{
		$criteria =  PlaceAnAd::model()->findAds(array('_sec_id'=>3), false, 1);
		$criteria->condition .= ' and t.slug =:slg '; 
		$modelCritera->join        .=     ' left join {{user_id}} agnt0 ON agnt0.user_id = t.user_id   ';
		$modelCritera->select      .=    ',case when agnt0.first_name  is not null then agnt0.first_name else t.agent_name  end as  agent_name,case when agnt0.phone is not null then agnt0.phone else t.agent_phone  end as  agent_phone';
 		$criteria->params[':slg'] = $slug;
		$list = PlaceAnAd::model()->find($criteria);
 
		if (empty($list)) {
			return $this->renderJson(array(
				'status'    => 'error',
				'error'     => Yii::t('api', 'The property does not exist.')
			), 404);
		}

		$imagesArray = explode(',', $list->ad_images_g);
		$images	=	[];
		foreach($imagesArray as $image){
			$images[]	=	API_URL.'uploads/ads/' . str_replace('images', 'ads', $image);
		}
		
		$art = new Article();
        $art->category_id =  24;
        $criteria = $art->search(1);
        $criteria->compare('t.status', Article::STATUS_PUBLISHED);
        $criteria->order = 't.article_id DESC';
        $criteria->select = 't.slug,title,sub_title,banner';
        $criteria->limit = '9';
        $guides = []; //$art->findAll($criteria);

        $type_is = $list->all_property_types_details();
        
        $type_is_overview = $list->payment_plan; 
         
        $floor = $list->adFloorPlans;


        $names = [];
        $floor_list = [];
        $typesDatails = AdPropertyTypes::model()->findAllByAttributes(['ad_id' => (int) $list->primaryKey]);
        if (!empty($typesDatails)) {
            foreach ($typesDatails as $k => $v) {
                $types_ids[$v->type_id] = $v->type_id;
            }
            $names = CHtml::listData(
                Category::model()->findAllByAttributes(['category_id' => array_keys($types_ids)]),
                'category_id',
                'category_name'
            );
        }

      
        if(!empty($floor)){
            $floor_data = CHtml::listData($floor,'floor_id','floor_file');
            foreach($floor_data as $flor_items){
                $item1 = explode('|||',$flor_items);
                $floor_list[] = ['floor_file'=> API_URL .'uploads/floor_plan/' .$item1[1],'floor_title'=>$item1[0]];
            } 
        }
        if(!empty($list->api_id) and !empty($typesDatails)){
            foreach ($typesDatails as $k => $v) {

                $title11 = !empty($v->title) ?  $v->title : (((int) $v->size).' sqft');
                $floor_list[] = ['floor_file' => API_URL . 'uploads/ads/' . $v->image , 'floor_title' => $title11];
            }
        }
 


        $faq = AdFaq::model()->findAllByAttributes(array('ad_id'=>$list->id));
        $faq_list = []; 
        if(!empty($faq)){
            foreach($faq as $k=>$v){
                $faq_list[] = ['title'=>$v->title, 'file'=>$v->file]; 
            }
        } 
        $similar_properties = $list->getSimilarProperties(6);
        $similar = [];
        foreach($similar_properties as $k=>$v){
            
            $similar[] = [
                'bg_img'  => API_URL .'uploads/ads/' .$v->bg_img,
                'ad_title' =>$v->ad_title,
                'community_name' => $v->community_name,
                'PriceTitleDetail'  => $v->PriceTitleDetail,
                'mobile_number' =>$v->mobile_number,
                'ReferenceNumberTitle' =>$v->ReferenceNumberTitle,
                 'detailUrlAbsolute' =>   PROJECT_URL.str_replace('api/index.php/', '',$v->DetailUrl),
                 'detailUrl' => str_replace('api/index.php/', '', $v->DetailUrl),
                 'location_latitude' =>$v->location_latitude,
                 'location_longitude' =>$v->location_longitude, 
                 'price'=>$v->price
            ];
     
        } 
       
        //$toparea = 	 TopAreas::model()->toparea();
        //$new_projects  = $list->getLatestProhectsFromCache(); 
        $imagesArray = $list->all_images();
        $images =   [];	 
		foreach($imagesArray as $image){
			$images[]	=	['image_name' => API_URL .'uploads/images/' .  $image->image_name ];
		}
		$detail_features =  array_filter($list->detailArray());
		$feature = [] ;
		foreach($detail_features as $k=>$v){
		    $feature[] = ['name' => $list->getAttributeLabel($k), 'value' => $v ];
		}
		$amenities = [] ;
		$all_amenities = $list->all_amentitie(); 
		if(!empty($all_amenities)){
    		foreach($all_amenities as $k=>$v){
    		    $amenities[] = ['amenitiesName'=>$v->amenities_name,'iconList'=> $v->icon_list];
    		}
		}
		$header_image    = $list->bg_img;
        $dlogo           = $list->d_logo;
        $strating_price  = $list->PriceTitleDetail;
        $handover  = '';
        if (!empty($list->c1)) {
            $masterC =  Master::model()->findByPk($list->c1);
            $handover  = $masterC->master_name;
        }
      
       
        $bg_image = !empty($header_image) ? API_URL .'uploads/ads/' . $header_image : '';
        $bg_image_mobile = !empty($list->bg_img_mobile) ? API_URL .'uploads/ads/' . $list->bg_img_mobile : '';
        $logo   =    API_URL .'uploads/ads/' . $dlogo;
!       
        $agent_logo = !empty($list->agent_logo) ?  API_URL .'uploads/ads/' . $list->agent_logo : API_URL2.'/assets/img/user.png'; 
        $agent_name =   $list->agent_name;
        $mobile_number=   $list->mobile_number;
        $ReferenceNumberTitle=   $list->ReferenceNumberTitle;
        $detailUrlAbsolute=   $list->detailUrl;
        $payment_plan_title = '-';
        $payment_plan_list = [];
        if (!empty($type_is_overview)) {
            $type_is_overview = unserialize($type_is_overview);
            foreach($type_is_overview as $p){
                if(isset($p['percentage'])){
                    for($i=0; $i<  sizeOf($p['percentage']);$i++){
                        $payment_plan_list[] = ['percentage'=>$p['percentage'][$i],'description'=>$p['description'][$i]];
                    
                    }
                }
            } 
            if (empty($list->pay_plan)) {
                $findFirstPaymentPlan = array_values($type_is_overview);
        
                $payment_plan_title = '';
                foreach ($findFirstPaymentPlan[0]['percentage'] as $planDet) {
                    $payment_plan_title .= $planDet . '/';
                }
                if (!empty($payment_plan_title)) {
                    $payment_plan_title = rtrim($payment_plan_title, '/');
                }
            } else {
                $payment_plan_title = $list->pay_plan;
            }
        }
        $dev_name = empty($list->developer_name) ? '' : $list->developer_name;
        if(!empty($list->developer_id)){
            $dev  = Developers::model()->findByPk($list->developer_id);
            $dev_name  =  $dev->developer_name;
            
        }
		$record = array(
            'id' =>$list->primaryKey,
            'ad_description' => $list->adDescription,
            'DetailUrl' => str_replace('api/index.php/', '', $list->DetailUrl),
            'ProfileImage'  =>$bg_image,
            'price'=>$list->price,
            'ad_id' =>$list->primaryKey,
            'bgImage' =>$bg_image,
            'bgImageMobile' => $bg_image_mobile,
            'adTitle' => $list->adTitle,
            'bImage' => !empty($list->b_image) ?  API_URL .'uploads/ads/' .$list->b_image :   '', 
            
            'agent_logo' =>  $agent_logo,
            'property_names'         => $names, 
            'agent_name' =>   $agent_name,
            'mobile_number' =>   $mobile_number,
            'ReferenceNumberTitle' =>   $ReferenceNumberTitle,
            'detailUrlAbsolute' =>   PROJECT_URL.str_replace('api/index.php/', '',$list->DetailUrl),
            
             'logo' =>  $logo, 
            'caption' =>   empty($list->caption) ? '' : $list->caption ,
            'startingPrice' =>   $list->PriceTitleDetail,
            'paymentPlanTitle' =>   $payment_plan_title,
            'handover' =>   $handover, 
            
            'pNumbers' => empty($list->p_numbers) ? '' : $list->p_numbers,
            'rera' => empty($list->rera) ? '' : $list->rera,
            'ded' => empty($list->ded) ? '' : $list->ded,
            'brn' => empty($list->brn) ? '' :  $list->brn,
            'qr' => !empty($list->qr) ? API_URL .'uploads/files/'.$list->qr :'' ,
       
          'developerName' =>  $dev_name,
          'locationLatitude' => $list->location_latitude,
          'locationLongitude' => $list->location_longitude,
          'communityTitle' => $list->community_name,
          'shortDescription' => $list->getShortDescription(900),
          'adDescription' => $list->ad_description,
          'dRight' => !empty($list->d_right) ? API_URL .'uploads/ads/'.$list->d_right : API_URL . 'uploads/ads/' . $list->bg_img, 
            'paymentPlans' =>  $payment_plan_list, 
            'features_list'          =>  $feature,
            'amenities'         =>    $amenities,
            'images'   =>  $images,
            'floorPlans' => $floor_list,
            'c_description'=>empty($list->c_description) ? '' : $list->c_description ,
            'faq' => $faq_list, 
            'similarProperties'=>$similar,
            'c_img'     =>  !empty($list->c_img) ? API_URL .'uploads/ads/'.$list->c_img :'' , 
        ); 
		$data = array('record' => $record);

		return $this->renderJson(array(
			'status'    => 'success',
			'data'      => $data,
		), 200);
	}
	public function actionBlogs_list()
    {
        
        
        $request = Yii::app()->request;
        $perPage = (int)$request->getQuery('per_page', 12);
        $page = (int)$request->getQuery('page', 1); 
        $maxPerPage = 50;
        $minPerPage = 10;

        if ($perPage < $minPerPage) {
            $perPage = $minPerPage;
        }

        if ($perPage > $maxPerPage) {
            $perPage = $maxPerPage;
        }

        if ($page < 1) {
            $page = 1;
        }

        $data = array(
            'count' => null,
            'total_pages' => null,
            'current_page' => null,
            'next_page' => null,
            'prev_page' => null,
            'records' => array(),
        );
        $slug = 'news-media';
        $category = ArticleCategory::model()->findByAttributes($slug);
        $banner = Banner::model()->getBannerById(24); 
        $banner_imge = !empty($banner) ? Yii::App()->apps->getBaseUrl('uploads/banner/'.$banner->image) : Yii::App()->apps->getBaseUrl('images/contact-us.jpg');
        
        $criteria = new CDbCriteria();
        $criteria->compare('t.status', Article::STATUS_PUBLISHED);
        if (isset($_GET['keyword']) and !empty($_GET['keyword'])) {
            $criteria->compare('t.title', $_GET['keyword'],true);
        }
        $criteria->with = array(
            'activeCategories' => array(
                'select'    => 'activeCategories.category_id',
                'together'  => true,
                'joinType'  => 'INNER JOIN',
                'condition' => 'activeCategories.category_id = :cid',
                'params'    => array(':cid' => $category->category_id),
            )
        ); 
        $criteria->order = '-t.priority desc,t.article_id desc';

        $title =  $category->name;
       
          

        $count = Article::model()->count($criteria);

        if ($count == 0) {
            return $this->renderJson(array(
                'status' => 'success',
                'data' => $data
            ), 200);
        }

        $totalPages = ceil($count / $perPage);


        $article1 = Article::model()->findByAttributes(['article_id' => '424', 'status' => 'published']);


        $data['title'] =  $article1->page_title;
        $data['sub_title'] =  $article1->sub_title;
         
        $data['count'] = $count;
        $data['current_page'] = $page;
        $data['next_page'] = $page < $totalPages ? $page + 1 : null;
        $data['prev_page'] = $page > 1 ? $page - 1 : null;
        $data['total_pages'] = $totalPages;
        $data['banner_image'] =     API_URL.'uploads/files/'. $article1->banner ;
        //$criteria->order = 't.list_id DESC';
        $criteria->limit = $perPage;

        $criteria->offset = ($page - 1) * $perPage;

        $lists = Article::model()->findAll($criteria);
        
       
        foreach ($lists as $list) {
            $b_image = !empty($list->banner) ? API_URL2.'/uploads/files/' .   $list->banner  :$list->ArticleMainImage; 
            $url = Yii::app()->createUrl('articles/view', array('slug' => $list->slug));
            $record = array( 
                'id' => $list->primaryKey,
                'image' => 	 $b_image,
				 
                'DetailUrl' => str_replace('api/index.php/', '', $url), 
                'Title' => $list->title,
                'slug' => $list->slug,
                'ShortDescription' => $list->getExcerpt(80), 

            );
            $data['records'][] = $record;
        }

        return $this->renderJson(array(
            'status' => 'success',
            'data' => $data
        ), 200);
    }
    public function actionGuides_list()
    {
        
        
        $request = Yii::app()->request;
        $perPage = (int)$request->getQuery('per_page', 12);
        $page = (int)$request->getQuery('page', 1); 
        $maxPerPage = 50;
        $minPerPage = 10;

        if ($perPage < $minPerPage) {
            $perPage = $minPerPage;
        }

        if ($perPage > $maxPerPage) {
            $perPage = $maxPerPage;
        }

        if ($page < 1) {
            $page = 1;
        }

        $data = array(
            'count' => null,
            'total_pages' => null,
            'current_page' => null,
            'next_page' => null,
            'prev_page' => null,
            'records' => array(),
        );
        $slug = 'guides';
        $category = ArticleCategory::model()->findByAttributes(array("slug"=>$slug));
        
        $criteria_subcategory = new CDbCriteria();
        $criteria_subcategory->compare('t.status', ArticleCategory::STATUS_ACTIVE);
        $criteria_subcategory->compare('t.parent_id', $category->category_id);
        $subCategory = ArticleCategory::model()->findAll($criteria_subcategory);
        
        $subCategoryIds = array_map(function($cat) {
            return $cat->category_id;
        }, $subCategory);
        
        $placeholders = [];
        $params = [];
        foreach ($subCategoryIds as $index => $id) {
            $key = ':cid' . $index;
            $placeholders[] = $key;
            $params[$key] = $id;
        }
        
        $banner = Banner::model()->getBannerById(24); 
        $banner_imge = !empty($banner) ? Yii::App()->apps->getBaseUrl('uploads/banner/'.$banner->image) : Yii::App()->apps->getBaseUrl('images/contact-us.jpg');
        
        $criteria = new CDbCriteria();
        $criteria->compare('t.status', Article::STATUS_PUBLISHED);
        if (isset($_GET['keyword']) and !empty($_GET['keyword'])) {
            $criteria->compare('t.title', $_GET['keyword'],true);
        }
        $criteria->with = array(
            'activeCategories' => array(
                'select'    => 'activeCategories.category_id',
                'together'  => true,
                'joinType'  => 'INNER JOIN',
                'condition' => 'activeCategories.category_id = :cid',
                'params'    => array(':cid' => $category->category_id),
                'condition' => 'activeCategories.category_id IN (' . implode(',', $placeholders) . ')',
                'params'    => $params,
            )
        ); 
        

        $criteria->order = '-t.priority desc,t.article_id desc';

        $title =  $category->name;
       
          

        $count = Article::model()->count($criteria);

        if ($count == 0) {
            return $this->renderJson(array(
                'status' => 'success',
                'data' => $data,
                'category' => $category
            ), 200);
        }

        $totalPages = ceil($count / $perPage);


        $article1 = Article::model()->findByAttributes(['article_id' => '496', 'status' => 'published']);


        $data['title'] =  $article1->page_title;
        $data['sub_title'] =  $article1->sub_title;
         
        $data['count'] = $count;
        $data['current_page'] = $page;
        $data['next_page'] = $page < $totalPages ? $page + 1 : null;
        $data['prev_page'] = $page > 1 ? $page - 1 : null;
        $data['total_pages'] = $totalPages;
        $data['banner_image'] =     API_URL.'uploads/files/'. $article1->banner ;
        //$criteria->order = 't.list_id DESC';
        $criteria->limit = $perPage;

        $criteria->offset = ($page - 1) * $perPage;

        $lists = Article::model()->findAll($criteria);
        
       
        foreach ($lists as $list) {
            $b_image = !empty($list->banner) ? API_URL2.'/uploads/files/' .   $list->banner  :$list->ArticleMainImage; 
            $url = Yii::app()->createUrl('articles/view', array('slug' => $list->slug));
            $record = array( 
                'id' => $list->primaryKey,
                'image' => 	 $b_image,
				 
                'DetailUrl' => str_replace('api/index.php/', '', $url), 
                'Title' => $list->title,
                'slug' => $list->slug,
                'ShortDescription' => $list->getExcerpt(80), 

            );
            $data['records'][] = $record;
        }

        return $this->renderJson(array(
            'status' => 'success',
            'data' => $data,
            'category' => $category,
            'subCategory' => $subCategory
        ), 200);
    }
    public function actiondevelopers__list()
    {
        
        
        $request = Yii::app()->request;
        $perPage = (int)$request->getQuery('per_page', 12);
        $page = (int)$request->getQuery('page', 1); 
        $maxPerPage = 50;
        $minPerPage = 10;

        if ($perPage < $minPerPage) {
            $perPage = $minPerPage;
        }

        if ($perPage > $maxPerPage) {
            $perPage = $maxPerPage;
        }

        if ($page < 1) {
            $page = 1;
        }

        $data = array(
            'count' => null,
            'total_pages' => null,
            'current_page' => null,
            'next_page' => null,
            'prev_page' => null,
            'records' => array(),
        ); 
        $banner = Banner::model()->getBannerById(30);  
        $banner_imge = !empty($banner) ? Yii::App()->apps->getBaseUrl('uploads/banner/'.$banner->image) : Yii::App()->apps->getBaseUrl('images/contact-us.jpg');
        
        $criteria = new CDbCriteria();
       $criteria->select       =    'CASE  WHEN t.header_image is not null then t.header_image else (SELECT  ad.bg_img  FROM {{place_an_ad}} ad  WHERE ad.isTrash="0" and ad.status="A" and ad.developer_id = t.developer_id ORDER By ad.id desc LIMIT 1 ) end  as bg_img,t.developer_id,t.slug as slug, t.developer_name as developer_name ,t.logo as  d_logo'; 
        $criteria->compare('t.profile_page','1' );
        $criteria->compare('t.status','A' );
        $criteria->compare('t.isTrash','0' );
        $criteria->order        =    '-t.priority desc,t.developer_name asc';
        if (isset($_GET['keyword']) and !empty($_GET['keyword'])) {
            $criteria->compare('t.developer_name', $_GET['keyword'],true);
        }
        $criteria->distinct = 't.developer_id';
        $title =  'REAL ESTATE DEVELOPERS IN DUBAI';
       
          

        $count = Developers::model()->count($criteria);

        if ($count == 0) {
            return $this->renderJson(array(
                'status' => 'success',
                'data' => $data
            ), 200);
        }

        $totalPages = ceil($count / $perPage);



        $data['title'] = $title;
        $data['count'] = $count;
        $data['current_page'] = $page;
        $data['next_page'] = $page < $totalPages ? $page + 1 : null;
        $data['prev_page'] = $page > 1 ? $page - 1 : null;
        $data['total_pages'] = $totalPages;
        $data['banner_image'] =       defined('KAYE') ? '/img/blog.jpg' :  API_URL2.'/'.$banner_imge;
        //$criteria->order = 't.list_id DESC';
        $criteria->limit = $perPage;

        $criteria->offset = ($page - 1) * $perPage;

        $lists = Developers::model()->findAll($criteria);
        
       
        foreach ($lists as $list) {
            $d_logo = !empty($list->d_logo) ? API_URL2.'/uploads/ads/' .   $list->d_logo  :'';
            $b_image = !empty($list->bg_img) ?  API_URL2 .'/uploads/ads/' .   $list->bg_img  :''; 
            $url = Yii::app()->createUrl('articles/view_developer', array('slug' => $list->slug));
            $record = array( 
                'id' => $list->primaryKey,
                'image' => 	 $b_image, 
                'DetailUrl' => str_replace('api/index.php/', '', $url), 
                'Title' => $list->developer_name,
                'ShortDescription' => $d_logo, 

            );
            $data['records'][] = $record;
        }

        return $this->renderJson(array(
            'status' => 'success',
            'data' => $data
        ), 200);
    }
    public function actiondevelopers_all()
    {
        $data = array(
            'count' => null,
            'records' => array(),
        );
    
        $banner = Banner::model()->getBannerById(30);  
        $banner_imge = !empty($banner) 
            ? Yii::App()->apps->getBaseUrl('uploads/banner/' . $banner->image) 
            : Yii::App()->apps->getBaseUrl('images/contact-us.jpg');
    
        $criteria = new CDbCriteria();
        $criteria->select = 'CASE  
                                WHEN t.header_image IS NOT NULL THEN t.header_image 
                                ELSE (
                                    SELECT ad.bg_img  
                                    FROM {{place_an_ad}} ad  
                                    WHERE ad.isTrash="0" AND ad.status="A" AND ad.developer_id = t.developer_id 
                                    ORDER BY ad.id DESC 
                                    LIMIT 1 
                                ) 
                             END AS bg_img,
                             t.developer_id,
                             t.slug,
                             t.developer_name,
                             t.description,
                             t.logo AS d_logo'; 
    
        $criteria->compare('t.profile_page', '1');
        $criteria->compare('t.status', 'A');
        $criteria->compare('t.isTrash', '0');
        $criteria->order = '-t.priority DESC, t.developer_name ASC';
    
        if (isset($_GET['keyword']) && !empty($_GET['keyword'])) {
            $criteria->compare('t.developer_name', $_GET['keyword'], true);
        }
    
        $criteria->distinct = 't.developer_id';
    
        $title = 'REAL ESTATE DEVELOPERS IN DUBAI';
        $data['title'] = $title;
        $data['banner_image'] = defined('KAYE') ? '/img/blog.jpg' : API_URL2 . '/' . $banner_imge;
    
        $lists = Developers::model()->findAll($criteria);
        $data['count'] = count($lists);
    
        foreach ($lists as $list) {
            $d_logo = !empty($list->d_logo) ? API_URL2 . '/uploads/ads/' . $list->d_logo : '';
            $b_image = !empty($list->bg_img) ? API_URL2 . '/uploads/ads/' . $list->bg_img : ''; 
            $url = Yii::app()->createUrl('articles/view_developer', array('slug' => $list->slug));
    
            $data['records'][] = array( 
                'id' => $list->primaryKey,
                'image' => $b_image, 
                'detailUrl' => $list->slug, 
                'title' => $list->developer_name,
                'shortDescription' => $list->description, 
                'banner' => $d_logo
            );
        }
    
        return $this->renderJson(array(
            'status' => 'success',
            'data' => $data
        ), 200);
    }
    public function actiondeveloper_by_slug()
    {
        $slug = isset($_GET['slug']) ? trim($_GET['slug']) : null;
    
        if (empty($slug)) {
            return $this->renderJson([
                'status' => 'error',
                'message' => 'Developer Not Found.'
            ], 400);
        }
    
        $banner = Banner::model()->getBannerById(30);  
        $banner_imge = !empty($banner) 
            ? Yii::App()->apps->getBaseUrl('uploads/banner/' . $banner->image) 
            : Yii::App()->apps->getBaseUrl('images/contact-us.jpg');
    
        $criteria = new CDbCriteria();
        $criteria->select = 'CASE  
                                WHEN t.header_image IS NOT NULL THEN t.header_image 
                                ELSE (
                                    SELECT ad.bg_img  
                                    FROM {{place_an_ad}} ad  
                                    WHERE ad.isTrash="0" AND ad.status="A" AND ad.developer_id = t.developer_id 
                                    ORDER BY ad.id DESC 
                                    LIMIT 1 
                                ) 
                             END AS bg_img,
                             t.developer_id,
                             t.slug,
                             t.developer_name,
                             t.description,
                             t.logo AS d_logo,
                             t.section_1_heading,
                             t.section_1_img,
                             t.section2_content,
                             t.section2_heading,
                             t.section_2_img,
                             t.section_3_description,
                             t.section_3_heading,
                             t.section_3_img'; 
    
        $criteria->compare('t.profile_page', '1');
        $criteria->compare('t.status', 'A');
        $criteria->compare('t.isTrash', '0');
        $criteria->compare('t.slug', $slug);
        $criteria->limit = 1;
    
        $developer = Developers::model()->find($criteria);
    
        if (!$developer) {
            return $this->renderJson([
                'status' => 'error',
                'message' => 'Developer not found.'
            ], 404);
        }
    
        $d_logo = !empty($developer->d_logo) ? API_URL2 . '/uploads/ads/' . $developer->d_logo : '';
        $b_image = !empty($developer->bg_img) ? API_URL2 . '/uploads/ads/' . $developer->bg_img : ''; 
        $url = Yii::app()->createUrl('articles/view_developer', ['slug' => $developer->slug]);
    
        $data = [
            'title' => 'REAL ESTATE DEVELOPERS IN DUBAI',
            'banner_image' => defined('KAYE') ? '/img/blog.jpg' : API_URL2 . '/' . $banner_imge,
            'developer' => [
                'id' => $developer->primaryKey,
                'image' => $b_image,
                'detailUrl' => $developer->slug,
                'title' => $developer->developer_name,
                'shortDescription' => $developer->description,
                'banner' => $d_logo,
                'section_1_heading' => $developer->section_1_heading,
                'section_1_img' => !empty($developer->section_1_img) ? API_URL2 . '/uploads/ads/' . $developer->section_1_img : '',
                'section2_content' => $developer->section2_content,
                'section2_heading' => $developer->section2_heading,
                'section_2_img' => !empty($developer->section_2_img) ? API_URL2 . '/uploads/ads/' . $developer->section_2_img : '',
                'section_3_description' => $developer->section_3_description,
                'section_3_heading' => $developer->section_3_heading,
                'section_3_img' => !empty($developer->section_3_img) ? API_URL2 . '/uploads/ads/' . $developer->section_3_img : '',
            ]
        ];
    
        return $this->renderJson([
            'status' => 'success',
            'data' => $data
        ], 200);
    }
    public function actiontestimonial__list()
    {
        
        
        $request = Yii::app()->request;
        $perPage = (int)$request->getQuery('per_page', 100);
        $page = (int)$request->getQuery('page', 1); 
        $maxPerPage = 100;
        $minPerPage = 10;

        if ($perPage < $minPerPage) {
            $perPage = $minPerPage;
        }

        if ($perPage > $maxPerPage) {
            $perPage = $maxPerPage;
        }

        if ($page < 1) {
            $page = 1;
        }

        $data = array(
            'count' => null,
            'total_pages' => null,
            'current_page' => null,
            'next_page' => null,
            'prev_page' => null,
            'records' => array(),
        ); 
        $banner = Banner::model()->getBannerById(30);  
        $banner_imge = !empty($banner) ? Yii::App()->apps->getBaseUrl('uploads/banner/'.$banner->image) : Yii::App()->apps->getBaseUrl('images/contact-us.jpg');
        
         $criteria = Reviews::model()->search(1); 
        $criteria->compare('t.status', Article::STATUS_PUBLISHED); 
        $criteria->order = '-t.priority desc,t.article_id asc';
        if (isset($_GET['keyword']) and !empty($_GET['keyword'])) {
            $criteria->compare('t.title', $_GET['keyword'],true);
        } 
        $title =  'Testimonials';
       
          

        $count = Reviews::model()->count($criteria);

        if ($count == 0) {
            return $this->renderJson(array(
                'status' => 'success',
                'data' => $data
            ), 200);
        }

        $totalPages = ceil($count / $perPage);



        $data['title'] = $title;
        $data['count'] = $count;
        $data['current_page'] = $page;
        $data['next_page'] = $page < $totalPages ? $page + 1 : null;
        $data['prev_page'] = $page > 1 ? $page - 1 : null;
        $data['total_pages'] = $totalPages;
        $data['banner_image'] =       defined('KAYE') ? '/img/blog.jpg' :   API_URL2 .'/'.$banner_imge;
        $criteria->order = 't.article_id DESC';
        $criteria->limit = $perPage;

        $criteria->offset = ($page - 1) * $perPage;

        $lists = Reviews::model()->findAll($criteria);
        
       
        foreach ($lists as $list) {
            $b_image = !empty($list->banner) ?  API_URL2 .'/uploads/files/' .   $list->banner  :  API_URL2 .  Yii::app()->apps->getBaseUrl('assets/img/grey.svg');
            $record = array( 
                'id' => $list->primaryKey,
                'image' => 	 $b_image, 
                
                'Title' => $list->title,
                'ShortDescription' => $list->content, 

            );
            $data['records'][] = $record;
        }

        return $this->renderJson(array(
            'status' => 'success',
            'data' => $data
        ), 200);
    }
    public function actionarea__list()
    {
        
        
        $request = Yii::app()->request;
        $perPage = (int)$request->getQuery('per_page', 12);
        $page = (int)$request->getQuery('page', 1); 
        $maxPerPage = 50;
        $minPerPage = 10;

        if ($perPage < $minPerPage) {
            $perPage = $minPerPage;
        }

        if ($perPage > $maxPerPage) {
            $perPage = $maxPerPage;
        }

        if ($page < 1) {
            $page = 1;
        }

        $data = array(
            'count' => null,
            'total_pages' => null,
            'current_page' => null,
            'next_page' => null,
            'prev_page' => null,
            'records' => array(),
        ); 
        $banner = Banner::model()->getBannerById(29);  
        $banner_imge = !empty($banner) ? Yii::App()->apps->getBaseUrl('uploads/banner/'.$banner->image) : Yii::App()->apps->getBaseUrl('images/contact-us.jpg');
        
        $criteria = TopAreas::model()->search(1);
        $criteria->select       =    't.cover_image as banner,t.title,t.slug'; 
   
        $criteria->order        =    '-t.priority desc,t.title asc';
        if (isset($_GET['keyword']) and !empty($_GET['keyword'])) {
            $criteria->compare('t.title', $_GET['keyword'],true);
        }
        
        $title =  'Dubai Area Guides';
       
          

        $count = TopAreas::model()->count($criteria);

        if ($count == 0) {
            return $this->renderJson(array(
                'status' => 'success',
                'data' => $data
            ), 200);
        }

        $totalPages = ceil($count / $perPage);



        $article1 = Article::model()->findByAttributes(['article_id' => '425', 'status' => 'published']);


        $data['title'] =  $article1->page_title;
        $data['sub_title'] =  $article1->sub_title;
 
        $data['banner_image'] =     API_URL . 'uploads/files/' . $article1->banner;


        //$data['title'] = $title;
        $data['count'] = $count;
        $data['current_page'] = $page;
        $data['next_page'] = $page < $totalPages ? $page + 1 : null;
        $data['prev_page'] = $page > 1 ? $page - 1 : null;
        $data['total_pages'] = $totalPages;
        //$data['banner_image'] =       defined('KAYE') ? '/img/blog.jpg' :   API_URL2 .$banner_imge;
        //$criteria->order = 't.list_id DESC';
        $criteria->limit = $perPage;

        $criteria->offset = ($page - 1) * $perPage;

        $lists = TopAreas::model()->findAll($criteria);
        
       
        foreach ($lists as $list) {
            $b_image =    API_URL .'/uploads/files/' .   $list->banner  ; 
            $url = Yii::app()->createUrl('articles/area_guide_detail', array('slug' => $list->slug));
            $record = array( 
                'id' => $list->primaryKey,
                'image' => 	 $b_image, 
                'DetailUrl' =>   str_replace('api/index.php/', '', $url), 
                'Title' => $list->title,
                'ShortDescription' => '', 

            );
            $data['records'][] = $record;
        }

        return $this->renderJson(array(
            'status' => 'success',
            'data' => $data
        ), 200);
    }
    
    public function actionareaguide_detail($slug)
    {
        $criteria = TopAreas::model()->model()->search(1);
        $criteria->compare('t.slug', $slug);
        $list = TopAreas::model()->find($criteria);

        if (empty($list)) {
            return $this->renderJson(array(
                'status'    => 'error',
                'error'     => Yii::t('api', 'The article does not exist.')
            ), 404);
        }


        $url = Yii::app()->createUrl('articles/area_guide_detail', array('slug' => $list->slug));
        $latest = [];
        $criteria = TopAreas::model()->model()->search(1);
        $criteria->compare('t.slug!', $slug);
        $criteria->condition .= ' and COALESCE(t.cover_image,0) !="0" '; 
        $criteria->limit = '4';
        $latestItems = TopAreas::model()->findAll($criteria);

        if ($latestItems) {
            foreach ($latestItems as $k => $v) {
                $url = Yii::app()->createUrl('articles/area_guide_detail', array('slug' => $v->slug));
                $b_image =    API_URL . '/uploads/files/' .   $v->cover_image;
 
                $latest[] = ['title' => $v->title, 'slug' =>  str_replace('api/index.php/', '', $url), 'image' => $b_image];
            }
        }

        $record = array(
            'id' =>  $list->primaryKey,
            'category' =>      $category,
            'Image' =>       API_URL .'/uploads/files/' .   $list->cover_image    ,
            'banner_image'  => API_URL .'/uploads/files/' .   $list->cover_image  , 
            'Title' => $list->title,
            'DetailUrl' => str_replace('api/index.php/', '', $url),
            'ShortDescription' => $list->getExcerpt(80),
            'Description' => $list->overview,
            'DatePublished' => date('Y-m-d', strtotime($list->date_added)),
            'DateModified' => date('Y-m-d', strtotime($list->date_added)),
            'AuthorName'    => "PROJECT_NAME",
            'AbsoluteURL'   => PROJECT_URL . $url,
            'need_banner'   => true,
            'sub_title'   =>  '' ,
            'latest'         =>    $latest,
            'faqs'  => !empty($list->faqs) ? json_decode($list->faqs) : NULL ,
        );
 

        $data = array('record' => $record);

        return $this->renderJson(array(
            'status'    => 'success',
            'data'      => $data,
        ), 200);
    }
	public function actionArticle_detail($slug)
	{
	    
		$list = Article::model()->findByAttributes(array(
            'slug'      => $slug,
            'status'    => Article::STATUS_PUBLISHED
        ));
         
		if (empty($list)) {
			return $this->renderJson(array(
				'status'    => 'error',
				'error'     => Yii::t('api', 'The article does not exist.')
			), 404);
		}
		$latest = []; 
        $categoryModel =  $list->findCategoryThis;
        $category = '';
        $needBanner = true;
        if(!empty($categoryModel)   ){
                switch($categoryModel->category_id){
                    case '4':
                        $latestItems = Article::model()->ListOtherRelated($list->article_id,$categoryModel->category_id,$limit=10);
                        if($latestItems){
                            foreach($latestItems as $k=>$v){
                                $image_main = 	!empty($v->banner) ?  API_URL2 .'/uploads/files/' .   $v->banner  :$v->ArticleMainImage ;
        	
                                $latest[] = ['title'=>$v->title,'slug'=>$v->slug, 'image'=>$image_main]; 
                            }
                        }
                        
        				$banner = Banner::model()->getBannerById(24);  
        				$banner_imge = !empty($banner) ? Yii::App()->apps->getBaseUrl('uploads/banner/'.$banner->image) : Yii::App()->apps->getBaseUrl('images/contact-us.jpg');
                        $category = 'blog';
                    $article1 = Article::model()->findByAttributes(['article_id' => '424', 'status' => 'published']);
  
                    $b_image_o =      API_URL . 'uploads/files/' . $article1->banner;
                    break;
                    case '24':
                    case '26':
                    case '27':
                    case '28':
                    case '29':
                    case '30':
                    case '31':
                    case '32':
                        $slug = 'guides';
                        $category = ArticleCategory::model()->findByAttributes(array("slug"=>$slug));
                        
                        $criteria_subcategory = new CDbCriteria();
                        $criteria_subcategory->compare('t.status', ArticleCategory::STATUS_ACTIVE);
                        $criteria_subcategory->compare('t.parent_id', $category->category_id);
                        $subCategory = ArticleCategory::model()->findAll($criteria_subcategory);
                        
                        $subCategoryIds = array_map(function($cat) {
                            return $cat->category_id;
                        }, $subCategory);
                        
                        $placeholders = [];
                        $params = [];
                        foreach ($subCategoryIds as $index => $id) {
                            $key = ':cid' . $index;
                            $placeholders[] = $key;
                            $params[$key] = $id;
                        }
                        
                        $criteria = new CDbCriteria();
                        $criteria->addCondition('t.article_id != '.$list->article_id);
                        $criteria->compare('t.status', Article::STATUS_PUBLISHED);
                        if (isset($_GET['keyword']) and !empty($_GET['keyword'])) {
                            $criteria->compare('t.title', $_GET['keyword'],true);
                        }
                        $criteria->with = array(
                            'activeCategories' => array(
                                'select'    => 'activeCategories.category_id',
                                'together'  => true,
                                'joinType'  => 'INNER JOIN',
                                'condition' => 'activeCategories.category_id = :cid',
                                'params'    => array(':cid' => $category->category_id),
                                'condition' => 'activeCategories.category_id IN (' . implode(',', $placeholders) . ')',
                                'params'    => $params,
                            )
                        ); 
                        
                
                        $criteria->order = '-t.priority desc,t.article_id desc';
                        
                        $latestItems = Article::model()->findAll($criteria);
                        if($latestItems){
                            foreach($latestItems as $k=>$v){
                                $image_main = 	!empty($v->banner) ?  API_URL2 .'/uploads/files/' .   $v->banner  :$v->ArticleMainImage ;
        	
                                $latest[] = ['title'=>$v->title,'slug'=>$v->slug, 'image'=>$image_main]; 
                            }
                        }
                        
        				$banner = Banner::model()->getBannerById(24);  
        				$banner_imge = !empty($banner) ? Yii::App()->apps->getBaseUrl('uploads/banner/'.$banner->image) : Yii::App()->apps->getBaseUrl('images/contact-us.jpg');
                        $category = 'blog';
                        $article1 = Article::model()->findByAttributes(['article_id' => '424', 'status' => 'published']);
      
                        $b_image_o =      API_URL . 'uploads/files/' . $article1->banner;
                    break;
                
                }
        }
        if(empty($category)){
            if($list->article_id == '9'){
                       
            				$banner_imge =   API_URL2 . 'uploads/files/' .   $list->banner;
                            $category = 'about';
                            $b_image_o = $banner_imge;
                        
            } else if($list->article_id == '483'){
                       
            				$banner_imge =   API_URL2 . 'uploads/files/' .   $list->banner;
                            $category = 'our-team';
                            $b_image_o = $banner_imge;
                            $needBanner = false;
                        
            } else{
                 $category = 'content';
                 $b_image_o = defined('KAYE') ? '/img/about.jpg' :   API_URL2 .$banner_imge;
            }
        }
       
        
         $url = Yii::app()->createUrl('articles/view', array('slug' => $list->slug));
		$record = array(
        'id' =>  $list->primaryKey,
        'category' =>  	$category, 
        'Image' => 	!empty($list->banner) ?  API_URL2 .'uploads/files/' .   $list->banner  :$list->ArticleMainImage ,
		'banner_image'  =>  $b_image_o ,	
        'Title' => $list->title,
        'DetailUrl' => str_replace('api/index.php/', '', $url), 
        'ShortDescription' => $list->getExcerpt(80), 
        'Description' => $list->content,
        'DatePublished' => date('Y-m-d',strtotime($list->date_added)),
        'DateModified' => date('Y-m-d',strtotime($list->last_updated)),
        'AuthorName'    => PROJECT_NAME,
        'AbsoluteURL'   => PROJECT_URL.$url, 
        'need_banner'   => $needBanner,
        'sub_title'   => $list->sub_title,
        'latest'         =>    $latest 
);

	 

		$data = array('record' => $record);

		return $this->renderJson(array(
			'status'    => 'success',
			'data'      => $data,
			'category_id' => $categoryModel->category_id
		), 200);
	}
	public function actionOther_request()
	{
	       
		// Create an instance of the contact form model
		$model = new DownloadForm();
       
		// Collect data from the request body
		if (isset($_REQUEST)) {
            $this->getValidateRecaptcha();
			$model->attributes = $_REQUEST;
            $model->phone_false = $_REQUEST['ph'];  
			// Validate the model
			if ($model->save()) {
				// Perform the action (e.g., send an email or save data)
				// Here we can assume that the form is valid and we want to send a response
				Yii::app()->user->setFlash('contact', 'Thank you for your message.');
				// Send response to the React frontend
				echo CJSON::encode(array(
					'status' => 'success',
					'message' => 'Thank you for your interest.One of our agent will contact you soon and send you download details'
				));
			} else {
				// If validation fails
				$ar = 	$model->errors;
				if(isset($ar['phone_false'])){
				    $ar['ph'] = $ar['phone_false'];
				}
				if(isset($ar['meassage'])){
				    $ar['message'] = $ar['meassage'];
				}
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'There was an error with your form submission.',
					'errors' => $ar,
				));
			}
		}
	}
		public function actionBrochure_request()
	{
	       
		// Create an instance of the contact form model
		$model = new Brochure();
       
		// Collect data from the request body
		if (isset($_REQUEST)) {
            $this->getValidateRecaptcha();
			$model->attributes = $_REQUEST;
            $model->phone_false = $_REQUEST['ph'];  
			// Validate the model
			if ($model->save()) {
              	// Perform the action (e.g., send an email or save data)
				// Here we can assume that the form is valid and we want to send a response
				Yii::app()->user->setFlash('contact', 'Thank you for your message.');
				// Send response to the React frontend
				echo CJSON::encode(array(
					'status' => 'success',
					'message' => 'Thank you for your interest.One of our agent will contact you soon and send you full brochure link'
				));
			} else {
				// If validation fails
				$ar = 	$model->errors;
				if(isset($ar['phone_false'])){
				    $ar['ph'] = $ar['phone_false'];
				}
				if(isset($ar['meassage'])){
				    $ar['message'] = $ar['meassage'];
				}
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'There was an error with your form submission.',
					'errors' => $ar,
				));
			}
		} 
	}
	public function actionListing_category(){
	    $items = Category::model()->category_by_type_all();
	    $ar = []; 
	    if($items){
	        foreach($items as $k=>$v){
	            $ar[] = ['id'=>$v->category_id, 'name'=> $v->category_name]; 
	        }
	    }
	    echo CJSON::encode($ar);
	}
		public function actionListing_designation(){
	    $items = Master::model()->listData(4);
	    $ar = []; 
	    if($items){
	        foreach($items as $k=>$v){
	            $ar[] = ['id'=>$v->master_id, 'name'=> $v->master_name]; 
	        }
	    }
        $article = Article::model()->findByAttributes(['article_id' => '12', 'status' => 'published']);
        $properties = [
            'banner'        => API_URL . '/uploads/files/' . @$article->banner,
            'image2'        => API_URL . '/uploads/files/' . @$article->image2,
            'headerTitle'   => @$article->page_title,
            'sub_title'     => @$article->sub_title,
            'content'       => @$article->content,
        ];
        echo CJSON::encode(['data'=>$ar, 'properties'=> $properties]);
	}
    public function getValidateRecaptcha(){
        
        $secret = '6Lfx54krAAAAAFpKVzJdZu9v0v7_TRhGirq6H3EQ';
        $recaptcha_token = $_GET['recaptcha_token'];

        $response = file_get_contents("https://www.google.com/recaptcha/api/siteverify?secret=$secret&response=$recaptcha_token");
        $verified = json_decode($response, true);
        
        if (!$verified['success'] || $verified['score'] < 0.5) {
            echo json_encode([
                'status' => 'error',
                'message' => 'reCAPTCHA verification failed',
            ]); exit;
        }
    }
	public function actionSend_contact()
	{
	     
		// Create an instance of the contact form model
		$model = new ContactUs();
       
		// Collect data from the request body
		if (isset($_REQUEST)) {
            $this->getValidateRecaptcha();
			$model->attributes = $_REQUEST;
            $model->phone = str_replace(' ','',$_REQUEST['ph']);
            $model->meassage = $_REQUEST['message'];
            //$model->section  = $_REQUEST['sect']; 
			// Validate the model
			if ($model->save()) {
				// Perform the action (e.g., send an email or save data)
				// Here we can assume that the form is valid and we want to send a response
				Yii::app()->user->setFlash('contact', 'Thank you for your message.');
				// Send response to the React frontend
				echo CJSON::encode(array(
					'status' => 'success',
					'message' => Yii::t('app','Your message was successfully sent to the {p} Support Team. One of our representative will contact you soon.'  ,array('{p}'=>Yii::app()->options->get('system.common.site_name'))),
				));
			} else {
				// If validation fails
				$ar = 	$model->errors;
				if(isset($ar['phone'])){
				    $ar['ph'] = $ar['phone'];
				}
				if(isset($ar['message'])){
				    $ar['meassage'] = $ar['message'];
				}
			  
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'There was an error with your form submission.',
					'errors' => $ar,
				));
			}
		}
	}
	public function actionSave_view_booking()
	{
	       
		// Create an instance of the contact form model
		$model = new ViewBooking();

		// Collect data from the request body
		if (isset($_REQUEST)) {
            $this->getValidateRecaptcha();
			$model->attributes = $_REQUEST;
			$model->added_date = date('Y-m-d H:i:s');
            $model->first_name = $_REQUEST['firstName'];
            $model->last_name = $_REQUEST['lastName'];
            $model->phone = str_replace(' ','',$_REQUEST['ph']);
            
			// Validate the model
			if ($model->save()) {
                $name = $model->first_name.' '. $model->last_name; 
                ContactUs::model()->sendRegisterInterestLeadToBitrix($name, $model->email, $model->phone, $model->message, 'Book a Viewing');

                // Perform the action (e.g., send an email or save data)
                Yii::app()->user->setFlash('contact', 'Thank you for your message.');
				// Send response to the React frontend
				echo CJSON::encode(array(
					'status' => 'success',
					'message' => Yii::t('app','Your message was successfully sent to the {p} Support Team. One of our representative will contact you soon.'  ,array('{p}'=>Yii::app()->options->get('system.common.site_name'))),
				));
			} else {
				// If validation fails
				$ar = 	$model->errors;
				if(isset($ar['phone'])){
				    $ar['ph'] = $ar['phone'];
				}
			  
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'There was an error with your form submission.',
					'errors' => $ar,
				));
			}
		}
	}
	public function actionSave_service_enquiry_response()
	{
	       
		// Create an instance of the contact form model
		$model = new ServiceEnquiry();

		// Collect data from the request body
		if (isset($_REQUEST)) {
			$model->attributes = $_REQUEST;
			$model->added_date = date('Y-m-d H:i:s');
            $model->full_name = $_REQUEST['fullName'];
            $model->preferred_lang = $_REQUEST['preferred_language'];
            $model->phone = str_replace(' ','',$_REQUEST['ph']);
            
			// Validate the model
			if ($model->save()) {
				// Perform the action (e.g., send an email or save data)
				Yii::app()->user->setFlash('contact', 'Thank you for your message.');
				// Send response to the React frontend
				echo CJSON::encode(array(
					'status' => 'success',
					'message' => Yii::t('app','Your message was successfully sent to the {p} Support Team. One of our representative will contact you soon.'  ,array('{p}'=>Yii::app()->options->get('system.common.site_name'))),
				));
			} else {
				// If validation fails
				$ar = 	$model->errors;
				if(isset($ar['phone'])){
				    $ar['ph'] = $ar['phone'];
				}
			  
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'There was an error with your form submission.',
					'errors' => $ar,
				));
			}
		}
	}
	public function actionLanding_registrations()
	{
	       
		// Create an instance of the contact form model
		$model = new LandingRegistrations();

		// Collect data from the request body
		if (isset($_REQUEST)) {
			$model->attributes = $_REQUEST;
			$model->added_date = date('Y-m-d H:i:s');
            $model->full_name = $_REQUEST['fullName'];
            $model->phone = str_replace(' ','',$_REQUEST['ph']);
            $model->interested_in = $_REQUEST['interestedin'];
            $model->i_am = $_REQUEST['iam'];
			// Validate the model
			if ($model->save()) {
				// Perform the action (e.g., send an email or save data)
				Yii::app()->user->setFlash('contact', 'Thank you for your message.');
				// Send response to the React frontend
				echo CJSON::encode(array(
					'status' => 'success',
					'message' => Yii::t('app','Your enquiry was successfully sent to the {p} Support Team. One of our representative will contact you soon.'  ,array('{p}'=>Yii::app()->options->get('system.common.site_name'))),
				));
			} else {
				// If validation fails
				$ar = 	$model->errors;
				if(isset($ar['phone'])){
				    $ar['ph'] = $ar['phone'];
				}
			  
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'There was an error with your form submission.',
					'errors' => $ar,
				));
			}
		}
	}
	public function actionSubscribe_newsletter()
	{
	       
		// Create an instance of the contact form model
		$model = new NewsletterSubscription();

		// Collect data from the request body
		if (isset($_REQUEST)) {
			$model->attributes = $_REQUEST;
			$model->added_date = date('Y-m-d H:i:s');
			// Validate the model
			if ($model->save()) {
				// Perform the action (e.g., send an email or save data)
				Yii::app()->user->setFlash('contact', 'Thank you for your message.');
				// Send response to the React frontend
				echo CJSON::encode(array(
					'status' => 'success',
					'message' => Yii::t('app',"Thank you for subscribing to our newsletter. You'll start receiving the latest updates and news from {p} soon."  ,array('{p}'=>Yii::app()->options->get('system.common.site_name'))),
				));
			} else {
			  
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'There was an error with your form submission.',
					'errors' => $ar,
				));
			}
		}
	}
	public function actionSend_list_your_property()
	{
	       
		// Create an instance of the contact form model
		$model = new ListProperty();
       
		// Collect data from the request body
		if (isset($_REQUEST)) {
			$model->attributes = $_REQUEST;
            $model->phone_false = str_replace(' ','',$_REQUEST['ph']);
            $model->category_id = $_REQUEST['category'];
            $model->section  = $_REQUEST['sect']; 
			// Validate the model
			if ($model->save()) {
				// Perform the action (e.g., send an email or save data)
				// Here we can assume that the form is valid and we want to send a response
				Yii::app()->user->setFlash('contact', 'Thank you for your message.');
				// Send response to the React frontend
				echo CJSON::encode(array(
					'status' => 'success',
					'message' => Yii::t('app','Your message was successfully sent to the {p} Support Team. One of our representative will contact you soon.'  ,array('{p}'=>Yii::app()->options->get('system.common.site_name'))),
				));
			} else {
				// If validation fails
				$ar = 	$model->errors;
				if(isset($ar['phone_false'])){
				    $ar['ph'] = $ar['phone_false'];
				}
				if(isset($ar['category_id'])){
				    $ar['category'] = $ar['category_id'];
				}
				if(isset($ar['section'])){
				  
				    $ar['sect'] = $ar['section'];  unset($ar['section']);
				}
				//print_r($ar);exit; 
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'There was an error with your form submission.',
					'errors' => $ar,
				));
			}
		}
	}
	public function getPropertyNameList($section=1){
        $criteria=new CDbCriteria;
        $criteria->condition = '1 ';
        $criteria->distinct = 't.property_name'; 
        $criteria->condition .= ' and t.property_name != "" and t.property_name is not null ';
        
        $criteria->select = 't.property_name';
        $criteria->order = 'property_name asc';
        
        $propertyNameList =  PlaceAnAd::model()->findAll($criteria) ;
        $ar = []; 
        if($propertyNameList){
            foreach($propertyNameList as $k=>$v){
                $ar[] = ['id'=>$v->property_name,'uid'=>$v->property_name, 'name'=>$v->property_name];
            }
        }
        return $ar; 
	}
	public function getCommunityList($section=1){
        $criteria=new CDbCriteria;
        $criteria->condition = '1 ';
        $criteria->distinct = 't.community_id'; 
        $criteria->join = ' inner join {{place_an_ad}} ad on ad.community_id = t.community_id and ad.status = "A" and ad.is_new IS NULL ';
         $criteria->condition .= ' and t.slug is not null and t.community_name != "" '; 
        switch($section){
            case '1' : 
                //$criteria->condition .= ' and ad.section_id  in (1,2) ';
            break;
                
        }
         //$criteria->join .= ' left join {{district}} district0 on district0.district_id = t.district_id  ';
        //$criteria->join .= ' left join {{city}} city0 on city0.city_id = district0.city_id  ';
       // $criteria->join .= ' left join {{states}} states0 on states0.state_id = city0.state_id and states0.country_id ="65946"  ';
        
        $criteria->select = 't.slug,t.community_name ,t.community_id,ad.status,ad.is_new';
        $criteria->order = 'community_name asc';
        
        $communities =  Community::model()->findAll($criteria) ;
        $ar = []; 
        if($communities){
            foreach($communities as $k=>$v){
                $ar[] = ['id'=>$v->slug,'uid'=>$v->community_id, 'name'=>$v->community_name];
            }
        } 
        return $ar; 
	}
	public function getSubCommunityList($section=1){
        $criteria=new CDbCriteria;
        $criteria->condition = '1 ';
        $criteria->distinct = 't.sub_community_id'; 
        $criteria->join = ' inner join {{place_an_ad}} ad on ad.sub_community_id = t.sub_community_id and ad.status = "A" and ad.is_new IS NULL ';
         $criteria->condition .= ' and t.slug is not null '; 
        switch($section){
            case '1' : 
                //$criteria->condition .= ' and ad.section_id  in (1,2) ';
            break;
                
        }
         //$criteria->join .= ' left join {{district}} district0 on district0.district_id = t.district_id  ';
        //$criteria->join .= ' left join {{city}} city0 on city0.city_id = district0.city_id  ';
       // $criteria->join .= ' left join {{states}} states0 on states0.state_id = city0.state_id and states0.country_id ="65946"  ';
        
        $criteria->select = 't.slug,t.sub_community_name ,t.sub_community_id, ad.status, ad.is_new';
        $criteria->order = 'sub_community_name asc';
        
        $sub_communities =  SubCommunity::model()->findAll($criteria) ;
        $ar = []; 
        if($sub_communities){
            foreach($sub_communities as $k=>$v){
                $ar[] = ['id'=>$v->slug,'uid'=>$v->sub_community_id, 'name'=>$v->sub_community_name];
            }
        }
        return $ar; 
	}
    public function actionfetch_types2($type = null, $sect = 1, $lang = null)
    {
        $cacheKey =  'fetch_cache3.12321sdwe';

        if ($items = Yii::app()->cache->get($cacheKey)) {

            // echo CJSON::encode($items);
        } else {
            $years = $this->filterAndSortYears(CHtml::listData(Master::model()->listData(5), 'master_id', 'master_name'), date('Y'));
            $year_ar = [];
            foreach ($years as $k => $v) {
                $year_ar[] = ['id' => $k, 'name' => $v];
            }

            $category_offplan       =   Category::model()->developmentCatogoriescache();
            foreach ($category_offplan as $k => $v) {
                if (!empty($v->slug)) {
                    $category_offplan_list[] = ['icon' => 'ApartmentIcon', 'id' => $v->slug, 'name' => Yii::t('t', $v->category_name)];
                }
            }

            $developer_list = Developers::model()->cacheclistDeveloper();
            foreach ($developer_list as $k => $v) {
                $ar['developer_list'][$k] = Yii::t('t', $v);
            }


            $residential = Category::model()->category_by_type('R');
            $commercial  = Category::model()->category_by_type('C');

            foreach ($residential as $k => $v) {
                $ar['residential'][] = ['icon' => str_replace('-', '', $v->slug), 'id' => $v->slug, 'name' => Yii::t('t', $v->category_name)];
            }
            foreach ($commercial as $k => $v) {
                $ar['commercial'][] = ['icon' => str_replace('-', '', $v->slug), 'id' => $v->slug, 'name' => Yii::t('t', $v->category_name)];
            }
            $ar['communities']  = $this->getCommunityList($sect);
            $developerOptions = [];
            $developers_new = (array_filter($ar['developer_list']));
            $uidStart = 1111001;
            foreach ($developers_new as $id => $name) {
                $developerOptions[] = [
                    'id' => $id,
                    'uid' => $uidStart++,
                    'name' => $name,
                ];
            }  
            $ar['developerOptions']  = $developerOptions;
            $ar['subCommunities']  = $this->getSubCommunityList($sect);
            $ar['propertyNameList']  = $this->getPropertyNameList($sect);
            $ar['amenities']  = Amenities::model()->getAllAmentiesCache();

            $sale_price   =   $this->salePriceNew();
            $rentPrice     =   $this->rentPriceNew();
            $bedArray   =   $this->bedArray();
            $bathArray   =   $this->bathArray();
            $ar['sale']['minPrice'] =  $sale_price;
            $ar['rent']['minPrice'] =  $rentPrice;
          
            $ar['minBeds'][] = ['id' => '0', 'name' => Yii::t('t', 'All Bedrooms')];
            foreach ($bedArray as $k => $v) {
                $ar['minBeds'][] = ['id' => $k, 'name' => $v];
            }
            $ar['minBaths'][] = ['id' => '0', 'name' => Yii::t('t', 'All Bathrooms')];
            foreach ($bathArray as $k => $v) {
                $ar['minBaths'][] = ['id' => $k, 'name' => $v];
            }
            $ar['year'] = $year_ar;
            $ar['offpla_category'] = $category_offplan_list;
            $ar['labels']   =
                [
                    'buy' => Yii::t('t', 'Buy'),
                    'rent' => Yii::t('t', 'Rent'),
                    'offplan' => Yii::t('t', 'Off-Plan'),
                    'property_type' => Yii::t('t', 'Property Type'),
                    'residential' => Yii::t('t', 'Residential'),
                    'commercial' => Yii::t('t', 'Commercial'),
                    'community' => Yii::t('t', 'Building, Developer, Area'),
                    'year' => Yii::t('t', 'Completion Year'),
                    'search' => Yii::t('t', 'SEARCH'),
                    'reset' => Yii::t('t', 'Reset'),
                    'all' => Yii::t('t', 'Property Type'),
                ];
            //Yii::app()->cache->set($cacheKey, $ar,60 * 60 * 1   ); 
            echo CJSON::encode($ar);
        }
    }
	public function actionfetch_types($type=null,$sect=1){
	    $cacheKey =  'fetch_cache3.22222232sqa';
	
		if ($items = Yii::app()->cache->get($cacheKey)) {
		    
			 echo CJSON::encode($items);
		}else{
	    $years = $this->filterAndSortYears(CHtml::listData(Master::model()->listData(5),'master_id','master_name'),date('Y'));
	    $year_ar = [];
	    foreach($years as $k=>$v){
	        $year_ar[] = ['id' => $k, 'name' => $v]; 
	    }
	    
	    $category_offplan       =   Category::model()->developmentCatogoriescache();
	    foreach($category_offplan as $k=>$v){
	        if(!empty($v->slug)){
	         $category_offplan_list[] = ['id' => $v->slug, 'name' => $v->category_name]; 
	        }
	    }
	    
        $developer_list = Developers::model()->cacheclistDeveloper();
         foreach($developer_list as $k=>$v){
	        $ar['developer_list'][] = ['id'=>$k, 'name'=>$v];
	    }
	  
	    $residential = Category::model()->category_by_type('R');
	    $commercial  = Category::model()->category_by_type('C');
	  
	    foreach($residential as $k=>$v){
	        $ar['residential'][] = ['id'=>$v->slug, 'name'=>$v->category_name];
	    }
	    foreach($commercial as $k=>$v){
	        $ar['commercial'][] = ['id'=>$v->slug, 'name'=>$v->category_name];
	    } 
	    $ar['communities']  = $this->getCommunityList($sect);
	    $ar['subCommunities']  = $this->getSubCommunityList($sect);
	    $ar['propertyNameList']  = $this->getPropertyNameList($sect);
	    
	    $ar['offPlanCommunities']  = $this->getOffplanCommunityList($sect);
	    $ar['offPlanSubCommunities']  = $this->getOffplanSubCommunityList($sect);
	   
	    $sale_price   =   $this->salePrice();
        $rentPrice     =   $this->rentPrice(); 
        $bedArray   =   $this->bedArray();
        $bathArray   =   $this->bathArray();
        $ar['sale']['minPrice'][] = ['id'=>0, 'name'=>'All Price'];
        $ar['rent']['minPrice'][] = ['id'=>0, 'name'=>'All Price'];
        foreach($sale_price as $k=>$v){
            
            $ar['sale']['minPrice'][] = ['id'=>$k, 'name'=>$v];
            
        } 
        foreach($rentPrice as $k=>$v){
            $ar['rent']['minPrice'][] = ['id'=>$k, 'name'=>$v]; 
        } 
         $ar['minBeds'][] = ['id'=>'0', 'name'=>'All Bedrooms'];
        foreach($bedArray as $k=>$v){
            $ar['minBeds'][] = ['id'=>$k, 'name'=>$v];
            
        }
        $ar['minBaths'][] = ['id'=>'0', 'name'=>'All Bathrooms'];
        foreach($bathArray as $k=>$v){
            $ar['minBaths'][] = ['id'=>$k, 'name'=>$v];
            
        } 
	    $ar['year'] = $year_ar; 
	    $ar['offpla_category'] = $category_offplan_list;
          
       	Yii::app()->cache->set($cacheKey, $ar,60 * 60 * 1   );
     	 
	    echo CJSON::encode($ar);
		}
	}
	public function getOffplanCommunityList($section=1){
        $criteria=new CDbCriteria;
        $criteria->condition = '1 ';
        $criteria->distinct = 't.community_id'; 
        $criteria->join = ' inner join {{place_an_ad}} ad on ad.community_id = t.community_id and ad.status = "A" and ad.is_new = "1" ';
         $criteria->condition .= ' and t.slug is not null '; 
        switch($section){
            case '1' : 
                //$criteria->condition .= ' and ad.section_id  in (1,2) ';
            break;
                
        }
         //$criteria->join .= ' left join {{district}} district0 on district0.district_id = t.district_id  ';
        //$criteria->join .= ' left join {{city}} city0 on city0.city_id = district0.city_id  ';
       // $criteria->join .= ' left join {{states}} states0 on states0.state_id = city0.state_id and states0.country_id ="65946"  ';
        
        $criteria->select = 't.slug,t.community_name ,t.community_id,ad.status,ad.is_new';
        $criteria->order = 'community_name asc';
        
        $communities =  Community::model()->findAll($criteria) ;
        $ar = []; 
        if($communities){
            foreach($communities as $k=>$v){
                $ar[] = ['id'=>$v->slug,'uid'=>$v->community_id, 'name'=>$v->community_name];
            }
        }
        return $ar; 
	}
	public function getOffplanSubCommunityList($section=1){
        $criteria=new CDbCriteria;
        $criteria->condition = '1 ';
        $criteria->distinct = 't.sub_community_id'; 
        $criteria->join = ' inner join {{place_an_ad}} ad on ad.sub_community_id = t.sub_community_id and ad.status = "A" and ad.is_new = "1" ';
         $criteria->condition .= ' and t.slug is not null '; 
        switch($section){
            case '1' : 
                //$criteria->condition .= ' and ad.section_id  in (1,2) ';
            break;
                
        }
         //$criteria->join .= ' left join {{district}} district0 on district0.district_id = t.district_id  ';
        //$criteria->join .= ' left join {{city}} city0 on city0.city_id = district0.city_id  ';
       // $criteria->join .= ' left join {{states}} states0 on states0.state_id = city0.state_id and states0.country_id ="65946"  ';
        
        $criteria->select = 't.slug,t.sub_community_name ,t.sub_community_id, ad.status, ad.is_new';
        $criteria->order = 'sub_community_name asc';
        
        $sub_communities =  SubCommunity::model()->findAll($criteria) ;
        $ar = []; 
        if($sub_communities){
            foreach($sub_communities as $k=>$v){
                $ar[] = ['id'=>$v->slug,'uid'=>$v->sub_community_id, 'name'=>$v->sub_community_name];
            }
        }
        return $ar; 
	}
	public function actionoffplan_fetch_types($type=null,$sect=1){
	    $cacheKey =  'fetch_cache3.56tg6t7yg1' . date('Y-m-d');
	
		if ($items = Yii::app()->cache->get($cacheKey)) {
		    
			 echo CJSON::encode($items);
		}else{
	    $years = $this->filterAndSortYears(CHtml::listData(Master::model()->listData(5),'master_id','master_name'),date('Y'));
	    $year_ar = [];
	    foreach($years as $k=>$v){
	        $year_ar[] = ['id' => $k, 'name' => $v]; 
	    }
	    
	    $category_offplan       =   Category::model()->developmentCatogoriescache();
	    foreach($category_offplan as $k=>$v){
	        if(!empty($v->slug)){
	         $category_offplan_list[] = ['id' => $v->slug, 'name' => $v->category_name]; 
	        }
	    }
	    
        $developer_list = Developers::model()->cacheclistDeveloper();
         foreach($developer_list as $k=>$v){
	        $ar['developer_list'][] = ['id'=>$k, 'name'=>$v];
	    }
	  
	    $property_type = Category::model()->category_by_type_all('');
	   // $commercial  = Category::model()->category_by_type('C');
	  
	    foreach($property_type as $k=>$v){
	        $ar['property_type'][] = ['id'=>$v->slug, 'name'=>$v->category_name];
	    }
	   // foreach($commercial as $k=>$v){
	   //     $ar['commercial'][] = ['id'=>$v->slug, 'name'=>$v->category_name];
	   // } 
	    $ar['communities']  = $this->getOffplanCommunityList($sect);
	    $ar['subCommunities']  = $this->getOffplanSubCommunityList($sect);
	    $ar['propertyNameList']  = $this->getPropertyNameList($sect);
	   
	    $sale_price   =   $this->salePrice();
        $rentPrice     =   $this->rentPrice(); 
        $ar['sale']['minPrice'][] = ['id'=>0, 'name'=>'All Price'];
        $ar['rent']['minPrice'][] = ['id'=>0, 'name'=>'All Price'];
        foreach($sale_price as $k=>$v){
            
            $ar['sale']['minPrice'][] = ['id'=>$k, 'name'=>$v];
            
        } 
        foreach($rentPrice as $k=>$v){
            $ar['rent']['minPrice'][] = ['id'=>$k, 'name'=>$v]; 
        }
	    $ar['year'] = $year_ar; 
	    $ar['offpla_category'] = $category_offplan_list;
          
       	Yii::app()->cache->set($cacheKey, $ar,60 * 60 * 1   );
     	 
	    echo CJSON::encode($ar);
		}
	}
	public function actionfetch_communities($type=null){
	    $residential = CHtml::listData(Category::model()->category_by_type('R'),'slug','category_name');
	    	echo CJSON::encode($residential);
	}
	public function actionregistration_interest()
	{
	       
		// Create an instance of the contact form model
		$model = new ProjectEnquiry();
       
		// Collect data from the request body
		if (isset($_REQUEST)) {
          
            $this->getValidateRecaptcha();
			$model->attributes = $_REQUEST;
            $model->phone = $_REQUEST['ph'];
            $model->meassage = $_REQUEST['message']; 
			// Validate the model
			if ($model->save()) {
                ContactUs::model()->sendRegisterInterestLeadToBitrix($model->name, $model->email, $model->phone, $model->meassage);
				// Perform the action (e.g., send an email or save data)
				// Here we can assume that the form is valid and we want to send a response
				Yii::app()->user->setFlash('contact', 'Thank you for your message.');
				// Send response to the React frontend
				echo CJSON::encode(array(
					'status' => 'success',
					'message' => Yii::t('app','Your message was successfully sent to the {p} Support Team. One of our representative will contact you soon.'  ,array('{p}'=>Yii::app()->options->get('system.common.site_name'))),
				));
			} else {
				// If validation fails
				$ar = 	$model->errors;
				if(isset($ar['phone'])){
				    $ar['ph'] = $ar['phone'];
				}
				if(isset($ar['meassage'])){
				    $ar['message'] = $ar['meassage'];
				}
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'There was an error with your form submission.',
					'errors' => $ar,
				));
			}
		}
	}
	public function actioncareer()
	{
	       
		// Create an instance of the contact form model
		$model = new CareerNew();
       
		// Collect data from the request body
		if (isset($_REQUEST)) {
            $this->getValidateRecaptcha();
			$model->attributes = $_REQUEST;
            $model->phone_false = str_replace(' ','',$_REQUEST['ph']);
            $model->master_id = $_REQUEST['category'];
            //$model->section  = $_REQUEST['sect']; 
            $model->cover_letter  = $_REQUEST['address']; 
			// Validate the model
			if ($model->save()) {
                 
                ContactUs::model()->sendRegisterInterestLeadToBitrix($model->name, $model->email, $model->phone, $model->cover_letter, 'Career');

                // Perform the action (e.g., send an email or save data)
                // Here we can assume that the form is valid and we want to send a response
                Yii::app()->user->setFlash('contact', 'Thank you for your message.');
				// Send response to the React frontend
				echo CJSON::encode(array(
					'status' => 'success',
					'message' => Yii::t('app', 'Thank you for your interest.One of our representative will contact you soon'),
				));
			} else {
				// If validation fails
				$ar = 	$model->errors;
				if(isset($ar['phone_false'])){
				    $ar['ph'] = $ar['phone_false'];
				}
				if(isset($ar['category_id'])){
				    $ar['category'] = $ar['category_id'];
				}
				if(isset($ar['section'])){
				  
				    $ar['sect'] = $ar['section'];  unset($ar['section']);
				}
				if(isset($ar['cover_letter'])){
				  
				    $ar['address'] = $ar['address'];  unset($ar['address']);
				}
				//print_r($ar);exit; 
				echo CJSON::encode(array(
					'status' => 'error',
					'message' => 'There was an error with your form submission.',
					'errors' => $ar,
				));
			}
		}
	}
	public function actionNew_offplan()
    { 
        $model = new PlaceAnAd();
        $featuredListingCriteria       =   $model->findAds(array('_sec_id'=>'3'), $count_future = false, $returnCriteria = 1, $calculate = false, $user_id = false);
        //$featuredListingCriteria->compare('featured', 'Y');
        $featuredListingCriteria->compare('t.section_id', '3');
        $featuredListingCriteria->limit = '8';
        $featuredListingCriteria->order = 't.id desc';
        $featuredListing =  $model->findAll($featuredListingCriteria);
         
        if (empty($featuredListing)) {
            return $this->renderJson(array(
                'status'    => 'error',
                'error'     => Yii::t('api', 'The property does not exist.')
            ), 404);
        } else {
            $article = Article::model()->findByAttributes(['article_id' => '414', 'status' => 'published']);
            $article_detail = []; 
            if ($article) {
                $article_detail = [
                    'heading'   =>  $article->title,
                    'content'   =>  $article->content, 
                    'call_to_action'    =>  $article->sub_title,
                    'call_to_action_link'    => '/offplan-properties-for-sale',
                ];
            }

            $data = []; 
            foreach ($featuredListing as $list) {
                $record = array(
                    'image'             =>
                    API_URL.   $list->OffplanImage,
                    'title'    =>  $list->AdTitle,
                    'location'    =>  $list->CommunityTitle,
                    'price'    =>  $list->PriceDetail,
                    'currency'    =>  $list->currencyTitle,
                    'DetailUrl' => str_replace('api/index.php/', '', $list->DetailUrl),
                );
               $data[] = $record;
            }

            return $this->renderJson(
                ['data'=> $data,'content'=> $article_detail],
                200
            ); 
        
    }
}
    public function actionhome_services_old()
{
    header('Content-Type: application/json');

    $services = [
        [
            'id' => 1,
            'title' => 'Property Management',
            'description' => 'We’re here to help you through every part of your real estate journey—whether it’s finding your perfect home or managing your property.',
            'image' => 'https://workspace.redspider-design.com/html/DSQ/assets/img/services-2.jpg',
        ],
        [
            'id' => 2,
            'title' => 'Holiday Home',
            'description' => 'We’re here to help you through every part of your real estate journey—whether it’s finding your perfect home or managing your property.',
            'image' => 'https://workspace.redspider-design.com/html/DSQ/assets/img/services-2.jpg',
        ],
        [
            'id' => 3,
            'title' => 'Real Estate Advisory',
            'description' => 'Get expert advice and personalized solutions for your real estate investments and decisions.',
            'image' => 'https://workspace.redspider-design.com/html/DSQ/assets/img/services-2.jpg',
        ],
    ];

    echo CJSON::encode($services);
    Yii::app()->end();
}
public function actionFooter_variables(){
   
    $options = Yii::app()->options; 
    $properties = [
            'facebook' => $options->get('system.common.facebook_url') ,
            'twitter' => $options->get(' system.common.twitter_new ') ,
            'instagram' => $options->get('system.common.pinterest_url'),
            'youtube' => $options->get('system.common.youtube_channel_url') ,
            'tiktok' => $options->get('system.common.tiktok_url'),
            'pintrest' => $options->get('system.common.snapchat_url'),
            'about' => $options->get('system.common.about'),
            'address' => $options->get('system.common.contact_address'),
            'phone' => $options->get('system.common.contact_phone'),
            'email' => $options->get('system.common.contact_email'),
            'whatsapp' => $options->get('system.common.linked_in'),
            'copy' => str_replace('{Y}',date('Y'),$options->get('system.common.copywrite_name')),
            'whatsappMessage' => "I am interested in this property.",
    ];
    echo CJSON::encode($properties);
    Yii::app()->end();
}
    public function actionContact_variable()
    {

        $article = Article::model()->findByAttributes(['article_id' => '423', 'status' => 'published']);
     


        $options = Yii::app()->options;
        $properties = [
            'phone' => $options->get('system.common.contact_phone'),
            'email' => $options->get('system.common.contact_email'),
            'address' => $options->get('system.common.contact_address'),
            'admin_email' => $options->get('system.common.admin_email'), 
            'opening' => nl2br($options->get('system.common.office_timing')),
            'alt_phone' => nl2br($options->get('system.common.alt_phone')),
            'telephone' => nl2br($options->get('system.common.telephone')),
            'alt_telephone' => nl2br($options->get('system.common.alt_telephone')),
            'banner'        => API_URL.'/uploads/files/'. @$article->banner,
            'headerTitle'        => @$article->title,
            'sub_title'        => @$article->sub_title,
            'content'        => @$article->content,
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionget_landing_page($code=null)
    {

        $article = Article::model()->findByAttributes([  'slug' => $code]); 
        $options = Yii::app()->options;
        $properties = [
            'phone' => $options->get('system.common.contact_phone'),
            'email' => $options->get('system.common.contact_email'),
            'address' => $options->get('system.common.contact_address'),
            'admin_email' => $options->get('system.common.admin_email'), 
            'opening' => nl2br($options->get('system.common.office_timing')),
            'alt_phone' => nl2br($options->get('system.common.alt_phone')),
            'telephone' => nl2br($options->get('system.common.telephone')),
            'alt_telephone' => nl2br($options->get('system.common.alt_telephone')),
            'banner'        => API_URL.'/uploads/files/'. @$article->banner,
            'headerTitle'        => @$article->title,
            'sub_title'        => @$article->sub_title,
            'content'        => @$article->content,
            'whatsapp' => $options->get('system.common.linked_in'),
            'whatsappMessage' => "I am interested in this property.",
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionFaq_items()
    {

        $article = Article::model()->findByAttributes(['article_id' => '435', 'status' => 'published']);

        $latest = [];
        $criteria = FAQ::model()->model()->search(1); 
        $criteria->condition .= ' and COALESCE(t.status,0)  ="published" ';
        $criteria->order = '-t.priority desc,t.article_id desc'; 
        $criteria->limit = '-1';
        $latestItems = FAQ::model()->findAll($criteria);
        $latest = [] ; 
        if ($latestItems) {
            foreach ($latestItems as $k => $v) {
                
                $latest[] = ['name' => $v->title,  'answer' => $v->content];
            }
        } 


        $options = Yii::app()->options;
        $properties = [
            'phone' => $options->get('system.common.contact_phone'),
            'email' => $options->get('system.common.contact_email'),
            'address' => $options->get('system.common.contact_address'),
            'admin_email' => $options->get('system.common.admin_email'), 
            'opening' => nl2br($options->get('system.common.office_timing')),
            'alt_phone' => nl2br($options->get('system.common.alt_phone')),
            'telephone' => nl2br($options->get('system.common.telephone')),
            'alt_telephone' => nl2br($options->get('system.common.alt_telephone')),
            'banner'        => API_URL.'/uploads/files/'. @$article->banner,
            'headerTitle'        => @$article->title,
            'sub_title'        => @$article->sub_title,
            'content'        => @$article->content,
            'faqs'        =>   $latest,
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionproperty_management()
    {

        $article = Article::model()->findByAttributes(['article_id' => '28', 'status' => 'published']); 
        $options = Yii::app()->options;
        $properties = [
            'phone' => $options->get('system.common.contact_phone'),
            'email' => $options->get('system.common.contact_email'),
            'address' => $options->get('system.common.contact_address'),
            'admin_email' => $options->get('system.common.admin_email'), 
            'opening' => nl2br($options->get('system.common.office_timing')),
            'alt_phone' => nl2br($options->get('system.common.alt_phone')),
            'telephone' => nl2br($options->get('system.common.telephone')),
            'alt_telephone' => nl2br($options->get('system.common.alt_telephone')),
            'banner'        => API_URL.'/uploads/files/'. @$article->banner,
            'headerTitle'        => @$article->title,
            'sub_title'        => @$article->sub_title,
            'content'        => @$article->content,
           
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionabout_offplan()
    {

        $article = Article::model()->findByAttributes(['article_id' => '485', 'status' => 'published']); 
        $content_1 = Article::model()->findByAttributes(['article_id' => '486', 'status' => 'published']); 
        $content_2 = Article::model()->findByAttributes(['article_id' => '487', 'status' => 'published']); 
        $properties = [
            'headerTitle'        => @$article->title,
            'sub_title'        => @$article->sub_title,
            'content'        => @$article->content,
            'content_one'   => [
                'title'  => @$content_1->title,
                'sub_title'  => @$content_1->sub_title,
                'content'  => @$content_1->content,
                'banner'    =>  API_URL.'uploads/files/'.$content_1->banner ,
            ],
            'content_two'   => [
                'title'  => @$content_2->title,
                'sub_title'  => @$content_2->sub_title,
                'content'  => @$content_2->content,
                'banner'    =>  API_URL.'uploads/files/'.$content_2->banner ,
            ]
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionoffplan_developer()
    {

        $article = Article::model()->findByAttributes(['article_id' => '488', 'status' => 'published']); 

        $properties = [
            'banner'    =>  API_URL.'uploads/files/'.$article->banner ,
            'image2'    =>    API_URL . 'uploads/files/' . $article->image2,
            'headerTitle'        => @$article->title,
            'sub_title'        => @$article->sub_title,
            'content'        => @$article->content,
           
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionprivacy_policy()
    {

        $article = Article::model()->findByAttributes(['article_id' => '30', 'status' => 'published']); 

        $properties = [
            'banner'    =>  API_URL.'uploads/files/'.$article->banner ,
            'image2'    =>    API_URL . 'uploads/files/' . $article->image2,
            'headerTitle'        => @$article->title,
            'sub_title'        => @$article->sub_title,
            'content'        => @$article->content,
           
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionterms_and_conditions()
    {

        $article = Article::model()->findByAttributes(['article_id' => '31', 'status' => 'published']); 

        $properties = [
            'banner'    =>  API_URL.'uploads/files/'.$article->banner ,
            'image2'    =>    API_URL . 'uploads/files/' . $article->image2,
            'headerTitle'        => @$article->title,
            'sub_title'        => @$article->sub_title,
            'content'        => @$article->content,
           
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionRental_yield_calculator()
    {

        $main_page_content = Article::model()->findByAttributes(['article_id' => '502', 'status' => 'published']);
        $sub_page_content = Article::model()->findByAttributes(['article_id' => '503', 'status' => 'published']);

        $properties = [
            'banner'    =>  API_URL.'uploads/files/'.$main_page_content->banner ,
            'image2'    =>    API_URL . 'uploads/files/' . $main_page_content->image2,
            'headerTitle'        => @$main_page_content->title,
            'sub_title'        => @$main_page_content->sub_title,
            'content'        => @$main_page_content->content,
            'page_title'     => @$main_page_content->page_title,
            
            'sub_banner'    =>  API_URL.'uploads/files/'.$sub_page_content->banner ,
            'sub_image2'    =>    API_URL . 'uploads/files/' . $sub_page_content->image2,
            'sub_headerTitle'        => @$sub_page_content->title,
            'sub_sub_title'        => @$sub_page_content->sub_title,
            'sub_content'        => @$sub_page_content->content,
            'sub_page_title'     => @$sub_page_content->page_title
           
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actioncookies_policy()
    {

        $article = Article::model()->findByAttributes(['article_id' => '32', 'status' => 'published']); 

        $properties = [
            'banner'    =>  API_URL.'uploads/files/'.$article->banner ,
            'image2'    =>    API_URL . 'uploads/files/' . $article->image2,
            'headerTitle'        => @$article->title,
            'sub_title'        => @$article->sub_title,
            'content'        => @$article->content,
           
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionconveyancing_page()
    {

        $article = Article::model()->findByAttributes(['article_id' => '490', 'status' => 'published']); 
        
        $article_content_1 = Article::model()->findByAttributes(['article_id' => '491', 'status' => 'published']); 
        
        $article_content_2 = Article::model()->findByAttributes(['article_id' => '492', 'status' => 'published']); 

        $properties = [
            'banner'    =>  API_URL.'uploads/files/'.$article->banner ,
            'image2'    =>    API_URL . 'uploads/files/' . $article->image2,
            'headerTitle'        => @$article->title,
            'sub_title'        => @$article->sub_title,
            'content'        => @$article->content,
            
            'ct1_banner'    =>  API_URL.'uploads/files/'.$article_content_1->banner ,
            'ct1_image2'    =>    API_URL . 'uploads/files/' . $article_content_1->image2,
            'ct1_headerTitle'        => @$article_content_1->title,
            'ct1_sub_title'        => @$article_content_1->sub_title,
            'ct1_content'        => @$article_content_1->content,
            
            'ct2_banner'    =>  API_URL.'uploads/files/'.$article_content_2->banner ,
            'ct2_image2'    =>    API_URL . 'uploads/files/' . $article_content_2->image2,
            'ct2_headerTitle'        => @$article_content_2->title,
            'ct2_sub_title'        => @$article_content_2->sub_title,
            'ct2_content'        => @$article_content_2->content,
           
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionSnagging_page()
    {

        $article = Article::model()->findByAttributes(['article_id' => '493', 'status' => 'published']); 
        
        $article_content_1 = Article::model()->findByAttributes(['article_id' => '494', 'status' => 'published']); 
        
        $article_content_2 = Article::model()->findByAttributes(['article_id' => '495', 'status' => 'published']); 

        $properties = [
            'banner'    =>  API_URL.'uploads/files/'.$article->banner ,
            'image2'    =>    API_URL . 'uploads/files/' . $article->image2,
            'headerTitle'        => @$article->title,
            'sub_title'        => @$article->sub_title,
            'content'        => @$article->content,
            
            'ct1_banner'    =>  API_URL.'uploads/files/'.$article_content_1->banner ,
            'ct1_image2'    =>    API_URL . 'uploads/files/' . $article_content_1->image2,
            'ct1_headerTitle'        => @$article_content_1->title,
            'ct1_sub_title'        => @$article_content_1->sub_title,
            'ct1_content'        => @$article_content_1->content,
            
            'ct2_banner'    =>  API_URL.'uploads/files/'.$article_content_2->banner ,
            'ct2_image2'    =>    API_URL . 'uploads/files/' . $article_content_2->image2,
            'ct2_headerTitle'        => @$article_content_2->title,
            'ct2_sub_title'        => @$article_content_2->sub_title,
            'ct2_content'        => @$article_content_2->content,
           
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionhom_settings()
    {

        $options = Yii::app()->options;
        $properties = [
            'video' => $options->get('system.common.home_video_url'), 
        ];
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    public function actionhome_about($lang=null)
    {
        $article = Article::model()->findByAttributes(['article_id'=> '413','status'=>'published']);
        if(!empty($lang)){ 
            $articleParent = Article::model()->findByAttributes(['parent_article' => '413', 'language'=> $lang ]);
            if(!empty($articleParent)){
                $article = $articleParent;
            }
        }
        $options = Yii::app()->options;
        if($article){
        $properties = [
                'heading'   =>  $article->title, 
                'content'   =>  $article->content, 
                'image1'    =>  API_URL.'uploads/files/'.$article->banner ,
                'image2'    =>    API_URL . 'uploads/files/' . $article->image2,
                'call_to_action'    =>  $article->sub_title,
                'call_to_action_link'    => '/article/about-us', 
        ];
        }
        echo CJSON::encode($properties);
        Yii::app()->end();
    }
    
    public function actionhome_services($lang=null)
    {
        $reviews = OurServices::model()->services($lang);

        if (empty($reviews)) {
            return $this->renderJson(array(
                'status'    => 'error',
                'error'     => Yii::t('api', 'The property does not exist.')
            ), 404);
        } else {

            $article = Article::model()->findByAttributes(['article_id' => '417', 'status' => 'published']);
            if (!empty($lang)) {
                $articleParent = Article::model()->findByAttributes(['parent_article' => '417', 'language' => $lang]);
                if (!empty($articleParent)) {
                    $article = $articleParent;
                }
            }
            $article_detail = [];
            if ($article) {
                $article_detail = [
                    'heading'   =>  $article->title,
                    'content'   =>  $article->content,
                    'call_to_action'    =>  $article->sub_title,
                    'call_to_action_link'    => '/#',
                ];
            }

            foreach ($reviews as $list) {
                if(!empty($lang)){
                    $list_check = Article::model()->findByAttributes(['parent_article' => $list->article_id, 'language' => $lang]);
                    if(!empty($list_check)){
                        $list   = $list_check; 
                    }
                }
                $banner = '/uploads/files/' . $list->banner ;
                $title = $list->title ;
                $content = $list->content ;
                $record = array(
                    'id' => $list->primaryKey,
                    'image'    => API_URL2 . str_replace('images', 'ads', $banner),
                    'title'    =>  $title,
                    'description' =>  $content,
                );
                $data[] = $record;
            }

            return $this->renderJson(['data'=>$data,'content'=> $article_detail] ,
                200
            );
        }
    }


    public function actionabout_us_service()
    {
        $reviews = AboutUsServices::model()->services();

        if (empty($reviews)) {
            return $this->renderJson(array(
                'status'    => 'error',
                'error'     => Yii::t('api', 'The property does not exist.')
            ), 404);
        } else {
            foreach ($reviews as $list) {
                $banner = '/uploads/files/' . $list->banner;
                $title = $list->title;
                $content = $list->content;
                $lines = explode(PHP_EOL, $list->page_title); // Split into array by new lines

                // Optional: Clean empty lines or whitespace
                $items = array_filter(array_map('trim', $lines));

                $record = array(
                    "title" => $title,
                    "image" => API_URL2 . str_replace('images', 'ads', $banner),
                    "alt"   => $title,
                    "items" => $items
                );

                $data[] = $record;
            }

            return $this->renderJson($data, 200);
        }
    }
    public function actionList_exclusive($lang=null)
    {
        //header('Content-Type: application/json');
        $article = Article::model()->findByAttributes(['article_id' => '442', 'status' => 'published']);
        if (!empty($lang)) {
            $articleParent = Article::model()->findByAttributes(['parent_article' => '442', 'language' => $lang]);
            if (!empty($articleParent)) {
                $article = $articleParent;  
            }
        }
        $model = new PlaceAnAd(); 
        $featuredListingCriteria       =   $model->findAds(array('_sec_id' => '3'), $count_future = false, $returnCriteria = 1, $calculate = false, $user_id = false);
        // $featuredListingCriteria->compare('featured', 'Y');
        $featuredListingCriteria->compare('t.section_id', '3');
        $featuredListingCriteria->compare('t.is_new', '1');
        $featuredListingCriteria->limit = '8';
        $featuredListingCriteria->order = 't.id desc';
        $featuredListing =  $model->findAll($featuredListingCriteria);

        if (empty($featuredListing)) {
            return $this->renderJson(array(
                'status'    => 'error',
                'error'     => Yii::t('api', 'The property does not exist.')
            ), 404);
        } else {
               $article_detail = [];
            if ($article) {
                $article_detail = [
                    'heading'   =>  $article->title,
                    'content'   =>  $article->content,
                    'call_to_action'    =>  $article->sub_title,
                    'call_to_action_link'    => '/offplan-properties-for-sale',
                    'article_id'   =>  $article->article_id,
                ];
            }

            $data = [];
            foreach ($featuredListing as $list) {
                $record = array(
                    'id' => $list->primaryKey,
                    'image'             => API_URL .   $list->OffplanImage,
                    'title'    =>  $list->AdTitle,
                    'location'    =>  $list->CommunityTitle,
                    'price'    =>  $list->PriceDetail,
                    'currency'    =>  $list->currencyTitle,
                    'tagline' => 'Coming Soon',
                    'DetailUrl' => str_replace('api/index.php/', '', $list->DetailUrl),
                );
                $data[] = $record;
            }

            return $this->renderJson(
                ['data' => $data, 'content' => $article_detail],
                200
            );
        }
          
        Yii::app()->end();
    }
    
    public function actionList_ready_properties($lang=null)
    {
        //header('Content-Type: application/json');
        $article = Article::model()->findByAttributes(['article_id' => '489', 'status' => 'published']);
        if (!empty($lang)) {
            $articleParent = Article::model()->findByAttributes(['parent_article' => '489', 'language' => $lang]);
            if (!empty($articleParent)) {
                $article = $articleParent;  
            }
        }
        $model = new PlaceAnAd(); 
        $featuredListingCriteria       =   $model->findAds(array('_sec_id' => '1'), $count_future = false, $returnCriteria = 1, $calculate = false, $user_id = false);
        $featuredListingCriteria->compare('featured', 'Y');
        $featuredListingCriteria->compare('t.section_id', '1');
        // $featuredListingCriteria->compare('t.is_new', '1');
        $featuredListingCriteria->limit = '8';
        $featuredListingCriteria->order = 't.id desc';
        $featuredListing =  $model->findAll($featuredListingCriteria);

        if (empty($featuredListing)) {
            return $this->renderJson(array(
                'status'    => 'error',
                'error'     => Yii::t('api', 'The property does not exist.')
            ), 404);
        } else {
               $article_detail = [];
            if ($article) {
                $article_detail = [
                    'heading'   =>  $article->title,
                    'content'   =>  $article->content,
                    'call_to_action'    =>  $article->sub_title,
                    'call_to_action_link'    => '/offplan-properties-for-sale',
                    'article_id'   =>  $article->article_id,
                ];
            }

            $data = [];
            foreach ($featuredListing as $list) {
                $record = array(
                    'id' => $list->primaryKey,
                    'image'             => API_URL.str_replace('images','ads',$list->ProfileImage),
                    'title'    =>  $list->AdTitle,
                    'location'    =>  $list->CommunityTitle,
                    'price'    =>  $list->PriceDetail,
                    'currency'    =>  $list->currencyTitle,
                    'tagline' => 'Coming Soon',
                    'DetailUrl' => str_replace('api/index.php/', '', $list->DetailUrl),
                );
                $data[] = $record;
            }

            return $this->renderJson(
                ['data' => $data, 'content' => $article_detail],
                200
            );
        }
          
        Yii::app()->end();
    }
    public function actionfeatured_homes($lang=null){
        //header('Content-Type: application/json');
        $article = Article::model()->findByAttributes(['article_id' => '443', 'status' => 'published']);
        if (!empty($lang)) {
            $articleParent = Article::model()->findByAttributes(['parent_article' => '443', 'language' => $lang]);
            if (!empty($articleParent)) {
                $article = $articleParent;
            }
        }
     
        $model = new PlaceAnAd();
        $featuredListingCriteria       =   $model->findAds(array(), $count_future = false, $returnCriteria = 1, $calculate = false, $user_id = false);
        $featuredListingCriteria->compare('featured', 'Y');
        $featuredListingCriteria->compare('t.section_id', '1');
        $featuredListingCriteria->compare('t.listing_type', 'R');
        //$featuredListingCriteria->compare('t.category_id', '30');
        $featuredListingCriteria->limit = '8';
        $featuredListingCriteria->order = 't.id desc';
        $featuredListing =  $model->findAll($featuredListingCriteria);

        if (empty($featuredListing)) {
            return $this->renderJson(array(
                'status'    => 'error',
                'error'     => Yii::t('api', 'The property does not exist.')
            ), 404);
        } else {
            $article_detail = [];
            if ($article) {
                $article_detail = [
                    'heading'   =>  $article->title,
                    'content'   =>  $article->content,
                    'call_to_action'    =>  $article->sub_title,
                    'call_to_action_link'    => '/offplan-properties-for-sale',
                    'article_id'    => $article->article_id,
                ];
            }

            $data = [];
            foreach ($featuredListing as $list) {
                $record = array(
                    'id' => $list->primaryKey,
                    'image'     =>  API_URL . str_replace('images', 'ads', $list->ProfileImage),
                    'title'    =>  $list->AdTitle,
                    'location'    =>  $list->CommunityTitle,
                    'price'    =>  $list->PriceDetail,
                    'currency'    =>  $list->currencyTitle,
                    'tagline' => 'Coming Soon',
                    'DetailUrl' => str_replace('api/index.php/', '', $list->DetailUrl),
                );
                $data[] = $record;
            }

            return $this->renderJson(
                ['data' => $data, 'content' => $article_detail],
                200
            );
        }

        Yii::app()->end();
         
    }
    public function actionautocomplete()
    {
        header('Content-Type: application/json');
        $term = Yii::app()->request->getParam('term');


        $criteria = new CDbCriteria; 
        $criteria->condition = '1 ';
        $criteria->distinct = 't.id';
        $criteria->join = ' left join {{community}} community on community.community_id = t.community_id  ';
        $criteria->condition  = '1 and community.slug is not null and community.community_name != "" ';
        $criteria->addSearchCondition('community.community_name', $term);
        $criteria->select = 'community.slug,community.community_name ';
        $criteria->order = 'community_name asc';
        $criteria->limit = 30;
        $results =  PlaceAnAd::model()->findAll($criteria);



        $response = array_map(function ($item) {
            return [
                'id' => $item->community_id,
                'label' => $item->community_name,
            ];
        }, $results);

        echo CJSON::encode($response);
        Yii::app()->end();
    }
    public function actionFilters()
    {
        $criteria = new CDbCriteria;
        $criteria->condition = '1 ';
        $criteria->distinct = 't.id';
        $criteria->join = ' left join {{community}} community on community.community_id = t.community_id  ';
        $criteria->condition  = '1 and community.slug is not null and community.community_name != "" ';
        $criteria->addSearchCondition('community.community_name', $term);
        $criteria->select = 'community.slug as slug ,community.community_name ';
        $criteria->order = 'community_name asc';
        $criteria->condition .= ' and community.community_id is not null '; 
       
        $results =  PlaceAnAd::model()->findAll($criteria);
        $community_data = array_map(function ($item) {
            return [
                'id' => $item->slug,
                'label' => $item->community_name,
            ];
        }, $results);
        $bedArray   =   $this->bedArray();
        $bathArray   =   $this->bathArray();
        $years =  CHtml::listData(Master::model()->listData(5), 'master_id', 'master_name')  ;
        $developer_list = Developers::model()->cacheclistDeveloper();
        $featured_amenities_list = Amenities::model()->cacheclistAmenities();
      
        $response = [
            'propertyTypes' => Category::model()->category_by_type_cache(),
            'prices' => $this->salePriceNew(),
            'rent_prices' => $this->rentPriceNew(),
            'beds' => $bedArray,
            'baths' => $bathArray,
            'years' => $years,
            'developers' => $developer_list,
            'community_data' => $community_data, 
            'locations' => ["1 JBR (Dubai)", "Downtown", "Marina"],
            'features' => [
                'general' => [],//["Off Plan Only", "Ready Homes Only", "Sold Only"],
                'extras' => $featured_amenities_list
            ]
        ];

        header('Content-Type: application/json');
        echo CJSON::encode($response);
        Yii::app()->end();
    }
    public function bedMultipleCondition($criteria,$offplan=false){
        $field = 't.bedrooms';
        if(!empty($offplan)){
            $field = 'apt1.bed';
            $criteria->join  .= ' left join {{ad_property_types}} apt1 ON apt1.ad_id = t.id    ';
        }
       
        $selectedBedrooms = explode('-or-', $_GET['beds']);
        $studioSelected = in_array(15, $selectedBedrooms);
        $sevenPlusSelected = in_array(7, $selectedBedrooms);
        $normalBedrooms = array_filter($selectedBedrooms, fn($v) => $v >= 1 && $v <= 6);
        $conditions = [];
        if (!empty($normalBedrooms)) {
            $conditions[] =  $field .' IN (' . implode(',', $normalBedrooms) . ')';
        }
        if ($studioSelected) {
            $conditions[] = $field.' = 15';
        }
        if ($sevenPlusSelected) {
            $conditions[] = $field.' >= 7';
        }
        if (!empty($conditions)) {
            $criteria->addCondition('(' . implode(' OR ', $conditions) . ')');
        }
        return $criteria;
    }
    public function amenitiesSearch($criteria,$offplan=false){
        $selectedAmenities = explode('-', $_GET['extras']);
        if(!empty($selectedAmenities)){
            $orCriteria = new CDbCriteria();
            $orCriteria->addInCondition('t.amenities_id', $selectedAmenities);
            $orCriteria->select = 'LOWER(TRIM(t.amenities_name)) as amenities_name';
            $Amenities = CHtml::listData(Amenities::model()->findAll($orCriteria),    'amenities_name',   'amenities_name');
            if(!empty($Amenities)){
                foreach ($Amenities as $amenity) {
                    $criteria->addSearchCondition(
                        'LOWER(TRIM(amnett.amenities_name))',
                        strtolower(trim($amenity)),
                        true, // partial match = LIKE '%value%'
                        'OR'  // combine multiple with OR
                    );
                }
            }
        } 
        return $criteria;
    }
    public function bathMultipleCondition($criteria)
    {
        $field = 't.bathrooms';
       
        $selectedBedrooms = explode('-or-', $_GET['baths']); 
        $sevenPlusSelected = in_array(7, $selectedBedrooms);
        $normalBedrooms = array_filter($selectedBedrooms, fn($v) => $v >= 1 && $v <= 6);
        $conditions = [];
        if (!empty($normalBedrooms)) {
            $conditions[] =  $field . ' IN (' . implode(',', $normalBedrooms) . ')';
        }
        
        if ($sevenPlusSelected) {
            $conditions[] = $field . ' >= 7';
        }
        if (!empty($conditions)) {
            $criteria->addCondition('(' . implode(' OR ', $conditions) . ')');
        }
        return $criteria;
    }
}
